/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.NioSslReceiveServer;
import org.maachang.comet.net.nio.ReceiveLinkQueue;

class NioSslReceiveServerArray {
    private static final int MIN_SIZE = 1;
    private NioSslReceiveServer[] recvs = null;
    private int size = -1;
    private volatile int seq = 0;

    private NioSslReceiveServerArray() {
    }

    public NioSslReceiveServerArray(ReceiveLinkQueue queue, int size) throws Exception {
        if (queue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (size <= 1) {
            size = 1;
        }
        NioSslReceiveServer[] rv = new NioSslReceiveServer[size];
        int i = 0;
        while (i < size) {
            rv[i] = new NioSslReceiveServer(queue);
            ++i;
        }
        this.recvs = rv;
        this.size = size;
        this.seq = 0;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.recvs != null) {
            int len = this.recvs.length;
            int i = 0;
            while (i < len) {
                if (this.recvs[i] != null) {
                    this.recvs[i].destroy();
                }
                this.recvs[i] = null;
                ++i;
            }
            this.recvs = null;
        }
    }

    public synchronized void setElement(NioElement element) throws Exception {
        if (element == null) {
            return;
        }
        if (this.recvs == null) {
            element.destroy();
            return;
        }
        if (this.seq >= this.size) {
            this.seq = 0;
        }
        this.recvs[this.seq].setElement(element);
        ++this.seq;
    }
}

