/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.ssl;

import java.io.FileInputStream;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.maachang.conf.Config;
import org.maachang.conf.ConvIniParam;

public class SslOption {
    private static final String SSL_SECTION = "ssl";
    private static final String KEYSTORE_SECTION = "keystore";
    private static final String TRUSTSTORE_SECTION = "truststore";
    public static final String DEFAULT_STORE = "JKS";
    public static final String DEFAULT_MANAGER_ALGORITHM = "SunX509";
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    public static final int DEFAULT_PORT = 3443;
    private String keyStore = "JKS";
    private String trustStore = "JKS";
    private String keyStorePasswd = null;
    private String trustPassword = null;
    private String keyManagerAlgorithm = "SunX509";
    private String trustKeyManagerAlgorithm = "SunX509";
    private String sslProtocol = "TLS";
    private String randomAlgorithm = null;
    private String keyStoreFile = null;
    private String trustFile = null;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    private int sslPort = 3443;
    private InetAddress sslAddress = null;
    private SSLContext ctx = null;

    public static final SslOption create(Config conf) {
        SslOption sslOpt = null;
        if (conf.isSection(SSL_SECTION) && ConvIniParam.getBoolean((String)conf.get(SSL_SECTION, SSL_SECTION, 0)) && conf.isSection(KEYSTORE_SECTION) && conf.get(KEYSTORE_SECTION, "key-file", 0) != null) {
            sslOpt = new SslOption();
            Object val = null;
            val = ConvIniParam.getInetAddress((String)conf.get(SSL_SECTION, "address", 0));
            if (val != null) {
                sslOpt.setSslAddress((InetAddress)val);
            }
            if ((val = conf.getIntObject(SSL_SECTION, "port", 0)) != null) {
                sslOpt.setSslPort((Integer)val);
            }
            if ((val = conf.get(SSL_SECTION, "protocol", 0)) != null) {
                sslOpt.setSslProtocol((String)val);
            }
            if ((val = conf.get(SSL_SECTION, "random-algorithm", 0)) != null) {
                sslOpt.setRandomAlgorithm((String)val);
            }
            if (conf.getBoolean(SSL_SECTION, "need-auth", 0)) {
                sslOpt.setNeedClientAuth(true);
            }
            if (conf.getBoolean(SSL_SECTION, "want-auth", 0)) {
                sslOpt.setWantClientAuth(true);
            }
            if ((val = conf.get(KEYSTORE_SECTION, "key-store", 0)) != null) {
                sslOpt.setKeyStore((String)val);
            }
            if ((val = conf.get(KEYSTORE_SECTION, "key-manager-algorithm", 0)) != null) {
                sslOpt.setKeyManagerAlgorithm((String)val);
            }
            if ((val = conf.get(KEYSTORE_SECTION, "key-passwd", 0)) != null) {
                sslOpt.setKeyStorePasswd((String)val);
            }
            if ((val = conf.get(KEYSTORE_SECTION, "key-file", 0)) != null) {
                sslOpt.setKeyStoreFile((String)val);
            }
            if (conf.isSection(TRUSTSTORE_SECTION) && conf.getBoolean(TRUSTSTORE_SECTION, "trust", 0)) {
                val = conf.get(TRUSTSTORE_SECTION, "trust-store", 0);
                if (val != null) {
                    sslOpt.setTrustStore((String)val);
                } else {
                    sslOpt.setTrustStore(null);
                }
                val = conf.get(TRUSTSTORE_SECTION, "trust-manager-algorithm", 0);
                if (val != null) {
                    sslOpt.setTrustKeyManagerAlgorithm((String)val);
                } else {
                    sslOpt.setTrustKeyManagerAlgorithm(null);
                }
                val = conf.get(TRUSTSTORE_SECTION, "trust-passwd", 0);
                if (val != null) {
                    sslOpt.setTrustPassword((String)val);
                } else {
                    sslOpt.setTrustPassword(null);
                }
                val = conf.get(TRUSTSTORE_SECTION, "trust-file", 0);
                if (val != null) {
                    sslOpt.setTrustFile((String)val);
                } else {
                    sslOpt.setTrustFile(null);
                }
            } else {
                sslOpt.setTrustStore(null);
                sslOpt.setTrustPassword(null);
                sslOpt.setTrustKeyManagerAlgorithm(null);
                sslOpt.setTrustFile(null);
            }
        }
        return sslOpt;
    }

    public SSLContext getSslContext() throws Exception {
        return this.getSslContext(false);
    }

    public synchronized SSLContext getSslContext(boolean recreate) throws Exception {
        if (recreate || this.ctx == null) {
            KeyManagerFactory keyFactory = null;
            if (this.getKeyStoreFile() != null && this.getKeyStore() != null && this.getKeyManagerAlgorithm() != null) {
                char[] keyStorePasswd = null;
                if (this.getKeyStorePasswd() != null && this.getKeyStorePasswd().length() > 0) {
                    keyStorePasswd = this.getKeyStorePasswd().toCharArray();
                }
                KeyStore keyStore = KeyStore.getInstance(this.getKeyStore());
                keyStore.load(new FileInputStream(this.getKeyStoreFile()), keyStorePasswd);
                keyFactory = KeyManagerFactory.getInstance(this.getKeyManagerAlgorithm());
                keyFactory.init(keyStore, keyStorePasswd);
            }
            TrustManagerFactory trustFactory = null;
            if (this.getTrustFile() != null && this.getTrustStore() != null && this.getTrustKeyManagerAlgorithm() != null) {
                char[] trustPasswd = null;
                if (this.getTrustPassword() != null && this.getTrustPassword().length() > 0) {
                    trustPasswd = this.getTrustPassword().toCharArray();
                }
                KeyStore trust = KeyStore.getInstance(this.getTrustStore());
                trust.load(new FileInputStream(this.getTrustFile()), trustPasswd);
                trustFactory = TrustManagerFactory.getInstance(this.getTrustKeyManagerAlgorithm());
                trustFactory.init(trust);
            }
            SecureRandom prng = null;
            if (this.getRandomAlgorithm() != null) {
                prng = SecureRandom.getInstance(this.getRandomAlgorithm());
            }
            SSLContext context = SSLContext.getInstance(this.getSslProtocol());
            if (prng != null) {
                context.init(keyFactory == null ? null : keyFactory.getKeyManagers(), trustFactory == null ? null : trustFactory.getTrustManagers(), prng);
            } else {
                context.init(keyFactory == null ? null : keyFactory.getKeyManagers(), trustFactory == null ? null : trustFactory.getTrustManagers(), null);
            }
            this.ctx = context;
        }
        return this.ctx;
    }

    public SSLEngine getSSLEngine() throws Exception {
        return this.getSSLEngine(false);
    }

    public SSLEngine getSSLEngine(boolean recreate) throws Exception {
        SSLContext context = this.getSslContext(recreate);
        SSLEngine ret = context.createSSLEngine();
        ret.setNeedClientAuth(this.isNeedClientAuth());
        ret.setWantClientAuth(this.isWantClientAuth());
        ret.setUseClientMode(false);
        return ret;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory(boolean recreate) throws Exception {
        SSLContext context = this.getSslContext(recreate);
        return context.getServerSocketFactory();
    }

    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        if (keyManagerAlgorithm == null || (keyManagerAlgorithm = keyManagerAlgorithm.trim()).length() <= 0) {
            keyManagerAlgorithm = null;
        }
        this.keyManagerAlgorithm = keyManagerAlgorithm;
    }

    public String getTrustKeyManagerAlgorithm() {
        return this.trustKeyManagerAlgorithm;
    }

    public void setTrustKeyManagerAlgorithm(String trustKeyManagerAlgorithm) {
        if (trustKeyManagerAlgorithm == null || (trustKeyManagerAlgorithm = trustKeyManagerAlgorithm.trim()).length() <= 0) {
            trustKeyManagerAlgorithm = null;
        }
        this.trustKeyManagerAlgorithm = trustKeyManagerAlgorithm;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        if (keyStore == null || (keyStore = keyStore.trim()).length() <= 0) {
            keyStore = null;
        }
        this.keyStore = keyStore;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        if (trustStore == null || (trustStore = trustStore.trim()).length() <= 0) {
            trustStore = null;
        }
        this.trustStore = trustStore;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        if (keyStoreFile == null || (keyStoreFile = keyStoreFile.trim()).length() <= 0) {
            keyStoreFile = null;
        }
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePasswd() {
        return this.keyStorePasswd;
    }

    public void setKeyStorePasswd(String keyStorePasswd) {
        if (keyStorePasswd == null || (keyStorePasswd = keyStorePasswd.trim()).length() <= 0) {
            keyStorePasswd = null;
        }
        this.keyStorePasswd = keyStorePasswd;
    }

    public String getTrustPassword() {
        return this.trustPassword;
    }

    public void setTrustPassword(String trustPassword) {
        if (trustPassword == null || (trustPassword = trustPassword.trim()).length() <= 0) {
            trustPassword = null;
        }
        this.trustPassword = trustPassword;
    }

    public String getRandomAlgorithm() {
        return this.randomAlgorithm;
    }

    public void setRandomAlgorithm(String randomAlgorithm) {
        if (randomAlgorithm == null || (randomAlgorithm = randomAlgorithm.trim()).length() <= 0) {
            randomAlgorithm = null;
        }
        this.randomAlgorithm = randomAlgorithm;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        if (sslProtocol == null || (sslProtocol = sslProtocol.trim()).length() <= 0) {
            sslProtocol = null;
        }
        this.sslProtocol = sslProtocol;
    }

    public String getTrustFile() {
        return this.trustFile;
    }

    public void setTrustFile(String trustFile) {
        if (trustFile == null || (trustFile = trustFile.trim()).length() <= 0) {
            trustFile = null;
        }
        this.trustFile = trustFile;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setSslPort(int sslPort) {
        this.sslPort = sslPort;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public void setSslAddress(InetAddress sslAddress) {
        this.sslAddress = sslAddress;
    }

    public InetAddress getSslAddress() {
        return this.sslAddress;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(" sslProtocol:" + this.getSslProtocol());
        buf.append(" sslPort:" + this.getSslPort());
        buf.append(" sslAddress:" + this.getSslAddress());
        buf.append(" needClientAuth:" + this.isNeedClientAuth());
        buf.append(" wantClientAuth:" + this.isWantClientAuth());
        buf.append(" randomAlgorithm:" + this.getRandomAlgorithm());
        buf.append(" keyStore:" + this.getKeyStore());
        buf.append(" keyManagerAlgorithm:" + this.getKeyManagerAlgorithm());
        buf.append(" keyStoreFile:" + this.getKeyStoreFile());
        if (this.getTrustStore() != null) {
            buf.append(" trustStore:" + this.getTrustStore());
            buf.append(" trustKeyManagerAlgorithm:" + this.getTrustKeyManagerAlgorithm());
            buf.append(" trustFile:" + this.getTrustFile());
        }
        return buf.toString();
    }
}

