/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.client.net;

import org.maachang.connector.ClientConnector;
import org.maachang.session.client.PSession;
import org.maachang.session.client.net.protocol.ClGetSessionKeyProtocol;
import org.maachang.session.client.net.protocol.ClPutSessionKeyProtocol;
import org.maachang.session.client.net.protocol.ClRemoveSessionKeyProtocol;
import org.maachang.session.client.net.protocol.ClUpdateSessionIdProtocol;
import org.maachang.session.client.net.protocol.IOClientProtocol;

class PSessionNetImpl
implements PSession {
    private ClientConnector conn = null;
    private String sessionId = null;
    private final ClPutSessionKeyProtocol putPlt = new ClPutSessionKeyProtocol();
    private final ClRemoveSessionKeyProtocol removePlt = new ClRemoveSessionKeyProtocol();
    private final ClGetSessionKeyProtocol getPlt = new ClGetSessionKeyProtocol();
    private final ClUpdateSessionIdProtocol updatePlt = new ClUpdateSessionIdProtocol();

    public PSessionNetImpl(String sessionId, ClientConnector conn) throws Exception {
        if (sessionId == null || conn == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.conn = conn;
        this.sessionId = sessionId;
    }

    protected void finalize() throws Exception {
        this.conn = null;
        this.sessionId = null;
    }

    public void put(String key, Object value) throws Exception {
        this.putPlt.clear();
        this.putPlt.create(this.sessionId, key, value);
        try {
            IOClientProtocol.execution(this.conn, this.putPlt, 7);
        }
        finally {
            this.putPlt.clear();
        }
    }

    public void remove(String key) throws Exception {
        this.removePlt.clear();
        this.removePlt.create(this.sessionId, key);
        try {
            IOClientProtocol.execution(this.conn, this.removePlt, 7);
        }
        finally {
            this.removePlt.clear();
        }
    }

    public Object get(String key) throws Exception {
        this.getPlt.clear();
        this.getPlt.create(this.sessionId, key);
        Object ret = null;
        try {
            IOClientProtocol.execution(this.conn, this.getPlt, 7);
            ret = this.getPlt.getResult();
        }
        finally {
            this.getPlt.clear();
        }
        return ret;
    }

    public String getSessionId() throws Exception {
        return this.sessionId;
    }

    public long getUpdateTime() throws Exception {
        this.updatePlt.clear();
        this.updatePlt.create(this.sessionId);
        long ret = -1L;
        try {
            IOClientProtocol.execution(this.conn, this.updatePlt, 7);
            Object v = this.updatePlt.getResult();
            if (v != null) {
                ret = (Long)v;
            }
        }
        finally {
            this.updatePlt.clear();
        }
        return ret;
    }
}

