/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.maachang.session.engine.CreateSessionMonThread;
import org.maachang.session.engine.SessionCache;
import org.maachang.util.RandomUtil;

class CreateSession {
    private static final long TIMEOUT = 30000L;
    private Map<String, Long> map = null;
    private SessionCache cacheSession = null;
    private CreateSessionMonThread thread = null;

    private CreateSession() {
    }

    protected CreateSession(SessionCache cacheSession) throws Exception {
        if (cacheSession == null || !cacheSession.isUse()) {
            throw new IllegalArgumentException("SessionCache\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.cacheSession = cacheSession;
            this.map = Collections.synchronizedMap(new HashMap());
            this.thread = new CreateSessionMonThread(this.map, 30000L);
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.thread != null) {
            this.thread.stopThread();
        }
        this.thread = null;
        if (this.map != null) {
            this.map.clear();
        }
        this.map = null;
        this.cacheSession = null;
    }

    public synchronized String createSessionKey() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        String ret = null;
        while (true) {
            if (!this.map.containsKey(ret = RandomUtil.randomString((int)48, (boolean)true, (boolean)true, (boolean)true)) && !this.cacheSession.containsKey(ret)) break;
            ret = null;
            try {
                Thread.sleep(30L);
            }
            catch (Exception exception) {}
        }
        this.map.put(ret, new Long(System.currentTimeMillis()));
        return ret;
    }

    public synchronized boolean containsKey(String sessionId) {
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            return false;
        }
        if (this.map.containsKey(sessionId)) {
            this.map.put(sessionId, new Long(System.currentTimeMillis()));
            return true;
        }
        return false;
    }

    public synchronized boolean isUse() {
        return this.map != null && this.cacheSession != null && this.cacheSession.isUse() && this.thread != null && !this.thread.isStop();
    }
}

