/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.maachang.conf.Config;
import org.maachang.dao.DaoSessionFactory;
import org.maachang.dao.dbms.DbmsInfo;
import org.maachang.dao.dbms.RecordFactory;

public class InitDao {
    public static final void init(String fileName) throws Exception {
        InitDao.init(DbmsInfo.getConfig(new FileInputStream(fileName)));
    }

    public static final void init(InputStream in) throws Exception {
        InitDao.init(DbmsInfo.getConfig(in));
    }

    public static final void init(Config config) throws Exception {
        RecordFactory factory = DbmsInfo.getRecordFactory(config);
        if (factory == null) {
            throw new IOException("RecordFactory\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        DaoSessionFactory.getInstance().setRecordFactory(factory);
    }

    public static final void init(boolean debug, String adapter, String driver, String url, String user, String passwd, int max, boolean autoCommit, String checkSQL) throws Exception {
        RecordFactory factory = DbmsInfo.getRecordFactory(debug, adapter, driver, url, user, passwd, max, autoCommit, checkSQL);
        if (factory == null) {
            throw new IOException("RecordFactory\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        DaoSessionFactory.getInstance().setRecordFactory(factory);
    }

    public static final void destroy() {
        RecordFactory recordFactory = DaoSessionFactory.getInstance().getRecordFactory();
        if (recordFactory != null) {
            recordFactory.clear();
            DaoSessionFactory.getInstance().setRecordFactory(null);
        }
    }
}

