/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.ctbl;

import java.util.HashSet;
import org.maachang.conf.Config;
import org.maachang.dao.dbms.ctbl.Table;
import org.maachang.dao.dbms.ctbl.TableUtil;

public class TableFireBird
implements Table {
    public String getAdapter() {
        return "firebirdsql";
    }

    public String createTable(Config params) {
        StringBuilder buf = new StringBuilder();
        Object[] sections = params.getSections();
        if (sections != null && sections.length > 0) {
            int len = sections.length;
            int i = 0;
            while (i < len) {
                if (sections[i] != null) {
                    this.createOneSection(buf, (String)sections[i], params);
                }
                ++i;
            }
            return buf.toString();
        }
        return null;
    }

    public String typeByBoolean() {
        return "CHAR(1)";
    }

    public String typeByInt() {
        return "INTEGER";
    }

    public String typeByLong() {
        return "BIGINT";
    }

    public String typeByFloat() {
        return "FLOAT";
    }

    public String typeByDouble() {
        return "DOUBLE PRECISION";
    }

    public String typeByBytes() {
        return "BLOB SUB_TYPE 0";
    }

    public String typeByChar() {
        return "VARCHAR(255)";
    }

    public String typeByText() {
        return "VARCHAR(32767)";
    }

    public String typeByDate() {
        return "DATE";
    }

    public String typeByTime() {
        return "TIME";
    }

    public String typeByTimestamp() {
        return "TIMESTAMP";
    }

    public String primaryKeyName() {
        return "PRIMARY KEY";
    }

    public String indexName() {
        return null;
    }

    public String notNullName() {
        return "NOT NULL";
    }

    public String uniqueName() {
        return "UNIQUE";
    }

    private void createOneSection(StringBuilder buf, String section, Config params) {
        if (section == null) {
            return;
        }
        String[] keys = params.getKeys(section);
        if (keys != null && keys.length > 0) {
            int len = keys.length;
            HashSet<String> primaryKey = new HashSet<String>();
            buf.append(this.dropTable(section));
            buf.append("create table ").append(section).append("(");
            buf.append("id BIGINT NOT NULL UNIQUE");
            boolean next = true;
            int i = 0;
            while (i < len) {
                if (next) {
                    buf.append(",");
                    next = false;
                }
                String key = keys[i];
                String type = null;
                String not_null = null;
                String unique = null;
                String[] one = params.getAll(section, key);
                int lenJ = one.length;
                int[] mode = new int[1];
                if (!"id".equals(key.toLowerCase()) && !TableUtil.isType(key)) {
                    int j = 0;
                    while (j < lenJ) {
                        String tmp = null;
                        tmp = TableUtil.getColumnName(this, one[j]);
                        if (tmp != null) {
                            type = tmp;
                        } else {
                            tmp = TableUtil.getColumnType(mode, this, one[j]);
                            if (tmp != null) {
                                switch (mode[0]) {
                                    case 1: {
                                        not_null = tmp;
                                        break;
                                    }
                                    case 2: {
                                        unique = tmp;
                                    }
                                }
                            } else {
                                if (TableUtil.isIndex(one[j])) {
                                    primaryKey.add(key.toLowerCase());
                                    not_null = this.notNullName();
                                }
                                if (TableUtil.isKey(one[j])) {
                                    primaryKey.add(key.toLowerCase());
                                    not_null = this.notNullName();
                                }
                            }
                        }
                        ++j;
                    }
                    if (type != null) {
                        buf.append(key.toLowerCase()).append(" ").append(type);
                        if (unique != null) {
                            buf.append(" ").append(unique);
                        }
                        if (not_null != null) {
                            buf.append(" ").append(not_null);
                        }
                        next = true;
                    }
                }
                ++i;
            }
            if (!buf.toString().endsWith(",")) {
                buf.append(",");
            }
            if (primaryKey.size() > 0) {
                buf.append(this.primaryKeyName()).append("(");
                buf.append("id");
                Object[] vals = primaryKey.toArray();
                int lenI = vals.length;
                int i2 = 0;
                while (i2 < lenI) {
                    buf.append(",").append(vals[i2]);
                    ++i2;
                }
                buf.append(")");
            } else {
                buf.append(this.primaryKeyName());
                buf.append("(id)");
            }
            buf.append(")");
            buf.append(" ; \n");
            buf.append("create sequence ").append(section.toLowerCase()).append("_id_seq").append("; \n");
        }
    }

    public String createTable(String name, Config config) {
        StringBuilder buf = new StringBuilder();
        this.createOneSection(buf, name, config);
        return buf.toString();
    }

    public String dropTable(String name) {
        StringBuilder buf = new StringBuilder();
        buf.append("drop table ").append(name).append("; \n");
        return buf.toString();
    }

    public String addColumn(String table, String column, Config config) {
        if ("id".equals(column.toLowerCase()) || TableUtil.isType(column)) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("alter table ").append(table).append(" add ");
        String type = null;
        String not_null = null;
        String unique = null;
        String[] one = config.getAll(table, column);
        int lenJ = one.length;
        int[] mode = new int[1];
        int j = 0;
        while (j < lenJ) {
            String tmp = null;
            tmp = TableUtil.getColumnName(this, one[j]);
            if (tmp != null) {
                type = tmp;
            } else {
                tmp = TableUtil.getColumnType(mode, this, one[j]);
                if (tmp != null) {
                    switch (mode[0]) {
                        case 1: {
                            not_null = tmp;
                            break;
                        }
                        case 2: {
                            unique = tmp;
                        }
                    }
                } else if (TableUtil.isIndex(one[j]) || TableUtil.isKey(one[j])) {
                    not_null = this.notNullName();
                }
            }
            ++j;
        }
        if (type == null) {
            return "";
        }
        buf.append(column.toLowerCase()).append(" ").append(type);
        if (unique != null) {
            buf.append(" ").append(unique);
        }
        if (not_null != null) {
            buf.append(" ").append(not_null);
        }
        buf.append("; \n");
        return buf.toString();
    }

    public String dropColumn(String table, String column) {
        if ("id".equals(column.toLowerCase()) || TableUtil.isType(column)) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("alter table ").append(table).append(" drop ").append(column).append("; \n");
        return buf.toString();
    }

    public String addPrimaryKey(String table, Config config) {
        String[] keys = config.getKeys(table);
        if (keys != null && keys.length > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("alter table ").append(table).append(" add ");
            int len = keys.length;
            HashSet<String> primaryKey = new HashSet<String>();
            int i = 0;
            while (i < len) {
                String key = keys[i];
                if (!"id".equals(key.toLowerCase()) && !TableUtil.isType(key)) {
                    String[] one = config.getAll(table, key);
                    int lenJ = one.length;
                    int j = 0;
                    while (j < lenJ) {
                        if (TableUtil.isIndex(one[j]) || TableUtil.isKey(one[j])) {
                            primaryKey.add(key.toLowerCase());
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (primaryKey.size() > 0) {
                buf.append(this.primaryKeyName()).append("(");
                buf.append("id");
                Object[] vals = primaryKey.toArray();
                int lenI = vals.length;
                int i2 = 0;
                while (i2 < lenI) {
                    buf.append(",").append(vals[i2]);
                    ++i2;
                }
                buf.append(")");
            } else {
                buf.append(this.primaryKeyName()).append("(id)");
            }
            buf.append(") ; \n");
            return buf.toString();
        }
        return "";
    }

    public String dropPrimaryKey(String table) {
        return "alter table " + table + " drop primary key ; \n";
    }

    public String dropSequence(String table) {
        StringBuilder buf = new StringBuilder();
        buf.append("drop sequence ").append(table).append("_id_seq").append("; \n");
        return buf.toString();
    }

    public String getBooleanByTrue() {
        return "1";
    }

    public String getBooleanByFalse() {
        return "0";
    }

    public int getUTF8CharSize(int size) {
        return size * 3;
    }

    public String getSemicolon() {
        return ";";
    }

    public boolean isInsertId() {
        return true;
    }

    public String convertTypeToData(String type, String value) {
        return value;
    }
}

