/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rawio.async;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.maachang.rawio.Baseio;
import org.maachang.rawio.async.ASyncQueue;
import org.maachang.rawio.async.ASyncWriteThread;
import org.maachang.rawio.async.ASyncio;
import org.maachang.rawio.async.ASyncioShutdown;
import org.maachang.rawio.mapping.Mappingio;
import org.maachang.rawio.mapping.MappingioInstance;

public class ASyncFactory {
    public static final long MODE_AUTO = 0L;
    public static final long MODE_DIRECT = 1L;
    public static final long MODE_EMULATOIN = 2L;
    private static final int DEF_ASYNC_BUFFER = 256;
    private static final int MIN_ASYNC_BUFFER = 32;
    private static final int MAX_ASYNC_BUFFER = Short.MAX_VALUE;
    private static final int MIN_ASYNC_THREAD = 1;
    private static final int MAX_ASYNC_THREAD = 32;
    private static final ASyncFactory SNGL = new ASyncFactory();
    private long mode = 0L;
    private ASyncQueue queue = null;
    private ASyncWriteThread[] thread = null;
    private int maxAsyncLength = -1;
    private boolean stopFlag = true;
    private final Object sync = new Object();
    private ArrayList<Baseio> imps = null;
    private ASyncioShutdown shutdown = null;

    private ASyncFactory() {
    }

    public static final ASyncFactory getInstance() {
        return SNGL;
    }

    public synchronized void init(int threadLength) throws Exception {
        this.init(0L, 256, threadLength);
    }

    public synchronized void init(int bufferLength, int threadLength) throws Exception {
        this.init(0L, bufferLength, threadLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(long mode, int bufferLength, int threadLength) throws Exception {
        if (this.queue != null) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u751f\u6210\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (threadLength < 1 || threadLength > 32) {
            throw new IllegalArgumentException("\u30b9\u30ec\u30c3\u30c9\u751f\u6210\u9577\u306f(1\uff5e32)\u306e\u9593\u3067\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        if (mode != 0L && mode != 1L && mode != 2L) {
            throw new IllegalArgumentException("\u751f\u6210\u30e2\u30fc\u30c9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (bufferLength <= 32) {
            bufferLength = 32;
        } else if (bufferLength >= Short.MAX_VALUE) {
            bufferLength = Short.MAX_VALUE;
        }
        ASyncQueue q = new ASyncQueue();
        ASyncWriteThread[] th = new ASyncWriteThread[threadLength];
        int i = 0;
        while (i < threadLength) {
            th[i] = new ASyncWriteThread(q);
            ++i;
        }
        this.mode = mode;
        this.queue = q;
        this.thread = th;
        this.maxAsyncLength = bufferLength;
        this.imps = new ArrayList();
        Object object = this.sync;
        synchronized (object) {
            this.stopFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        block13: {
            Baseio imp;
            if (this.queue == null) break block13;
            int len = this.imps.size();
            int i2 = 0;
            while (i2 < len) {
                imp = this.imps.get(i2);
                if (imp != null) {
                    try {
                        imp.flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i2;
            }
            while (this.queue.elementSize() > 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception i2) {}
            }
            Object i2 = this.sync;
            synchronized (i2) {
                this.stopFlag = true;
            }
            len = this.thread.length;
            int i22 = 0;
            while (i22 < len) {
                if (this.thread[i22] != null) {
                    this.thread[i22].destroy();
                }
                this.thread[i22] = null;
                ++i22;
            }
            len = this.imps.size();
            i22 = 0;
            while (i22 < len) {
                block17: {
                    block14: {
                        ASyncio asyncio;
                        block16: {
                            block15: {
                                imp = this.imps.get(i22);
                                if (imp == null) break block14;
                                asyncio = null;
                                if (imp.getType() != 2) break block15;
                                asyncio = (ASyncio)((Mappingio)imp).getBaseio();
                                if (asyncio != null) break block16;
                                break block17;
                            }
                            asyncio = (ASyncio)imp;
                        }
                        asyncio.destroy();
                    }
                    Object var3_6 = null;
                }
                ++i22;
            }
            this.imps.clear();
        }
        this.queue = null;
        this.thread = null;
        this.maxAsyncLength = -1;
        this.imps = null;
    }

    public synchronized void registShutdown() {
        if (this.queue != null && this.shutdown == null) {
            this.shutdown = new ASyncioShutdown();
            Runtime.getRuntime().addShutdownHook(this.shutdown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isStop() {
        boolean ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.stopFlag;
        }
        return ret;
    }

    public synchronized Baseio open(String name) throws Exception {
        return this.open(false, name);
    }

    public synchronized Baseio open(boolean mode, String name) throws Exception {
        if (this.queue == null) {
            throw new IOException("ASyncFactory\u306f\u751f\u6210\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        name = new File(name).getCanonicalPath();
        int len = this.imps.size();
        int i = 0;
        while (i < len) {
            Baseio impl = this.imps.get(i);
            if (impl != null && name.equals(impl.getName())) {
                return impl;
            }
            ++i;
        }
        Baseio impl = new ASyncio(this.mode, this, this.queue, this.maxAsyncLength, name);
        if (mode) {
            impl = MappingioInstance.getInstance(impl);
        }
        this.imps.add(impl);
        return impl;
    }

    public synchronized int getThreadSize() {
        return this.thread != null ? this.thread.length : 0;
    }

    public synchronized int getMaxBuffer() {
        return this.maxAsyncLength;
    }

    public synchronized boolean isUse() {
        return this.queue != null;
    }
}

