/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rawio.mapping;

import java.io.IOException;
import org.maachang.rawio.mapping.MappingChild;
import org.maachang.rawio.mapping.MappingOp;
import org.maachang.rawio.mapping.MappingioImpl;

class MappingOpImpl
implements MappingOp {
    private MappingioImpl impl = null;
    private MappingChild child = null;
    private Object sync = null;
    private int mask = -1;
    private int shift = -1;
    private int sectorMask = -1;

    private MappingOpImpl() {
    }

    public MappingOpImpl(MappingioImpl impl, MappingChild child, Object sync) throws Exception {
        int sector = child.getSector();
        int sh = this.getShift(sector);
        if (sh == -1) {
            throw new IOException("\u30bb\u30af\u30bf\u9577(" + sector + ")\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.impl = impl;
        this.child = child;
        this.sync = sync;
        this.mask = sector - 1;
        this.shift = sh;
        this.sectorMask = ~this.mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSector() {
        Object object = this.sync;
        synchronized (object) {
            block4: {
                if (this.impl.isUse()) break block4;
                return -1;
            }
            return this.child.getSector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStartPos() {
        Object object = this.sync;
        synchronized (object) {
            block4: {
                if (this.impl.isUse()) break block4;
                return -1;
            }
            return this.child.getStartPos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        Object object = this.sync;
        synchronized (object) {
            block4: {
                if (this.impl.isUse()) break block4;
                return -1;
            }
            return this.child.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBinaryLength() {
        Object object = this.sync;
        synchronized (object) {
            block4: {
                if (this.impl.isUse()) break block4;
                return -1;
            }
            return this.child.getStartPos() * this.child.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readBoolean(int pos) {
        boolean ret;
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.checkSpace(pos, pos);
            byte res = this.readEx(pos);
            ret = res != 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBoolean(boolean value, int pos) {
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.checkSpace(pos, pos);
            this.writeEx(value ? (byte)1 : 0, pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte(int pos) {
        byte ret;
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.checkSpace(pos, pos);
            byte res = this.readEx(pos);
            ret = res;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeByte(byte value, int pos) {
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.checkSpace(pos, pos);
            this.writeEx(value, pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char readChar(int pos) {
        char ret;
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.checkSpace(pos, pos + 1);
            ret = (char)(this.readEx(pos) & 0xFF);
            ret = (char)(ret | (char)((this.readEx(pos + 1) & 0xFF) << 8));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChar(char value, int pos) {
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.checkSpace(pos, pos + 1);
            this.writeEx((byte)(value & 0xFF), pos);
            this.writeEx((byte)((value & 0xFF00) >> 8), pos + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort(int pos) {
        short ret;
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.checkSpace(pos, pos + 1);
            ret = (short)(this.readEx(pos) & 0xFF);
            ret = (short)(ret | (short)((this.readEx(pos + 1) & 0xFF) << 8));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeShort(short value, int pos) {
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.checkSpace(pos, pos + 1);
            this.writeEx((byte)(value & 0xFF), pos);
            this.writeEx((byte)((value & 0xFF00) >> 8), pos + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt(int pos) {
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.checkSpace(pos, pos + 3);
            int ret = this.readEx(pos) & 0xFF;
            ret |= (this.readEx(pos + 1) & 0xFF) << 8;
            ret |= (this.readEx(pos + 2) & 0xFF) << 16;
        }
        return ret |= (this.readEx(pos + 3) & 0xFF) << 24;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInt(int value, int pos) {
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.checkSpace(pos, pos + 3);
            this.writeEx((byte)(value & 0xFF), pos);
            this.writeEx((byte)((value & 0xFF00) >> 8), pos + 1);
            this.writeEx((byte)((value & 0xFF0000) >> 16), pos + 2);
            this.writeEx((byte)((value & 0xFF000000) >> 24), pos + 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong(int pos) {
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.checkSpace(pos, pos + 7);
            long ret = (long)this.readEx(pos) & 0xFFL;
            ret |= ((long)this.readEx(pos + 1) & 0xFFL) << 8;
            ret |= ((long)this.readEx(pos + 2) & 0xFFL) << 16;
            ret |= ((long)this.readEx(pos + 3) & 0xFFL) << 24;
            ret |= ((long)this.readEx(pos + 4) & 0xFFL) << 32;
            ret |= ((long)this.readEx(pos + 5) & 0xFFL) << 40;
            ret |= ((long)this.readEx(pos + 6) & 0xFFL) << 48;
        }
        return ret |= ((long)this.readEx(pos + 7) & 0xFFL) << 56;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLong(long value, int pos) {
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.checkSpace(pos, pos + 7);
            this.writeEx((byte)(value & 0xFFL), pos);
            this.writeEx((byte)((value & 0xFF00L) >> 8), pos + 1);
            this.writeEx((byte)((value & 0xFF0000L) >> 16), pos + 2);
            this.writeEx((byte)((value & 0xFF000000L) >> 24), pos + 3);
            this.writeEx((byte)((value & 0xFF00000000L) >> 32), pos + 4);
            this.writeEx((byte)((value & 0xFF0000000000L) >> 40), pos + 5);
            this.writeEx((byte)((value & 0xFF000000000000L) >> 48), pos + 6);
            this.writeEx((byte)((value & 0xFF00000000000000L) >> 56), pos + 7);
        }
    }

    public byte[] readBytes(int pos, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] ret = new byte[length];
        this.readBytes(ret, pos, 0, length);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] out, int pos, int off, int length) {
        if (out == null || off <= -1 || length <= 0 || out.length < off + length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int ret = 0;
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            int i = 0;
            while (i < length) {
                int n = this.read(pos + i);
                if (n <= -1) break;
                out[off + i] = (byte)n;
                ++ret;
                ++i;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeBytes(byte[] value, int pos, int off, int length) {
        if (value == null || off <= -1 || length <= 0 || value.length < off + length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int ret = 0;
        Object object = this.sync;
        synchronized (object) {
            if (!this.impl.isUse()) {
                throw new IllegalArgumentException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            int i = 0;
            while (i < length) {
                if (!this.write(value[off + i], pos + i)) break;
                ++ret;
                ++i;
            }
        }
        return ret;
    }

    private int getShift(int sector) {
        switch (sector) {
            case 512: {
                return 9;
            }
            case 1024: {
                return 10;
            }
            case 2048: {
                return 11;
            }
            case 4096: {
                return 12;
            }
            case 8192: {
                return 13;
            }
            case 16384: {
                return 14;
            }
            case 32768: {
                return 15;
            }
            case 65536: {
                return 16;
            }
        }
        return -1;
    }

    private int getSector(int pos) {
        return (pos & this.sectorMask) >> this.shift;
    }

    private int getNo(int pos) {
        return pos & this.mask;
    }

    private int read(int pos) {
        int sno = this.getSector(pos);
        int no = this.getNo(pos);
        if (sno >= this.child.length()) {
            return -1;
        }
        byte[] b = this.child.get(sno);
        return b[no] & 0xFF;
    }

    private boolean write(byte bin, int pos) {
        int sno = this.getSector(pos);
        int no = this.getNo(pos);
        if (sno >= this.child.length()) {
            return false;
        }
        byte[] b = this.child.get(sno);
        b[no] = bin;
        this.child.updatePos(sno);
        return true;
    }

    private byte readEx(int pos) {
        byte[] b = this.child.get(this.getSector(pos));
        return b[this.getNo(pos)];
    }

    private void writeEx(byte bin, int pos) {
        int sno = this.getSector(pos);
        byte[] b = this.child.get(sno);
        b[this.getNo((int)pos)] = bin;
        this.child.updatePos(sno);
    }

    private void checkSpace(int base, int pos) {
        if (this.getSector(pos) >= this.child.length()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3[" + base + "]\u306fMapping\u7bc4\u56f2\u5916\u3067\u3059");
        }
    }
}

