//
// HTTP系スクリプト.
//

////////////////////////////////////////////////////////////////////////////////
// リクエスト取得省略形メソッド群.
////////////////////////////////////////////////////////////////////////////////

// 指定内容のリクエストパラメータを取得.
$ = function(name,num) {
    return getRequestParam(name,num) ;
} ;

// 指定内容のリクエストパラメータ数を取得.
$s = function(name) {
    return getRequestParamBySize(name) ;
} ;

// 指定内容のリクエストヘッダを取得.
$h = function(name,num) {
    return getRequestHeader(name,num) ;
}

// 指定内容のリクエストヘッダサイズを取得.
$hs = function(name) {
    return getRequestHeaderBySize(name) ;
}

// 指定内容をタグ系文字をHTML表示可能に変換.
$html = function( value ) {
    if( isNull( value ) == false ) {
        var t = valueof( value ) ;
        if( t == 'string' ) {
            return ""+org.maachang.comet.httpd.engine.script.js.JsDef.convertByViewHtml(
                true,value ) ;
        }
        return value ;
    }
    return "" ;
} ;

// リクエストパラメータを出力(文字列の場合、タグ系文字をHTML表示可能に変換).
$params = function( name,num ) {
    var x = getRequestParam( name,num ) ;
    if( isNull( x ) == false && useString( x ) ) {
        return $html(parseValue(x)) ;
    }
    else {
        return "" ;
    }
} ;

////////////////////////////////////////////////////////////////////////////////
// HTTP系.
////////////////////////////////////////////////////////////////////////////////

// 現在のスクリプトパスを取得.
getPath = function() {
    if( isNull( _$script$path ) ) {
        return null ;
    }
    return _$script$path ;
} ;

// アクセス先がSSLであるかチェック.
isSsl = function() {
    if( __$type$script != "console" && isNull( _$script$request ) == false ) {
        if( _$script$request.isSsl() == true ) {
            return true ;
        }
        else {
            return false ;
        }
    }
    return false ;
}

// Host名を取得.
getHostName = function() {
    if( __$type$script != "console" && isNull( _$script$request ) == false ) {
        var ret = null ;
        if( _$script$request.isSsl() == true ) {
            ret = "https://" ;
        }
        else {
            ret = "http://" ;
        }
        return ret + _$script$header.getHeader("Host",0) ;
    }
    return "" ;
}

// SSLが有効であるかチェック.
isUseSsl = function() {
    return ( getConfig( "ssl","ssl",0 ) == true ) ;
}

// 指定モードで、現在のURLを取得.
getUrlByMode = function( mode ) {
    if( __$type$script != "console" && isNull( _$script$request ) == false ) {
        var ret = null ;
        var port = -1 ;
        if( mode == true ) {
            mode = isUseSsl() ;
        }
        if( mode == true ) {
            ret = "https://" ;
            port = getConfig( "ssl","port",0 ) ;
            if( port == 443 ) {
                port = "" ;
            }
            else {
                port = ":" + port ;
            }
        }
        else {
            ret = "http://" ;
            port = getConfig( "net","server-port",0 ) ;
            if( port == 80 ) {
                port = "" ;
            }
            else {
                port = ":" + port ;
            }
        }
        var host = _$script$header.getHeader("Host",0) ;
        var p = host.indexOf( ":" ) ;
        if( p != -1 ) {
            host = host.substring( 0,p ) ;
        }
        return ret + host + port ;
    }
    return "" ;
}

// セッションパラメータ名.
sessionParam = function() {
    return "_maachang-session" ;
} ;

// セッション付加条件を取得.
isSessionLink = function() {
    var req = getRequest() ;
    if( isNull( req ) == false ) {
        return ( req.isCookie() == true ) ;
    }
    return false ;
}

// 指定パスをマージ.
margePathName = function( name ) {
    if( useString( name ) == false ) {
        getPath() ;
    }
    return ""+org.maachang.comet.httpd.engine.script.ScriptDef.convertApplicationName( getPath(),name ) ;
}

// 指定パスをマージしてURL形式で出力.
margeAndFullPathName = function( name ) {
    name = margePathName( name ) ;
    var x = toLowerCase( name ) ;
    if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
        return name ;
    }
    else {
        if( startsWith( name,"/" ) ) {
            return getHostName()+name ;
        }
        else {
            return getHostName()+"/"+name ;
        }
    }
}

// リクエストが利用可能かチェック.
isRequest = function() {
    if( __$type$script != "console" && isNull( _$script$request ) == false ) {
        return true ;
    }
    return false ;
} ;

// リクエストパラメータが利用可能かチェック.
isRequestParam = function() {
    if( __$type$script != "console" && isNull( _$script$query ) == false ) {
        return true ;
    }
    return false ;
} ;

// リクエスト情報を取得.
getRequest = function() {
    if( isRequest() ) {
        return _$script$request ;
    }
    return null ;
} ;

// リクエストパラメータを取得.
getRequestParam = function(name,num) {
    if( isNull( name ) ) {
        return "" ;
    }
    if( isRequestParam() ) {
        var query = _$script$request.getQuery() ;
        if( isNull( num ) ) {
            return query.getParam(name) ;
        }
        else {
            return query.getParam(name,num) ;
        }
    }
    return "" ;
} ;

// リクエストパラメータ数を取得.
getRequestParamBySize = function(name) {
    if( isNull( name ) ) {
        return 0 ;
    }
    if( isRequestParam() ) {
        var query = _$script$request.getQuery() ;
        return query.size(name) ;
    }
    return 0 ;
} ;


// リクエストヘッダ情報を取得.
getRequestHeader = function(key,num) {
    if( isNull( key ) ) {
        return "" ;
    }
    if( isRequest() ) {
        if( isNull( num ) ) {
            return _$script$header.getHeader(key) ;
        }
        return _$script$header.getHeader(key,num) ;
    }
} ;

// リクエストヘッダ情報の指定キー名数を取得.
getRequestHeaderBySize = function(key) {
    if( isNull( key ) ) {
        return 0 ;
    }
    if( isRequest() ) {
        return _$script$header.size(key) ;
    }
    return 0 ;
} ;

// リクエストBodyをBinaryで取得.
getRequestBodyByBinary = function() {
    if( isRequest() && getScriptDetail() != "comet" ) {
        var ret = _$script$request.getBodyByBinary() ;
        if( ret != null && binaryLength( ret ) <= 0 ) {
            return ret ;
        }
    }
    return null ;
} ;

// リクエストBodyを文字列で取得.
getRequestBody = function( charset ) {
    if( isNull( charset ) ) {
        charset = "UTF8" ;
    }
    var ret = getRequestBody() ;
    if( isNull( ret ) == false ) {
        return convertBinaryByString( ret,charset ) ;
    }
    return null ;
} ;

// HTTPバージョンを取得.
getHttpVersion = function() {
    if( isRequest() ) {
        return _$script$request.getVersion() ;
    }
    return null ;
} ;

// HTTPメソッドを取得.
getHttpMethod = function() {
    if( isRequest() ) {
        return _$script$request.getMethod() ;
    }
    return null ;
} ;

// HTTP-URLPathを取得.
getURLPath = function() {
    if( isRequest() ) {
        return _$script$request.getUrlPath() ;
    }
    return null ;
} ;

// 現在読み込まれているMTHMLファイル名を取得.
getMTHMLPath = function() {
    if( isRequest() ) {
        var err = false ;
        var ret = "" ;
        try {
            ret = _$script$lastMHTML ;
        } catch( e ) {
            ret = "" ;
        }
        return ret ;
    }
    return null ;
} ;

// 正常メッセージを登録.
setSuccessMessage = function(msg,id) {
    if( isRequestParam() == false ) {
        return false ;
    }
    if( isNull( id ) ) {
        id = 0 ;
    }
    if( __$type$script == "script" && useString( msg ) == true ) {
        _$script$query.put('_validateSuccess'+id,msg) ;
    }
} ;

// Validateエラーが存在するかチェック.
isErrorMessage = function(id) {
    if( isRequestParam() == false ) {
        return false ;
    }
    if( __$type$script == "script" ) {
        if( isNull( id ) ) {
            return useString( _$script$query.get( "_validateError" ) ) ;
        }
        return useString( _$script$query.get( "_validateError"+id ) ) ;
    }
    return false ;
} ;

// Validateエラーメッセージを登録.
setErrorMessage = function(msg,id) {
    if( isRequestParam() == false ) {
        return false ;
    }
    if( isNull( id ) ) {
        id = 0 ;
    }
    if( __$type$script == "script" && useString( msg ) == true ) {
        _$script$query.put('_validateError',"true" ) ;
        if( useString( _$script$query.get('_validateError'+id) ) == false ) {
            _$script$query.put('_validateError'+id,msg) ;
        }
        else {
            var m = _$script$query.get('_validateError'+id) ;
            _$script$query.put('_validateError'+id,m+"<BR>"+msg) ;
        }
    }
} ;

// レスポンスが利用可能かチェック.
isResponse = function() {
    if( __$type$script != "console" && isNull( _$script$response ) == false ) {
        return true ;
    }
    return false ;
} ;

// HttpdResponseを取得.
getHttpdResponse = function() {
    if( isResponse() ) {
        return _$script$response ;
    }
    return null ;
} ;

// GZIPをOFFに設定.
gzipOff = function() {
    if( isResponse() ) {
        _$script$response.setGzip( false ) ;
    }
} ;

// GZIPをONに設定.
gzipOn = function() {
    if( isResponse() ) {
        _$script$response.setGzip( true ) ;
    }
} ;

// GZIPモードを取得.
getGzipMode = function() {
    if( isResponse() ) {
        return _$script$response.getGzip() ;
    }
    return false ;
} ;

// キャッシュOFFに設定.
cacheOff = function() {
    if( isResponse() ) {
        _$script$response.setHttpCache( true ) ;
    }
} ;

// キャッシュONに設定.
cacheOn = function() {
    if( isResponse() ) {
        _$script$response.setHttpCache( false ) ;
    }
} ;

// キャッシュONに設定.
getCacheMode = function() {
    if( isResponse() ) {
        return _$script$response.getHttpCache() ;
    }
    return false ;
} ;

// KeepAliveをOFFに設定.
keepAliveOff = function() {
    if( isResponse() ) {
        _$script$response.setHttpClose( true ) ;
    }
} ;

// KeepAliveをONに設定.
keepAliveOn = function( timer ) {
    if( isResponse() ) {
        _$script$response.setHttpClose( false ) ;
        if( isNumeric( timer ) == true ) {
            getRequest.setKeepAliveTimeout( timer ) ;
        }
    }
} ;

// KeepAliveモードを取得.
getKeepAliveMode = function() {
    if( isResponse() ) {
        return ( _$script$response.getHttpClose() == false ) ;
    }
    return false ;
} ;

// レスポンスヘッダ情報を設定.
addResponseHeader = function(key,value) {
    if( isNull( key ) ) {
        return -1 ;
    }
    if( isNull( value ) ) {
        value = null ;
    }
    if( isResponse() ) {
        _$script$response.getHeader().addHeader( key,value ) ;
    }
} ;

// レスポンスヘッダ情報を設定.
setResponseHeader = function(key,value) {
    if( isNull( key ) ) {
        return -1 ;
    }
    if( isNull( value ) ) {
        value = null ;
    }
    if( isResponse() ) {
        _$script$response.getHeader().setHeader( key,value ) ;
    }
} ;

// レスポンスにコンテンツタイプを設定.
setContentType = function(contentType) {
    if( isNull( contentType ) ) {
        return -1 ;
    }
    setResponseHeader( "Content-Type",contentType ) ;
} ;

// ダウンロード情報として、レスポンスを設定.
setDownloadContent = function(name) {
    if( useString( name ) == false ) {
        return -1 ;
    }
    setResponseHeader( "Content-Disposition","attachment; filename="+name ) ;
    setResponseHeader( "Content-Type",getMimeType(name) ) ;
} ;

// リダイレクト処理.
redirect = function(url) {
    if( isNull( url ) ) {
        return -1 ;
    }
    if( __$type$script == "script" && isResponse() ) {
        cacheOff() ;
        if( isSessionLink() == true ) {
            if( url.indexOf( "?" ) == -1 ) {
                url += "?t="+( new Date().getTime() ) ;
            }
            else {
                url += "&t="+( new Date().getTime() ) ;
            }
        }
        else if( url.indexOf( sessionParam() ) == -1 ) {
            if( url.indexOf( "?" ) == -1 ) {
                url += "?t="+( new Date().getTime() )+"&"+sessionParam()+"="+getSessionId() ;
            }
            else {
                url += "&t="+( new Date().getTime() )+"&"+sessionParam()+"="+getSessionId() ;
            }
        }
        getHttpdResponse().setState( 303 ) ;
        setResponseHeader( "Location",url ) ;
        _exit( "redirect" ) ;
    }
} ;

// リダイレクト処理.
// HTTP1.1で、POSTの場合は、その情報を引き継いで処理します.
// それ以外の条件では、通常のりダイレクトと同じになります.
redirectPost = function(url) {
    if( isNull( url ) ) {
        return -1 ;
    }
    if( __$type$script == "script" && isResponse() ) {
        cacheOff() ;
        if( isSessionLink() == true ) {
            if( url.indexOf( "?" ) == -1 ) {
                url += "?t="+( new Date().getTime() ) ;
            }
            else {
                url += "&t="+( new Date().getTime() ) ;
            }
        }
        else if( url.indexOf( sessionParam() ) == -1 ) {
            if( url.indexOf( "?" ) == -1 ) {
                url += "?t="+( new Date().getTime() )+"&"+sessionParam()+"="+getSessionId() ;
            }
            else {
                url += "&t="+( new Date().getTime() )+"&"+sessionParam()+"="+getSessionId() ;
            }
        }
        if( getRequest().getMethod() == "POST" &&
            getRequest().getVersion() == "1.1" ) {
            getHttpdResponse().setState( 307 ) ;
        }
        else {
            getHttpdResponse().setState( 303 ) ;
        }
        setResponseHeader( "Location",url ) ;
        _exit( "redirect" ) ;
    }
} ;

// 現在のページにリダイレクト.
redirectNowPage = function( mode ) {
    var url = ( mode == true ) ? getUrlByMode( true ) : ( ( mode == false ) ? getUrlByMode( false ) : getHostName() ) ;
    if( isNull( params ) || params.length <= 0 ) {
        redirect( url+getURLPath() ) ;
    }
    else {
        redirect( url+getURLPath() + "?" + convertMapToGetParams( params ) ) ;
    }
}

// 指定MHTMLにforward.
forwardMHTML = function(name) {
    if( isNull( name ) ) {
        return -1 ;
    }
    //name = "" + name ;
    if( isResponse() ) {
        if( getHttpdResponse().isOutputStream() == true ) {
            _exit( "forward" ) ;
        }
        if( endsWith( name,".ms" ) == true ) {
            return -1 ;
        }
        if( endsWith( name,".mhtml" ) == false ) {
            name += ".mhtml" ;
        }
        name = margePathName( name ) ;
        var factory = _$$maachang_comet_manager.get( "WEBAPP_FACTORY" ) ;
        if( factory.isApplication( name ) == false ) {
            _exit( "error404" ) ;
        }
        var exec = factory.getApplication( name ) ;
        exec.getScript().eval( _$script$context ) ;
        _exit( "forward" ) ;
    }
} ;

// 指定コントローラにforward.
forwardController = function(name) {
    if( isNull( name ) ) {
        return -1 ;
    }
    //name = "" + name ;
    if( isResponse() ) {
        if( getHttpdResponse().isOutputStream() == true ) {
            _exit( "forward" ) ;
        }
        if( endsWith( name,".mhtml" ) == true ) {
            name = name.substring( 0,name.length - ".mhtml".length ) ;
        }
        else if( endsWith( name,".ms" ) == true ) {
            name = name.substring( 0,name.length - ".ms".length ) ;
        }
        if( endsWith( name,"Controller" ) == true ) {
            name = name.substring( 0,name.length - "Controller".length ) ;
        }
        var cnt = name + "Controller.ms" ;
        cnt = margePathName( cnt ) ;
        var factory = _$$maachang_comet_manager.get( "WEBAPP_FACTORY" ) ;
        if( factory.isApplication( cnt ) == false ) {
            var mhtml = name + ".mhtml" ;
            mhtml = margePathName( mhtml ) ;
            if( factory.isApplication( mhtml ) == false ) {
                _exit( "error404" ) ;
            }
            name = mhtml ;
        }
        else {
            name = cnt ;
        }
        var exec = factory.getApplication( name ) ;
        exec.getScript().eval( _$script$context ) ;
        _exit( "forward" ) ;
    }
} ;

// 指定スクリプトを取り込む.
include = function(name) {
    if( isNull( name ) ) {
        return -1 ;
    }
    if( isResponse() ) {
        if( endsWith( name,".mhtml" ) == true ) {
            return -1 ;
        }
        if( endsWith( name,".ms" ) == false ) {
            name += ".ms" ;
        }
        if( name == currentName() ) {
            return -1 ;
        }
        var factory = _$$maachang_comet_manager.get( "WEBAPP_FACTORY" ) ;
        if( factory.isApplication( name ) == false ) {
            _exit( "error404" ) ;
        }
        var exec = factory.getApplication( name ) ;
        exec.getScript().eval( _$script$context ) ;
    }
} ;

// 指定ファイルで、HTTPレスポンスに返す.
responseToFile = function(fileName) {
    if( isNull( fileName ) ) {
        return -1 ;
    }
    if( isResponse() ) {
        setResponseHeader( "Content-Type",getMimeType( fileName ) ) ;
        var indata = new java.io.FileInputStream( fileName ) ;
        org.maachang.comet.httpd.engine.script.js.JsDef.putResponseByData( _$script$response,indata ) ;
    }
} ;

// 指定名のMimeタイプを取得.
getMimeType = function(fileName) {
    if( isNull( fileName ) ) {
        return "Application/Octet-Stream" ;
    }
    if( isNull( _$$maachang_comet_manager ) == false &&
        isNull( _$$maachang_comet_manager.get( "MIME_TYPE" ) ) == false ) {
        return _$$maachang_comet_manager.get( "MIME_TYPE" ).getNameByMimeType( fileName ) ;
    }
    return "Application/Octet-Stream" ;
} ;

// 指定バイナリを、HTTPレスポンスに返す.
responseToBinary = function(binary,mimeType) {
    if( isNull( binary ) ) {
        return -1 ;
    }
    if( isResponse() ) {
        if( useString( mimeType ) ) {
            setResponseHeader( "Content-Type",mimeType ) ;
        }
        var indata = new java.io.ByteArrayInputStream( binary ) ;
        org.maachang.comet.httpd.engine.script.js.JsDef.putResponseByData( _$script$response,indata ) ;
    }
} ;

// 指定文字列をHTTPレスポンスに渡す.
httpPrint = function(data) {
    if( isNull( data ) ) {
        return -1 ;
    }
    if( isResponse() ) {
        //print( ">>>"+data ) ;
        _$script$response.getPrint().print( ""+data ) ;
    }
} ;

// 指定文字列をHTTPレスポンスに渡す.
httpPrintln = function(data) {
    if( isNull( data ) ) {
        return -1 ;
    }
    if( isResponse() ) {
        //println( ">>>"+data ) ;
        _$script$response.getPrint().println( ""+data ) ;
    }
} ;

// 指定URLをエンコード.
urlEncode = function( url,charset ) {
    if( isNull( url ) ||
        ( typeof( url ) != "string" && ( url instanceof java.lang.String ) == false ) ||
        useString( url ) == false ) {
        return url ;
    }
    if( isNull( charset ) ) {
        charset = null ;
    }
    var flg = false ;
    var val = null ;
    var p = url.indexOf( "?" ) ;
    if( p >= 0 ) {
        flg = true ;
        val = url.substring( p+1 ) ;
    }
    else {
        val = url ;
    }
    val = org.maachang.comet.httpd.engine.script.js.JsDef.convertURL( true,val,charset ) ;
    if( flg == true ) {
        url = url.substring( 0,p+1 ) + val ;
    }
    else {
        url = val ;
    }
    return url ;
} ;

// 指定URLをデコード.
urlDecode = function( url,charset ) {
    if( isNull( url ) ||
        ( typeof( url ) != "string" && ( url instanceof java.lang.String ) == false ) ||
        useString( url ) == false ) {
        return url ;
    }
    if( isNull( charset ) ) {
        charset = null ;
    }
    var flg = false ;
    var val = null ;
    var p = url.indexOf( "?" ) ;
    if( p >= 0 ) {
        flg = true ;
        val = url.substring( p+1 ) ;
    }
    else {
        val = url ;
    }
    val = org.maachang.comet.httpd.engine.script.js.JsDef.convertURL( false,val,charset ) ;
    if( flg == true ) {
        url = url.substring( 0,p+1 ) + val ;
    }
    else {
        url = val ;
    }
    return url ;
} ;

// 単一URLエンコード.
encodeURL = function( string,charset ) {
    if( useString( string ) == false ) {
        return "" ;
    }
    if( useString( charset ) == false ) {
        charset = "UTF8" ;
    }
    return ""+java.net.URLEncoder.encode( string,charset ) ;
} ;

// 単一URLデコード.
decodeURL = function( string,charset ) {
    if( useString( string ) == false ) {
        return "" ;
    }
    if( useString( charset ) == false ) {
        charset = "UTF8" ;
    }
    return ""+java.net.URLDecoder.decode( string,charset ) ;
} ;

// 指定バイナリパラメータ内容のオリジナル名を取得.
paramOriginal = function( name ) {
    if( isRequestParam() == true && useString( name ) == true ) {
        var o = _$script$query.get( name ) ;
        return ""+org.maachang.comet.httpd.engine.script.js.JsDef.getParamByOriginalName( o ) ;
    }
    return "" ;
} ;

// 指定バイナリパラメータ内容のバイナリを取得.
paramBinary = function( name ) {
    if( isRequestParam() == true && useString( name ) == true ) {
        var o = _$script$query.get( name ) ;
        return org.maachang.comet.httpd.engine.script.js.JsDef.getParamByBinary( o ) ;
    }
    return null ;
} ;

// 認証ユーザ名を取得.
getSuccessAuthUser = function() {
    if( isRequestParam() == true ) {
        return _$script$query.get( "_success_auth_user" ) ;
    }
    return null ;
} ;

// 認証パスワードを取得.
getSuccessAuthPasswd = function() {
    if( isRequestParam() == true ) {
        return _$script$query.get( "_success_auth_passwd" ) ;
    }
    return null ;
} ;

////////////////////////////////////////////////////////////////////////////////
// ブラウザ判別.
////////////////////////////////////////////////////////////////////////////////

// アクセスブラウザ種別を取得.
isBrowser = function() {
    if( isRequest() ) {
        var agent = _$script$header.getHeader( "User-Agent" ) ;
        if( agent.indexOf( "MSIE" ) != -1 ) {
            return "msie" ;
        }
        else if( agent.indexOf( "Safari" ) != -1 ) {
            return "safari" ;
        }
        else if( agent.indexOf( "Opera" ) != -1 ) {
            return "opera" ;
        }
        else if( agent.indexOf( "Netscape" ) != -1 ) {
            return "netscape" ;
        }
        else if( agent.indexOf( "Mozilla/" ) != -1 ) {
            return "mozilla" ;
        }
        return "unknow" ;
    }
    return "unknow" ;
}


////////////////////////////////////////////////////////////////////////////////
// Session系.
////////////////////////////////////////////////////////////////////////////////

// セッションが利用可能かチェック.
isSession = function() {
    if( __$type$script != "console" && isNull( _$script$session ) == false ) {
        return true ;
    }
    return false ;
} ;

// セッション条件を追加.
putSession = function(key,value) {
    if( isNull( key ) || isNull( value ) ) {
        return -1 ;
    }
    if( isSession() ) {
        if( typeof( value ) == "string" || className( value ) == "String" ) {
            _$script$session.setElement(key,"[\""+value+"\"]") ;
        }
        else {
            var jsonval = new StrBuf() ;
            encodeJSON( value,jsonval ) ;
            _$script$session.setElement(key,jsonval.toString()) ;
            jsonval = null ;
        }
    }
} ;

// 現在アクセスされているセッション情報を破棄.
destroySession = function() {
    if( isSession() ) {
        var man = _$$maachang_comet_manager.get( "SESSION_MANAGER" ) ;
        man.removeSession( _$script$session.getSessionId() ) ;
    }
}

// セッション条件を削除.
removeSession = function(key) {
    if( isNull( key ) ) {
        return -1 ;
    }
    if( isSession() ) {
        _$script$session.removeElement(key) ;
    }
} ;

// セッション条件を取得.
getSession = function(key) {
    if( isNull( key ) ) {
        return null ;
    }
    if( isSession() ) {
        var ret = _$script$session.getElement(key) ;
        if( ret != null && ret.length() > 0 ) {
            return decodeJSON( ret ) ;
        }
    }
    return null ;
} ;

// セッションIDを取得.
getSessionId = function() {
    if( isSession() ) {
        return _$script$session.getSessionId() ;
    }
    return null ;
} ;

// sessionMap.
sessionMap = function() {
    return new JSAdapter({
        __get__ : function(name) {
            var ret = getSession( name ) ;
            return parseValue( ret ) ;
        },
        __has__ :  function(name) {
            return getSession( name ) != null ;
        },
        __delete__ : function (name) {
            return removeSession( name ) ;
        },
        __put__ : function(name, value) {
            putSession( name,parseValue( value ) ) ;
        },
        __getIds__ : function() {
            return null ;
        }
    });
} ;

////////////////////////////////////////////////////////////////////////////////
// Comet系.
////////////////////////////////////////////////////////////////////////////////

// コメットグループIDを取得.
getGroupId = function() {
    if( isNull( _$script$group_id ) ) {
        return null ;
    }
    return _$script$group_id ;
} ;

// コメットパラメータを取得.
getCometArgs = function() {
    if( isNull( _$script$comet_args ) ) {
        if( isNull( _$script$query.get('_comet_args') ) == false ) {
            return _$script$query.get('_comet_args') ;
        }
        return null ;
    }
    return _$script$comet_args ;
} ;

// コメット実行.
executionComet = function( args ) {
    if( isRequestParam() == false ) {
        return false ;
    }
    if( isNull( args ) ) {
        args = null ;
    }
    if( useString( _$script$query.get( "groupId" ) ) == true ) {
        var comet_man = _$$maachang_comet_manager.get( "COMET_MANAGER" ) ;
        if( isNull( comet_man ) == false ) {
            // DBコミット.
            commit() ;
            // コメット実行.
            comet_man.execution( args,_$script$query.get( "groupId" ) ) ;
        }
    }
} ;

// コメットトリガーからコメット呼び出し.
triggerComet = function( args ) {
    if( isRequestParam() == false ) {
        return false ;
    }
    if( _$script$query.get( "groupId" ) != null && getScriptDetail() == "trigger" ) {
        // CometTriggerが実行可能.
        if( isNull( args ) == false ) {
            _$script$query.put('_comet_args',args ) ;
        }
        _exit( "success" ) ;
    }
} ;

// 対象情報をJComet形式で送り返す.
sendJComet = function( result,args ) {
    if( isRequestParam() == false ) {
        return false ;
    }
    if( useString( _$script$query.get('ins') ) == false ||
        useString( _$script$query.get('method') ) == false ) {
        return -1 ;
    }
    if( isNull( result ) ) {
        result = null ;
    }
    if( isNull( args ) ) {
        args = null ;
    }
    if( result != null ) {
        outputJsonp( _$script$query.get('ins') + "(" ) ;
        convertClientJSON( result ) ;
        outputJsonp( ");\n" ) ;
    }
    if( args != null ) {
        outputJsonp( _$script$query.get('method') + "(" ) ;
        convertClientJSON( args ) ;
        outputJsonp( ");\n" ) ;
    }
    else {
        outputJsonp( _$script$query.get('method') + "();\n" ) ;
    }
} ;

////////////////////////////////////////////////////////////////////////////////
// json系.
////////////////////////////////////////////////////////////////////////////////

// JSONP形式で、データ送信.
jsonp = function( method,args,buf ) {
    if( isResponse() == true ) {
        if( useString( method ) == false ) {
            method = null ;
        }
        if( isNull( args ) ) {
            args = null ;
        }
        if( method == null && args == null ) {
            args = {"time": new Date} ;
        }
        if( method == null ) {
            outputJsonp( "callback(",buf ) ;
        }
        else {
            outputJsonp( method + "(",buf ) ;
        }
        if( isNull( args ) == false ) {
            convertClientJSON( args,buf ) ;
        }
        outputJsonp( ");",buf ) ;
        return 0 ;
    }
    return -1 ;
} ;

// クライアント送信用JSONP形式に変換.
convertClientJSON = function( value,buf ) {
    if( isNull( value ) ) {
        outputJsonp( "[\"\"]",buf ) ;
        return ;
    }
    var t = valueof( value ) ;
    if( t == "array" ) {
        t = null ;
        evalByArrayString( value,buf ) ;
    }
    else if( t == "map" ) {
        t = null ;
        outputJsonp( "[",buf ) ;
        evalByMapString( value,buf ) ;
        outputJsonp( "]",buf ) ;
    }
    else {
        outputJsonp( "["+evalByString( t,value )+"]",buf ) ;
    }
} ;


// json形式に変換.
encodeJSON = function( value,buf ) {
    if( isNull( value ) ) {
        outputJsonp( "[\"\"]",buf ) ;
        return ;
    }
    var t = valueof( value ) ;
    if( t == "array" ) {
        t = null ;
        outputJsonp( "[",buf ) ;
        evalByArrayString( value,buf ) ;
        outputJsonp( "]",buf ) ;
    }
    else if( t == "map" ) {
        t = null ;
        outputJsonp( "[",buf ) ;
        evalByMapString( value,buf ) ;
        outputJsonp( "]",buf ) ;
    }
    else {
        outputJsonp( "["+evalByString( t,value )+"]",buf ) ;
    }
} ;

// JSON形式に内容を変換.
encodeResultJSON = function( value ) {
    var buf = new StrBuf() ;
    encodeJSON( value,buf ) ;
    return buf.toString() ;
}

// json形式の文字列を変換.
decodeJSON = function( value ) {
    if( isNull( value ) || typeof( value ) != "string" ) {
        if( isNull( value ) || className( value ) != "String" ) {
            return null ;
        }
        value = ""+value ;
    }
    var ret = eval( value ) ;
    if( isNull( ret ) == false ) {
        if( valueof( ret ) == "array" && ret.length == 1 ) {
            ret = ret[ 0 ] ;
        }
    }
    return ret ;
}

// jsonp出力処理.
outputJsonp = function( o,buf ) {
    if( isNull( buf ) == false ) {
        if( isNull( o ) == false ) {
            buf.append( o ) ;
        }
    }
    else if( isResponse() ) {
        httpPrint( o ) ;
        //print( o ) ;
    }
    else {
        print( o ) ;
    }
}

// Arrayタイプから、eval実行可能内容を生成.
evalByArrayString = function( v,buf ) {
    outputJsonp( "[",buf ) ;
    var len = v.length ;
    for( var i = 0 ; i < len ; i ++ ) {
        if( i != 0 ) {
            outputJsonp( ",",buf ) ;
        }
        var t = valueof( v[i] ) ;
        if( t == "array" ) {
            evalByArrayString( v[i],buf ) ;
        }
        else if( t == "map" ) {
            evalByMapString( v[i],buf ) ;
        }
        else {
            outputJsonp( evalByString( t,v[i] ),buf ) ;
        }
    }
    outputJsonp( "]",buf ) ;
} ;

// Mapタイプから、eval実行可能内容を生成.
evalByMapString = function( v,buf ) {
    outputJsonp( "{",buf ) ;
    var cnt = 0 ;
    for( var k in v ) {
        if( cnt != 0 ) {
            outputJsonp( ",",buf ) ;
        }
        outputJsonp( "\""+k+"\":",buf ) ;
        var t = valueof( v[k] ) ;
        if( t == "array" ) {
            evalByArrayString( v[k],buf ) ;
        }
        else if( t == "map" ) {
            evalByMapString( v[k],buf ) ;
        }
        else {
            outputJsonp( evalByString( t,v[k] ),buf ) ;
        }
        cnt ++ ;
    }
    outputJsonp( "}",buf ) ;
} ;

// 指定タイプから、eval実行可能内容を生成.
evalByString = function( t,v ) {
    if( t == "string" ) {
        return convertJSONString( v ) ;
        //return "\""+v+"\"" ;
    }
    else if( t == "boolean" ) {
        return ""+v ;
    }
    else if( t == "number" ) {
        return ""+v ;
    }
    else if( t == "date" ) {
        return "new Date(" + v.getTime() + ")" ;
    }
    else if( t == "binary" ) {
        return "\""+encodeBase64( v )+"\"" ;
    }
    else if( t == "function" ) {
        return "" ;
    }
    return ""+v ;
} ;

// 指定文字列を、JSON形式に変換.
convertJSONString = function( v ) {
    return "\"" + org.maachang.comet.httpd.engine.script.js.JsDef.convertByJson( v ) + "\"" ;
}

