package org.maachang.dbm.engine ;

/**
 * １つのセクタデータ.
 * 
 * @version 2008/06/05
 * @author masahito suzuki
 * @since MaachangDBM 1.12
 */
class M2SectorData extends M2SectorHeader {
    
    /**
     * バイナリデータ.
     */
    protected byte[] data = null ;
    
    /**
     * コンストラクタ.
     */
    public M2SectorData() {
        super() ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        super.clear() ;
        this.data = null ;
    }
    
    /**
     * data を取得.
     * <BR><BR>
     * @return data が返されます.
     */
    public byte[] getData() {
        return data;
    }
    
    /**
     * data を設定.
     * <BR><BR>
     * @param data data を設定します.
     */
    public void setData(byte[] data) {
        this.data = data;
    }
    
    /**
     * オブジェクトコピー.
     */
    public void copyObject( M2SectorData object ) {
        super.copyObject( object ) ;
        object.data = this.data ;
    }

}
