package org.maachang.connector ;

import java.util.LinkedList;

/**
 * ConnectorQueue.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
class ConnectorQueue {
    private LinkedList<ConnectorSession> queue = null ;
    
    public ConnectorQueue() {
        queue = new LinkedList<ConnectorSession>() ;
    }
    
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    public synchronized void append( ConnectorSession s ) {
        if( queue == null || s == null || s.isClosed() == true ) {
            return ;
        }
        queue.add( s ) ;
    }
    
    public synchronized ConnectorSession getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
}
