package org.maachang.comet.httpd ;

/**
 * HttpdState例外.
 * 
 * @version 2007/08/26
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class HttpdStateException extends Exception {
    private static final long serialVersionUID = -6855465702119811161L;
    
    /**
     * 例外ステータス.
     */
    private int state = -1 ;
    
    /**
     * エラーメッセージ.
     */
    private String errorMessage = null ;
    
    /**
     * コンストラクタ.
     */
    public HttpdStateException() {
        super() ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * HTTPステータスを設定して、オブジェクトを生成.
     * <BR>
     * @param state 対象のHTTPステータスを設定します.
     */
    public HttpdStateException( int state ) {
        super() ;
        this.state = state ;
        this.errorMessage = null ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * HTTPステータスを設定して、オブジェクトを生成.
     * <BR>
     * @param state 対象のHTTPステータスを設定します.
     * @param errorMessage 対象のエラーメッセージを設定します.
     */
    public HttpdStateException( int state,String errorMessage ) {
        super() ;
        this.state = state ;
        this.errorMessage = errorMessage ;
    }
    
    /**
     * HTTPステータスを取得.
     * <BR><BR>
     * HTTPステータスを取得します.
     * <BR>
     * @return int HTTPステータスが返されます.
     */
    public int getState() {
        return state ;
    }
    
    /**
     * エラーメッセージを取得.
     * <BR><BR>
     * エラーメッセージを取得します.
     * <BR>
     * @return String エラーメッセージが返されます.
     */
    public String getErrorMessage() {
        return errorMessage ;
    }
}
