package org.maachang.comet.httpd.engine;

import org.maachang.comet.conf.IniFile;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.manager.GlobalManager;
import org.maachang.util.StringUtil;

/**
 * Javascript(js)ファイルを送信するときの予約変数置き換え処理.
 * 
 * @version 2008/05/20
 * @author masahito suzuki
 * @since MaachangComet 1.15
 */
public class EnvJavascript {
    
    private static String BUF_HTTP_URL = null ;
    private static String BUF_HTTPS_URL = null ;
    private static final Object sync = new Object() ;
    
    /**
     * 予約変数置き換え.
     * @param request 対象のリクエストを設定します.
     * @param string 対象の文字列を設定します.
     * @return String 変換された文字列が返されます.
     * @exception Exception 例外.
     */
    public static final String convert( HttpdRequest request,String string )
        throws Exception {
        if( string == null || string.length() <= 0 ) {
            return "" ;
        }
        if( request == null ) {
            return string ;
        }
        synchronized( sync ) {
            if( BUF_HTTP_URL == null || BUF_HTTPS_URL == null ) {
                BUF_HTTP_URL = getURL( request,false ) ;
                BUF_HTTPS_URL = getURL( request,true ) ;
            }
        }
        if( string.indexOf( "$@@URL@@" ) != -1 ) {
            string = StringUtil.changeString( string,"$@@URL@@",( request.isSsl() ) ? BUF_HTTPS_URL : BUF_HTTP_URL ) ;
        }
        if( string.indexOf( "$@@HTTP_URL@@" ) != -1 ) {
            string = StringUtil.changeString( string,"$@@HTTP_URL@@",BUF_HTTP_URL ) ;
        }
        if( string.indexOf( "$@@HTTPS_URL@@" ) != -1 ) {
            string = StringUtil.changeString( string,"$@@HTTPS_URL@@",BUF_HTTPS_URL ) ;
        }
        if( string.indexOf( "$@@SESSION_ID@@" ) != -1 ) {
            HttpdSession session = request.getSession() ;
            if( session != null && session.getSessionId() != null ) {
                string = StringUtil.changeString( string,"$@@SESSION_ID@@",session.getSessionId() ) ;
            }
        }
        return string ;
    }
    
    /**
     * 指定内容のURLを取得.
     */
    private static final String getURL( HttpdRequest request,boolean mode ) {
        IniFile conf = ( IniFile )GlobalManager.getInstance().get( "CONFIG_MANAGER" ) ;
        int port ;
        String protocol = "" ;
        if( mode == true ) {
            port = conf.getNumber( "ssl","port",0 ).intValue() ;
            if( port == 443 ) {
                port = -1 ;
            }
            protocol = "https://" ;
        }
        else {
            port = conf.getNumber( "net","server-port",0 ).intValue() ;
            if( port == 80 ) {
                port = -1 ;
            }
            protocol = "http://" ;
        }
        String host = request.getHeader().getHeader( "Host",0 ) ;
        int p = host.indexOf( ":" ) ;
        if( p >= 0 ) {
            host = host.substring( 0,p ) ;
        }
        StringBuilder buf = new StringBuilder() ;
        buf.append( protocol ).append( host ) ;
        if( port != -1 ) {
            buf.append( ":" ).append( port ) ;
        }
        return buf.toString() ;
    }
}

