package org.maachang.comet.httpd.engine.auth ;

/**
 * ユーザ情報管理インターフェイス.
 *
 * @version 2007/08/19
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public interface HttpdAuthUsers {
    
    /**
     * ユーザ名に対するパスワードを取得.
     * <BR><BR>
     * ユーザ名に対するパスワードを取得します.
     * <BR>
     * @param user ユーザ名を設定します.
     * @return String[] パスワードが返されます.<BR>
     *                  [null]が返された場合、対象ユーザは存在しません.
     * @exception Exception 例外.
     */
    public String[] getPassword( String user )
        throws Exception ;
    
    /**
     * 指定ユーザ名が存在するかチェック.
     * <BR><BR>
     * 指定ユーザ名が存在するかチェックします.
     * <BR>
     * @param user 対象のユーザ名を設定します.
     * @return boolean [true]が返された場合、存在します.
     * @exception Exception 例外.
     */
    public boolean isUser( String user )
        throws Exception ;
}
