package org.maachang.comet.httpd.engine.comet ;

import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.net.nio.ConnectionInfo;

/**
 * １つのコメットコネクション.
 */
class ConnectComet {
    /**
     * コネクション情報.
     */
    private ConnectionInfo connectionInfo = null ;
    /**
     * リクエスト情報.
     */
    private HttpdRequest request = null ;
    
    /**
     * コネクション時間.
     */
    private long connectionTime = -1L ;
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 情報を指定してオブジェクトを設定します.
     * <BR>
     * @param request 対象のリクエストを設定します.
     */
    public ConnectComet( HttpdRequest request ) {
        this.request = request ;
        this.connectionInfo = request.getConnectionInfo() ;
        this.connectionTime = System.currentTimeMillis() ;
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        clear() ;
    }
    
    /**
     * 格納情報を破棄.
     * <BR><BR>
     * 格納情報を破棄します.
     */
    public void destroy() {
        this.clear() ;
        if( getConnectionInfo() != null ) {
            getConnectionInfo().destroy() ;
        }
    }
    
    /**
     * 接続処理をクリア.
     * <BR><BR>
     * 接続処理をクリアします.
     */
    public void clear() {
        request = null ;
        connectionTime = -1L ;
    }
    
    /**
     * キャンセル処理.
     * <BR><BR>
     * キャンセル処理を実施します.
     */
    public void cancel() {
        connectionInfo = null ;
        request = null ;
        connectionTime = -1L ;
    }
    
    /**
     * request を取得.
     * <BR><BR>
     * @return request が返されます.
     */
    public HttpdRequest getRequest() {
        return request;
    }
    
    /**
     * request を設定.
     * <BR><BR>
     * @param request request を設定します.
     */
    public void setRequest(HttpdRequest request) {
        this.request = request;
    }
    
    /**
     * コネクションオブジェクトを取得.
     * <BR><BR>
     * コネクションオブジェクトを取得します.
     * <BR>
     * @return ConnectionInfo コネクションオブジェクトが返されます.
     */
    public ConnectionInfo getConnectionInfo() {
        if( connectionInfo != null && connectionInfo.isUse() == true ) {
            return connectionInfo ;
        }
        return null ;
    }
    
    /**
     * コネクション時間を取得.
     * <BR><BR>
     * @return long コネクション開始時間が返されます.
     */
    public long getConnectionTime() {
        return this.connectionTime ;
    }
    
    /**
     * コネクションが確立されているかチェック.
     * <BR><BR>
     * コネクションが確立されているかチェックします.
     * <BR>
     * @return boolean [true]の場合、コネクションが確立しています.
     */
    public boolean isConnection() {
        boolean ret = false ;
        try {
            if( request == null || request.isUse() == false ) {
                ret = false ;
            }
            else {
                ret = true ;
            }
        } catch( Exception e ) {
            ret = false ;
        }
        return ret ;
    }
}
