package org.maachang.comet.httpd.engine.errors ;

import org.maachang.comet.httpd.HttpdVersionDef;
import org.maachang.util.StringUtil;

/**
 * HTTPDエラーページテンプレート.
 * 
 * @version 2007/08/29
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class HttpdErrorPageTemplate {
    
    /**
     * エラーコード.
     */
    public static final String ERROR_CODE = "[%ERROR_CODE%]" ;
    
    /**
     * エラーメッセージ.
     */
    public static final String ERROR_MESSAGE = "[%ERROR_MESSAGE%]" ;
    
    /**
     * エラーメッセージ詳細.
     */
    public static final String ERROR_DETAIL = "[%ERROR_DETAIL%]" ;
    
    /**
     * エラーURL.
     */
    public static final String ERROR_URL = "[%ERROR_URL%]" ;
    
    /**
     * サーバ名.
     */
    public static final String SERVER = "[%SERVER%]" ;
    
    /**
     * copyright.
     */
    public static final String COPYRIGHT = "[%COPYRIGHT%]" ;
    
    /**
     * エラーページテンプレート文字列を設定して、HTMLを生成.
     * <BR><BR>
     * エラーページテンプレート文字列を設定して、HTMLを生成します.
     * <BR>
     * @param template 対象のエラーページテンプレートを設定します.
     * @param code 対象のエラーコードを設定します.
     * @param message 対象のエラーメッセージを設定します.
     * @param detail 対象のエラーメッセージ詳細を設定します.
     * @return String 対象のHTML内容が返されます.
     * @exception Exception 例外.
     */
    public static final String createErrorPage( String template,String code,String message,String detail,String url )
        throws Exception {
        if( template == null || template.length() <= 0 ||
            code == null || code.length() <= 0 ||
            message == null || ( message = message.trim() ).length() <= 0 || 
            url == null || url.length() <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        if( detail == null ) {
            detail = "" ;
        }
        template = StringUtil.changeString( template,ERROR_CODE,code ) ;
        template = StringUtil.changeString( template,ERROR_MESSAGE,message ) ;
        template = StringUtil.changeString( template,ERROR_DETAIL,detail ) ;
        template = StringUtil.changeString( template,ERROR_URL,url ) ;
        template = StringUtil.changeString( template,SERVER,HttpdVersionDef.getPrintServerName() ) ;
        return StringUtil.changeString( template,COPYRIGHT,HttpdVersionDef.getCopyright() ) ;
    }
}
