package org.maachang.comet.httpd.engine.script;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;

import org.maachang.util.StringUtil;

/**
 * スクリプト情報.
 * 
 * @version 2007/09/23
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class SrcScript {
    
    /**
     * 特殊文字変換元.
     */
    public static final String[] SPECIAL_SRC = {
        "<",">"
    } ;
    
    /**
     * 特殊文字.
     */
    public static final String[] SPECIAL_DEST = {
        "&lt;","&gt;"
    } ;
    
    /**
     * スクリプト情報.
     */
    private String[] script = null ;
    
    /**
     * コンストラクタ.
     */
    private SrcScript() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 情報を設定してオブジェクトを生成します.
     * <BR>
     * @param script 対象のスクリプト情報を設定します.
     * @exception Exception 例外.
     */
    public SrcScript( String script )
        throws Exception {
        if( script == null || ( script = script.trim() ).length() <= 0 ) {
            this.script = new String[ 0 ] ;
        }
        else {
            ArrayList<String> scs = new ArrayList<String>() ;
            BufferedReader sr = new BufferedReader( new StringReader( script ) ) ;
            int len = SPECIAL_SRC.length ;
            for( ;; ) {
                String line = sr.readLine() ;
                if( line == null ) {
                    break ;
                }
                if( line.length() > 0 ) {
                    for( int i = 0 ; i < len ; i ++ ) {
                        line = StringUtil.changeString( line,SPECIAL_SRC[ i ],SPECIAL_DEST[ i ] ) ;
                    }
                }
                scs.add( line ) ;
            }
            sr.close() ;
            if( scs.size() <= 0 ) {
                this.script = new String[ 0 ] ;
            }
            else {
                len = scs.size() ;
                this.script = new String[ len ] ;
                for( int i = 0 ; i < len ; i ++ ) {
                    this.script[ i ] = scs.get( i ) ;
                }
            }
        }
    }
    
    /**
     * 指定行数の内容を取得.
     * <BR><BR>
     * 指定行数の内容を取得します.
     * <BR>
     * @param line 対象の行数を設定します.
     * @return String 指定行数の情報が返されます.
     */
    public String get( int line ) {
        if( line <= 0 || line > this.script.length ) {
            return null ;
        }
        return this.script[ line-1 ] ;
    }
    
    /**
     * 総行数を取得.
     * <BR><BR>
     * 総行数を取得します.
     * <BR>
     * @return int 総行数が返されます.
     */
    public int lines() {
        return this.script.length ;
    }
    
    /**
     * 文字列出力.
     * <BR><BR>
     * 文字列で出力します.
     * <BR>
     * @return String 文字列で出力します.
     */
    public String toString() {
        if( script != null ) {
            StringBuilder buf = new StringBuilder() ;
            int len = script.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                buf.append( i ).append( ":" ).append( script[ i ] ) ;
            }
            return buf.toString() ;
        }
        return "" ;
    }
}
