package org.maachang.comet.httpd.engine.script.cron;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * クーロン(スケジューリング実行)タイマー.
 * 
 * @version 2008/07/01
 * @author masahito suzuki
 * @since MaachangComet 1.1F
 */
public class CronOneThread extends Thread {
    
    /**
     * LOG.
     */
    private static final Log LOG = LogFactory.getLog( CronOneThread.class ) ;
    
    /**
     * スケジュール実行用.
     */
    private List<CronBean> executions = null ;
    
    /**
     * 実行CronBean.
     */
    private CronBean bean = null ;
    
    /**
     * スレッド停止フラグ.
     */
    private volatile boolean stopFlag = true ;
    
    /**
     * 同期オブジェクト.
     */
    private final Object sync = new Object() ;
    
    /**
     * コンストラクタ.
     */
    private CronOneThread() {
        
    }
    
    /**
     * コンストラクタ.
     * @param executions スケジュール実行要素を設定します.
     * @param bean スケジュール実行Beanを設定します.
     * @exception Exception 例外.
     */
    public CronOneThread( List<CronBean> executions,CronBean bean )
        throws Exception {
        if( executions == null || bean == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.executions = executions ;
        this.bean = bean ;
        this.setDaemon( true ) ;
        this.stopFlag = true ;
        this.executions.add( bean ) ;
    }
    
    /**
     * 停止フラグを取得.
     * @return boolean [true]の場合、停止しています.
     */
    public boolean isStop() {
        boolean ret ;
        synchronized( sync ) {
            ret = stopFlag ;
        }
        return ret ;
    }
    
    /**
     * スレッド実行.
     */
    public void run() {
        String scriptName = bean.getScript() ;
        synchronized( sync ) {
            stopFlag = false ;
        }
        try {
            long time = System.currentTimeMillis() ;
            LOG.info( ">>Cron実行:[" + scriptName + "] - {"+bean.toString()+"}" ) ;
            CronScript.execution( scriptName ) ;
            time = System.currentTimeMillis() - time ;
            LOG.info( ">>Cron実行終了:[" + scriptName + "] - {"+bean.toString()+"} - " + time + "msec" ) ;
        } catch( Exception e ) {
            LOG.error( ">>Cron実行エラー[" + scriptName + "] - {"+bean.toString()+"}",e ) ;
        } finally {
            try {
                int len = executions.size() ;
                for( int i = 0 ; i < len ; i ++ ) {
                    CronBean b = executions.get( i ) ;
                    if( bean.equals( b ) ) {
                        executions.remove( i ) ;
                        break ;
                    }
                }
            } catch( Exception e ) {
            }
            try {
                bean.setLastExecutionTime( System.currentTimeMillis() ) ;
            } catch( Exception e ) {
            }
            synchronized( sync ) {
                stopFlag = true ;
            }
        }
    }
    
}
