package org.maachang.comet.httpd.engine.script.image;

import java.net.InetAddress;

import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.service.client.MDbmDriverManager;

/**
 * イメージマネージャ.
 * 
 * @version 2008/01/27
 * @author masahito suzuki
 * @since MaachangComet 1.07
 */
public class ImageManager {
    
    private ImageManager() {
        
    }
    
    /**
     * イメージ操作オブジェクトを取得.
     * <BR><BR>
     * イメージ操作オブジェクトを取得します.
     * <BR>
     * @param mdbm 対象のMDBMを設定します.
     * @return ImageOp イメージ操作オブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final ImageOp getImageOp( MDbm mdbm ) throws Exception {
        return new ImageOpImpl( mdbm ) ;
    }
    
    /**
     * イメージ操作オブジェクトを取得.
     * <BR><BR>
     * イメージ操作オブジェクトを取得します.
     * <BR>
     * @param mode [true]の場合、トランザクションモードです.
     * @return ImageOp イメージ操作オブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final ImageOp getImageOp( boolean mode ) throws Exception {
        return new ImageOpImpl( MDbmManager.getInstance().getMDbm( mode ) ) ;
    }
    
    /**
     * 外部接続用イメージ操作オブジェクトを取得.
     * <BR><BR>
     * 外部接続用イメージ操作オブジェクトを取得します.
     * <BR>
     * @param addr コネクションアドレスを設定します.
     * @param port コネクションポート番号を設定します.
     * @return ImageOp イメージ操作オブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final ImageOp getImageOp( InetAddress addr,int port ) throws Exception {
        ImageOp ret = null ;
        try {
            ret = new ImageOpImpl( MDbmDriverManager.getConnection( addr,port ) ) ;
        } catch( Exception e ) {
            ret = null ;
        }
        return ret ;
    }
}
