package org.maachang.comet.net.nio;

import java.nio.ByteBuffer;
import java.util.LinkedList;

/**
 * 受信用バッファ.
 * 
 * @version 2008/07/08
 * @author masahito suzuki
 * @since MaachangComet 1.1F
 */
public class ReceiveBuffer {
    
    /**
     * バッファ情報管理キュー.
     */
    private LinkedList<byte[]> queue = null ;
    
    /**
     * 総データサイズ.
     */
    private int length = -1 ;
    
    /**
     * コンストラクタ.
     */
    protected ReceiveBuffer() {
        this.queue = new LinkedList<byte[]>() ;
        this.length = 0 ;
    }
    
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    /**
     * オブジェクト破棄.
     */
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
        queue = null ;
        length = 0 ;
    }
    
    /**
     * データリセット.
     */
    public synchronized void reset() {
        if( queue != null ) {
            queue.clear() ;
        }
        length = 0 ;
    }
    
    /**
     * 受信されたデータをセット.
     * @param buffer 対象のByteBufferを設定します.
     * @exception Exception 例外.
     */
    public synchronized void put( ByteBuffer buffer )
        throws Exception {
        if( buffer == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        int len = buffer.limit() ;
        if( len <= 0 ) {
            return ;
        }
        byte[] bin = new byte[ len ] ;
        buffer.get( bin,0,len ) ;
        queue.add( bin ) ;
        length += len ;
    }
    
    /**
     * １つのバッファ内容を取得.
     * @return byte[] １つのバッファ内容が返されます.
     */
    public synchronized byte[] get() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
    
    /**
     * 現在の受信バッファ長を取得.
     * @return int 現在の受信バッファ長が返されます.
     */
    public synchronized int length() {
        return length ;
    }
}
