package org.maachang.comet.net.nio ;

import java.nio.ByteBuffer;
import java.util.LinkedList;

/**
 * 書き込み処理を行うデータを管理するキュー.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
public class WriteDataQueue {
	
	/**
	 * キューデータ.
	 */
    private LinkedList<ByteBuffer> queue = null ;
    
    /**
     * コンストラクタ.
     */
    public WriteDataQueue() {
        queue = new LinkedList<ByteBuffer>() ;
    }
    
    /**
     * オブジェクト破棄.
     */
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    /**
     * 先頭にデータを追加.
     * @param accept
     */
    public synchronized void appendHead( ByteBuffer accept ) {
        if( queue == null || accept == null ) {
            return ;
        }
        queue.addFirst( accept ) ;
    }
    
    /**
     * 一番最後にデータを追加.
     * @param accept
     */
    public synchronized void append( ByteBuffer accept ) {
        if( queue == null || accept == null ) {
            return ;
        }
        queue.add( accept ) ;
    }
    
    /**
     * 先頭のデータを削除して取得.
     * @return
     */
    public synchronized ByteBuffer getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
    
    /**
     * サイズを取得.
     * @return
     */
    public synchronized int size() {
        return queue.size() ;
    }
}
