package org.maachang.dao.dbms.ctbl;

import org.maachang.util.StringUtil;

/**
 * テーブル支援ユーティリティ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangDao 1.00
 */
class TableUtil {
    
    /**
     * 対象カラムタイプの文字列を取得.
     * <BR><BR>
     * 対象カラムタイプの文字列を取得します.
     * <BR>
     * @param table 処理対象のテーブルオブジェクトを設定します.
     * @param type 対象の処理タイプを設定します.
     * @return カラムタイプが返されます.
     */
    public static final String getColumnName( Table table,String type ) {
        if( type == null || ( type = type.trim() ).length() <= 0 ) {
            return null ;
        }
        type = type.toLowerCase() ;
        String result = null ;
        int customSize = -1 ;
        int p = -1 ;
        if( ( p = type.indexOf( "(" ) ) != -1 && type.indexOf( ")",p ) > p ) {
            String putSizeString = type.substring( p ) ;
            type = type.substring( 0,p ) ;
            putSizeString = StringUtil.changeString( putSizeString,"(","" ) ;
            putSizeString = StringUtil.changeString( putSizeString,")","" ) ;
            putSizeString = StringUtil.changeString( putSizeString,"　","" ) ;
            putSizeString = putSizeString.trim() ;
            customSize = Integer.parseInt( putSizeString ) ;
        }
        if( Table.BOOLEAN.equals( type ) ) {
            result = table.typeByBoolean() ;
            // booleanの場合、サイズ指定はできない.
            if( ( p = result.indexOf( "(" ) ) != -1 && result.indexOf( ")",p ) > p ) {
                customSize = -1 ;
            }
        }
        else if( Table.INTEGER.equals( type ) ) {
            result = table.typeByInt() ;
        }
        else if( Table.LONG.equals( type ) ) {
            result = table.typeByLong() ;
        }
        else if( Table.FLOAT.equals( type ) ) {
            result = table.typeByFloat() ;
        }
        else if( Table.DOUBLE.equals( type ) ) {
            result = table.typeByDouble() ;
        }
        else if( Table.BINARY.equals( type ) ) {
            result = table.typeByBytes() ;
        }
        else if( Table.CHAR.equals( type ) ) {
            if( customSize > 0 ) {
                customSize = table.getUTF8CharSize( customSize ) ;
            }
            result = table.typeByChar() ;
        }
        else if( Table.TEXT.equals( type ) ) {
            if( customSize > 0 ) {
                customSize = table.getUTF8CharSize( customSize ) ;
            }
            result = table.typeByText() ;
        }
        else if( Table.DATE.equals( type ) ) {
            result = table.typeByDate() ;
        }
        else if( Table.TIME.equals( type ) ) {
            result = table.typeByTime() ;
        }
        else if( Table.TIMESTAMP.equals( type ) ) {
            result = table.typeByTimestamp() ;
        }
        if( result != null && customSize > 0 ) {
            // 別途サイズ指定されている場合は、そのサイズを採用する.
            if( ( p = result.indexOf( "(" ) ) != -1 && result.indexOf( ")",p ) > p ) {
                result = result.substring( 0,p ) ;
            }
            result = new StringBuilder().append( result ).
                append( "(" ).append( customSize ).append( ")" ).toString() ;
        }
        return result ;
    }
    
    /**
     * カラム要素の文字列を取得.
     * <BR><BR>
     * カラム要素の文字列を取得します.
     * <BR>
     * @param mode 処理結果で戻されるモードが返されます.
     * @param table 処理対象のテーブルオブジェクトを設定します.
     * @param type 対象の処理タイプを設定します.
     * @return String 対象のカラムタイプが返されます.
     */
    public static final String getColumnType( int[] mode,Table table,String type ) {
        if( type == null || ( type = type.trim() ).length() <= 0 ) {
            return null ;
        }
        String t = type.toLowerCase() ;
        if( Table.COLUMN_NOT_NULL.equals( t ) ) {
            mode[ 0 ] = 1 ;
            return table.notNullName() ;
        }
        if( Table.COLUMN_NOT_NULL2.equals( t ) ) {
            mode[ 0 ] = 1 ;
            return table.notNullName() ;
        }
        else if( Table.COLUMN_UNIQUE.equals( t ) ) {
            mode[ 0 ] = 2 ;
            return table.uniqueName() ;
        }
        return null ;
    }
    
    /**
     * デフォルトデータを解析して、デフォルト情報を取得.
     * <BR><BR>
     * デフォルトデータを解析して、デフォルト情報を取得します.
     * <BR>
     * @param booleanType Boolean型の条件を設定します.
     * @param type 対象の処理タイプを設定します.
     * @return String 対象のカラムタイプが返されます.
     */
    public static final String getDefault( String type ) {
        if( type == null || ( type = type.trim() ).length() <= 0 ) {
            return null ;
        }
        if( type.toLowerCase().startsWith( Table.COLUMN_DEFAULT ) ) {
            String val = type.substring( Table.COLUMN_DEFAULT.length(),type.length() ).trim() ;
            val = val.trim() ;
            if( val.startsWith( "\"" ) && val.endsWith( "\"" ) ) {
                val = val.substring( 1,val.length()-1 ) ;
            }
            else if( val.startsWith( "\'" ) && val.endsWith( "\'" ) ) {
                val = val.substring( 1,val.length()-1 ) ;
            }
            val = val.trim() ;
            String x = val.toLowerCase() ;
            if( "true".equals( x ) ) {
                val = "true" ;
            }
            else if( "false".equals( x ) ) {
                val = "false" ;
            }
            return val ;
        }
        return null ;
    }
    
    /**
     * 指定条件がindexであるかチェック.
     * <BR><BR>
     * 指定条件がindexであるかチェックします.
     * <BR>
     * @param type 対象の処理タイプを設定します.
     * @return boolean [true]の場合、インデックスです.
     */
    public static final boolean isIndex( String type ) {
        if( type == null || ( type = type.trim() ).length() <= 0 ) {
            return false ;
        }
        type = type.toLowerCase() ;
        if( Table.COLUMN_INDEX.equals( type ) ) {
            return true ;
        }
        return false ;
    }
    
    /**
     * 指定条件がkeyであるかチェック.
     * <BR><BR>
     * 指定条件がkeyであるかチェックします.
     * <BR>
     * @param type 対象の処理タイプを設定します.
     * @return boolean [true]の場合、キーです.
     */
    public static final boolean isKey( String type ) {
        if( type == null || ( type = type.trim() ).length() <= 0 ) {
            return false ;
        }
        type = type.toLowerCase() ;
        if( Table.COLUMN_KEY.equals( type ) ) {
            return true ;
        }
        return false ;
    }
    
    /**
     * 指定条件がtypeであるかチェック.
     * <BR><BR>
     * 指定条件がtypeであるかチェックします.
     * <BR>
     * @param key 対象の処理タイプを設定します.
     * @return boolean [true]の場合、タイプです.
     */
    public static final boolean isType( String key ) {
        if( key == null || ( key = key.trim() ).length() <= 0 ) {
            return false ;
        }
        key = key.toLowerCase() ;
        if( Table.TABLE_TYPE.equals( key ) ) {
            return true ;
        }
        return false ;
    }
}
