package org.maachang.dao.dbms.kind;

/**
 * DBMSサポート種類.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangDao 1.00
 */
public abstract class SupportKind {
    /**
     * シーケンス付加名.
     */
    public static final String SEQ_NAME = "_id_seq" ;
    
    /**
     * アダプタ名を取得.
     * <BR><BR>
     * アダプタ名を取得します.
     * <BR>
     * @return String アダプタ名が返されます.
     */
    public abstract String getAdapter() ;
    
    /**
     * Boolean非サポートフラグ.
     * <BR><BR>
     * Boolean非サポートフラグを取得します.
     * <BR>
     * @return boolean [true]の場合は、サポートしています.
     */
    public abstract boolean isBoolean() ;
    
    /**
     * IDを設定した後の取得SQL.
     * <BR><BR>
     * IDを設定した後の取得SQLが返されます.
     * <BR>
     * @return String SQLが返されます.
     */
    public String getInsertIdBySQL() {
        return null ;
    }
    
    /**
     * 新しいIDの取得SQL.
     * <BR><BR>
     * 指定モデルに対する新しいIDを取得するSQLが返されます.
     * <BR>
     * @param model 対象のモデル名を設定します.
     * @return String SQLが返されます.
     */
    public String getSequenceId( String model ) {
        return null ;
    }

}
