package org.maachang.dao.dbms.pool;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * コネクション管理オブジェクト.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangDao 1.00
 */
public class ConnectManager {
    /**
     * コネクション管理.
     */
    private OnePoolManager connectManager = null;

    /**
     * コンストラクタ.
     */
    private ConnectManager() {

    }

    /**
     * コンストラクタ. <BR>
     * <BR>
     * [OnePoolManager]を指定してオブジェクトを設定します. <BR>
     * 
     * @param connectManager
     *            対象オブジェクトを設定します.
     */
    protected ConnectManager(OnePoolManager connectManager) {
        this.connectManager = connectManager;
    }

    /**
     * ファイナライズ処理定義. <BR>
     * <BR>
     * ファイナライズ処理定義. <BR>
     * 
     * @exception Exception
     *                例外処理が返されます.
     */
    protected final void finalize() throws Exception {
        this.destroy();
    }

    /**
     * オブジェクト破棄. <BR>
     * <BR>
     * オブジェクトを破棄します.
     */
    public void destroy() {
        connectManager.destroy();
    }

    /**
     * コネクションオブジェクトを取得. <BR>
     * <BR>
     * コネクションオブジェクトを取得します. <BR>
     * 
     * @return Connection コネクションオブジェクトが返されます.
     * @exception SQLException
     *                SQL例外.
     */
    public Connection getConnection() throws SQLException {
        return connectManager.getConnection();
    }

    /**
     * 最大プーリング数を取得. <BR>
     * <BR>
     * 最大プーリング数を取得します. <BR>
     * 
     * @return int 管理されている最大プーリング数が返されます.
     */
    public int getMax() {
        return connectManager.getMax();
    }

    /**
     * 現在アクティブであるプーリングコネクション数を取得. <BR>
     * <BR>
     * 現在アクティブであるプーリングコネクション数を取得します. <BR>
     * 
     * @return int 現在アクティブなプーリングコネクション数が返されます.
     */
    public int getActives() {
        return connectManager.getActives();
    }

    /**
     * コネクションURLを取得. <BR>
     * <BR>
     * コネクションURLを取得します. <BR>
     * 
     * @return String コネクションURLが返されます.
     */
    public String getURL() {
        return connectManager.getURL();
    }

    /**
     * コネクションユーザ名を取得. <BR>
     * <BR>
     * コネクションユーザ名を取得します. <BR>
     * 
     * @return String コネクションユーザ名が返されます.
     */
    public String getUser() {
        return connectManager.getUser();
    }

    /**
     * コネクションパスワードを取得. <BR>
     * <BR>
     * コネクションパスワードを取得します. <BR>
     * 
     * @return String コネクションパスワードが返されます.
     */
    public String getPasswd() {
        return connectManager.getPasswd();
    }

    /**
     * コネクションチェック用SQLを取得. <BR>
     * <BR>
     * コネクションチェック用SQLを取得します. <BR>
     * 
     * @return String コネクションチェック用SQLが返されます.
     */
    public String getCheckSQL() {
        return connectManager.getCheckSQL();
    }
}
