package org.maachang.session.client.net.protocol ;

/**
 * クライアントプロトコル.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public abstract class ClientProtocol {
    
    /**
     * クライアントマスク.
     */
    public static final int TYPE_MASK = 0x00000100 ;
    
    /**
     * クライアントプロトコルタイプ : 新しいセッションIDを要求.
     */
    public static final int TYPE_CREATE_SESSION = 0x00000101 ;
    
    /**
     * クライアントプロトコルタイプ : セッションID問合せ.
     */
    public static final int TYPE_USE_SESSION_ID = 0x00000102 ;
    
    /**
     * クライアントプロトコルタイプ : 指定セッション削除.
     */
    public static final int TYPE_DELETE_SESSION_ID = 0x00000103 ;
    
    /**
     * クライアントプロトコルタイプ : セッション更新時間取得.
     */
    public static final int TYPE_UPDATE_SESSION_ID = 0x00000104 ;
    
    /**
     * クライアントプロトコルタイプ : 指定セッション非存在時に新規セッション作成.
     */
    public static final int TYPE_USE_TO_SESSOIN_ID = 0x00000105 ;
    
    /**
     * クライアントプロトコルタイプ : セッション削除時間取得.
     */
    public static final int TYPE_DELETE_SESSION_TIME = 0x00000106 ;
    
    /**
     * クライアントプロトコルタイプ : Key要素追加.
     */
    public static final int TYPE_PUT_VALUE = 0x00000110 ;
    
    /**
     * クライアントプロトコルタイプ : Key要素削除.
     */
    public static final int TYPE_REMOVE_VALUE = 0x00000111 ;
    
    /**
     * クライアントプロトコルタイプ : Key要素取得.
     */
    public static final int TYPE_GET_VALUE = 0x00000112 ;
    
    /**
     * 要素タイプ : 文字列.
     */
    public static final int VALUE_TYPE_STRING = 1 ;
    
    /**
     * 要素タイプ : バイナリ.
     */
    public static final int VALUE_TYPE_BINARY = 2 ;
    
    /**
     * 要素タイプ : オブジェクト.
     */
    public static final int VALUE_TYPE_OBJECT = 3 ;
    
    /**
     * 結果情報.
     */
    protected Object result = null ;
    
    /**
     * オブジェクトクリア.
     */
    public void clear() {
        result = null ;
    }
    
    /**
     * クライアントプロトコルタイプを取得.
     * @return int クライアントプロトコルタイプが返されます.
     */
    public abstract int getProtocolType() ;
    
    /**
     * 送信データを作成.
     * @return value 送信データが返されます.
     * @exception Exception 例外.
     */
    public abstract byte[] getSendData() throws Exception ;
    
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @param p オフセット値を設定します.
     */
    public abstract void setResult( byte[] value,int p ) throws Exception ;
    
    /**
     * 処理結果の内容を取得.
     * @return Object 処理結果の内容が返されます.
     */
    public Object getResult() {
        return result ;
    }
}

