package org.maachang.session.server.protocol ;

import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;

/**
 * セッションID取得要求.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class SvCreateSessionIdProtocol extends ServerProtocol {
    
    /**
     * コンストラクタ.
     */
    public SvCreateSessionIdProtocol() {
        
    }
    
    /**
     * サーバプロトコルタイプを取得.
     * @return int サーバプロトコルタイプが返されます.
     */
    public int getProtocolType() {
        return TYPE_CREATE_SESSION ;
    }
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @exception Exception 例外.
     */
    public void setResult( Object value ) throws Exception {
        ArrayBinary b = new ArrayBinary( 100 ) ;
        b.write( ConvertParam.convertInt( getProtocolType() ) ) ;
        byte[] ss = (( String )value ).getBytes( "UTF8" ) ;
        b.write( ConvertParam.convertInt( ss.length ) ) ;
        b.write( ss ) ;
        ss = null ;
        this.result = b.getBinary() ;
    }
    
}

