package org.maachang.session.server.protocol ;

import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;

/**
 * セッションIDに対して要素を追加.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class SvPutSessionKeyProtocol extends ServerProtocol {
    
    /**
     * セッションID.
     */
    private String sessionId = null ;
    
    /**
     * 要素キー名.
     */
    private String key = null ;
    
    /**
     * 要素Value.
     */
    private byte[] value = null ;
    
    /**
     * コンストラクタ.
     */
    public SvPutSessionKeyProtocol( byte[] bin,int p )
        throws Exception {
        int len = ConvertParam.convertInt( p,bin ) ;
        p += 4 ;
        if( len > 0 ) {
            byte[] b = new byte[ len ] ;
            System.arraycopy( bin,p,b,0,len ) ;
            this.sessionId = new String( b,"UTF8" ) ;
            p += len ;
        }
        len = ConvertParam.convertInt( p,bin ) ;
        p += 4 ;
        if( len > 0 ) {
            byte[] b = new byte[ len ] ;
            System.arraycopy( bin,p,b,0,len ) ;
            this.key = new String( b,"UTF8" ) ;
            p += len ;
        }
        len = ConvertParam.convertInt( p,bin ) ;
        p += 4 ;
        if( len > 0 ) {
            byte[] b = new byte[ len ] ;
            System.arraycopy( bin,p,b,0,len ) ;
            this.value = b ;
            p += len ;
        }
    }
    
    /**
     * サーバプロトコルタイプを取得.
     * @return int サーバプロトコルタイプが返されます.
     */
    public int getProtocolType() {
        return TYPE_PUT_VALUE ;
    }
    
    /**
     * セッションIDを取得.
     * @return String セッションIDが返されます.
     */
    public String getSessionId() {
        return sessionId ;
    }
    
    /**
     * 要素キー名を取得.
     * @return String 要素キー名が返されます.
     */
    public String getKey() {
        return key ;
    }
    
    /**
     * 要素Valueを取得.
     * @return byte[] 要素Valueが返されます.
     */
    public byte[] getValue() {
        return value ;
    }
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @exception Exception 例外.
     */
    public void setResult( Object value ) throws Exception {
        ArrayBinary b = new ArrayBinary( 8 ) ;
        b.write( ConvertParam.convertInt( getProtocolType() ) ) ;
        this.result = b.getBinary() ;
    }
}

