package org.maachang.session.server.protocol ;

import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;

/**
 * セッションID存在要求.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class SvUseSessionIdProtocol extends ServerProtocol {
    
    /**
     * 問合せセッションID.
     */
    private String sessionId = null ;
    
    /**
     * コンストラクタ.
     */
    public SvUseSessionIdProtocol( byte[] bin,int p )
        throws Exception {
        int len = ConvertParam.convertInt( p,bin ) ;
        p += 4 ;
        if( len > 0 ) {
            byte[] b = new byte[ len ] ;
            System.arraycopy( bin,p,b,0,len ) ;
            this.sessionId = new String( b,"UTF8" ) ;
            p += len ;
        }
    }
    
    /**
     * サーバプロトコルタイプを取得.
     * @return int サーバプロトコルタイプが返されます.
     */
    public int getProtocolType() {
        return TYPE_USE_SESSION_ID ;
    }
    
    /**
     * 問合せセッションIDを取得.
     * @return String 問合せセッションIDが返されます.
     */
    public String getSessionId() {
        return sessionId ;
    }
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @exception Exception 例外.
     */
    public void setResult( Object value ) throws Exception {
        ArrayBinary b = new ArrayBinary( 8 ) ;
        b.write( ConvertParam.convertInt( getProtocolType() ) ) ;
        b.write( ( byte[] )new byte[]{ ( byte )( ( ( ( Boolean )value ).booleanValue() == true ) ? 0x01 : 0x00 ) } ) ;
        this.result = b.getBinary() ;
    }
}

