#include "rawio.h"

// t@CI[vp[~bV.
#define PERMISSION 0666

// ZN^TCY.
#define SECTOR_SIZE 512

///////////////////////////////////////////////////////////////////////////////
// prototype.
///////////////////////////////////////////////////////////////////////////////

// {I/On.
LONG64 _GetPosition( int sector,int pos ) ;
int _GetSector( const char* path ) ;
int _FileRead( LPMHDL mh,char* buf,LONG64 pos,int length ) ;
int _FileWrite( LPMHDL mh,const char* buf,LONG64 pos,int length ) ;

// Mappingn.
void _Lock( LPMHDL mh ) ;
void _Unlock( LPMHDL mh ) ;
BOOL _GetPosRawIO( LPMHDL mh,LONG64 p ) ;
BOOL _GetFileLength( LPMHDL mh ) ;
BOOL _SetFileLenght( LPMHDL mh,LONG64 len ) ;
BOOL _CreateBuffer( LPMHDL out,int handle,int sector ) ;
void _DestroyBuffer( LPMHDL mh ) ;
BOOL _ClearWritePos( LPMHDL mh,int no ) ;
BOOL _DeleteOneBuffer( BOOL destroyFlag,LPMHDL mh,int no ) ;
BOOL _DeleteBuffer( LPMHDL mh ) ;
int _UseSpaceBuffer( LPMHDL mh ) ;
int _SearchMapping( LPMHDL mh,int addExp,LONG64 pos ) ;
BOOL _CreateMapping( LPMHDL mh,int mappingPos,LONG64 pos ) ;
int _ReadMapping( char* out,LPMHDL mh,LONG64 pos ) ;
int _WriteMapping( const char* in,LPMHDL mh,LONG64 pos ) ;

///////////////////////////////////////////////////////////////////////////////
// RawI/O.
///////////////////////////////////////////////////////////////////////////////

// NeBJZNV()Jn.
void _Lock( LPMHDL mh ) {
    pthread_mutex_lock( &mh->section ) ;
}

// NeBJZNV()I.
void _Unlock( LPMHDL mh ) {
    pthread_mutex_unlock( &mh->section ) ;
}

// w荀ԂSeek|WV擾.
LONG64 _GetPosition( int sector,int pos ) {
    return ( LONG64 )( ( LONG64 )sector * ( LONG64 )pos ) ;
}

// ZN^擾.
int _GetSector( const char* path ) {
    return SECTOR_SIZE ;
}

// t@Cǂݍ.
int _FileRead( LPMHDL mh,char* buf,LONG64 pos,int length ) {
    int ret ;
    ret = -1 ;
    ret = pread64( mh->handle,buf,length,pos ) ;
    if( ret <= -1 ) {
        return -1 ;
    }
    return ret ;
}

// t@C.
int _FileWrite( LPMHDL mh,const char* buf,LONG64 pos,int length ) {
    int ret ;
    ret = -1 ;
    ret = pwrite64( mh->handle,buf,length,pos ) ;
    if( ret <= -1 ) {
        return -1 ;
    }
    return ret ;
}

// t@CTCY擾.
BOOL _GetFileLength( LPMHDL mh ) {
    struct stat64 buf64;
    int ret;
    ret = FALSE ;
    _Lock( mh ) ;// lock.
    if( mh->handle > -1 ) {
        ret = fstat64( mh->handle,&buf64 );
        if( ret >= 0 ) {
            mh->fileLen = buf64.st_size ;
            ret = TRUE ;
        }
        else {
            mh->fileLen = 0 ;
            ret = FALSE ;
        }
    }
    _Unlock( mh ) ;// unlock.
    return ret;
}

// t@CTCYZbg.
BOOL _SetFileLenght( LPMHDL mh,LONG64 len ) {
    BOOL ret = FALSE ;
    if( mh->handle > -1 ) {
        _Lock( mh ) ;// lock.
        ret = ftruncate64( mh->handle,len ) ;
        _Unlock( mh ) ;// unlock.
    }
    return ( ret == -1 ) ? FALSE : TRUE ;
}

// obt@𐶐.
BOOL _CreateBuffer( LPMHDL out,int handle,int sector ) {
    int i ;
    out->handle = handle ;
    out->sector = sector ;
    out->len = sector * MHDL_BUF ;
    pthread_mutex_init(&out->section,NULL);
    out->average = 0 ;
    out->maxNotRangeCount = 0 ;
    out->bufRange = ( LONG64 )( ( MHDL_BUF * BUF_SIZE * ( LONG64 )sector ) * BUFFER_RANGE ) ;
    for( i = 0 ; i < BUF_SIZE ; i ++ ) {
        memset( &out->bufs[ i ],0,sizeof( MBUF ) ) ;
    }
    // t@C擾.
    if( _GetFileLength( out ) == FALSE ) {
        return FALSE ;
    }
    for( i = 0 ; i < BUF_SIZE ; i ++ ) {
        out->bufs[ i ].usePos = -1 ;
        out->bufs[ i ].useLen = -1 ;
        out->bufs[ i ].useWriteFlag = NOT_WRITE ;
        out->bufs[ i ].expire = 0 ;
        out->bufs[ i ].buf = ( char* )valloc( out->len ) ;
        _ClearWritePos( out,i ) ;
    }
    return TRUE ;
}

// ׂẴobt@j.
void _DestroyBuffer( LPMHDL mh ) {
    int i ;
    if( mh->handle != NULL ) {
        for( i = 0 ; i < BUF_SIZE ; i ++ ) {
            _DeleteOneBuffer( TRUE,mh,i ) ;
        }
    }
}

// ݃tONA.
BOOL _ClearWritePos( LPMHDL mh,int no ) {
    BOOL ret ;
    ret = TRUE ;
    // ݂݂ꍇ́Aݏs.
    if( mh->bufs[ no ].buf != NULL ) {
        memset( mh->bufs[ no ].sectorWriteFlag,NOT_WRITE,MHDL_BUF ) ;
        return TRUE ;
    }
    return FALSE ;
}

// P̃obt@𖳌ɐݒ.
BOOL _DeleteOneBuffer( BOOL destroyFlag,LPMHDL mh,int no ) {
    int i ;
    BOOL ret ;
    ret = TRUE ;
    // ݂݂ꍇ́Aݏs.
    if( mh->bufs[ no ].buf != NULL ) {
        // ݏsĂꍇ.
        if( mh->bufs[ no ].usePos != -1 && mh->bufs[ no ].useWriteFlag == USE_WRITE ) {
            int p ;
            LONG64 seek ;
            p = 0 ;
            seek = mh->bufs[ no ].usePos ;
            // ݃tOONɂȂĂeo.
            for( i = 0 ; i < MHDL_BUF ; i ++ ) {
                if( mh->bufs[ no ].sectorWriteFlag[ i ] == USE_WRITE ) {
                    _FileWrite( mh,( char* )&(mh->bufs[ no ].buf[p]),seek,mh->sector ) ;
                }
                p += mh->sector ;
                seek += ( LONG64 )mh->sector ;
            }
        }
        // obt@NA.
        _ClearWritePos( mh,no ) ;
        mh->bufs[ no ].usePos = -1 ;
        mh->bufs[ no ].useLen = -1 ;
        mh->bufs[ no ].useWriteFlag = NOT_WRITE ;
        mh->bufs[ no ].expire = 0 ;
        // obt@j̏ꍇ.
        if( destroyFlag == TRUE ) {
            if( mh->bufs[ no ].buf != NULL ) {
                free( mh->bufs[ no ].buf ) ;
                mh->bufs[ no ].buf = NULL ;
            }
        }
        return ret ;
    }
    return FALSE ;
}

// obt@𖳌ɐݒ.
BOOL _DeleteBuffer( LPMHDL mh ) {
    BOOL ret ;
    int i ;
    ret = TRUE ;
    for( i = 0 ; i < BUF_SIZE ; i ++ ) {
        BOOL res = _DeleteOneBuffer( FALSE,mh,i ) ;
        if( res == FALSE ) {
            ret = FALSE ;
        }
    }
    return ret ;
}

// Mappingɋ󂫂݂邩`FbN.
int _UseSpaceBuffer( LPMHDL mh ) {
    int i ;
    for( i = 0 ; i < BUF_SIZE ; i ++ ) {
        if( mh->bufs[ i ].usePos == -1 ) {
            return i ;
        }
    }
    return -1 ;
}

// wV[N|WVɑ΂AMapping.
int _SearchMapping( LPMHDL mh,int addExp,LONG64 pos ) {
    int i ;
    int ret = -1 ;
    for( i = 0 ; i < BUF_SIZE ; i ++ ) {
        if( mh->bufs[ i ].usePos != -1 ) {
            // Mapping͈͓̔.
            if( pos >= mh->bufs[ i ].usePos && pos < mh->bufs[ i ].usePos + mh->bufs[ i ].useLen ) {
                // Mapping͈͓I/Ȍꍇ́AExpirellɂ.
                mh->bufs[ i ].expire = 0 ;
                ret = i ;
                break ;
            }
            // Mapping͈͊O.
            //else {
            //    mh->bufs[ i ].expire += addExp ;
            //    if( mh->bufs[ i ].expire >= EXPIRE_BUF ) {
            //        _DeleteOneBuffer( FALSE,mh,i ) ;
            //    }
            //}
        }
    }
    // vBuffer݂Ȃꍇ.
    // ׂĂMappingɑ΂ExpirelCNg.
    if( ret == -1 ) {
        // Mapping͈͓ŕϒl͈͓̏ꍇ.
        if( mh->average < mh->bufRange + pos && mh->average + mh->bufRange > pos ) {
            for( i = 0 ; i < BUF_SIZE ; i ++ ) {
                if( mh->bufs[ i ].usePos != -1 ) {
                    mh->bufs[ i ].expire += addExp ;
                    if( mh->bufs[ i ].expire >= EXPIRE_BUF ) {
                        _DeleteOneBuffer( FALSE,mh,i ) ;
                    }
                }
            }
        }
    }
    return ret ;
}

// w荀Ԃɑ΂Mapping.
BOOL _CreateMapping( LPMHDL mh,int mappingPos,LONG64 pos ) {
    int i ;
    LONG64 len ;
    int res ;
    // Mappingsȏꍇ.
    if( mh->fileLen <= 0 || mh->fileLen <= pos ||
        mh->bufs[ mappingPos ].usePos != -1 ) {
        return FALSE ;
    }
    // obt@\͈͊Ȍꍇ́AMapping쐬Ȃ.
    if( ( mh->average < mh->bufRange + pos && mh->average + mh->bufRange > pos ) == FALSE ) {
        return FALSE ;
    }
    // Mapping͈͂vZ.
    len = mh->len ;
    if( len + pos >= mh->fileLen ) {
        len = mh->fileLen - pos ;
    }
    // wʒuMappingƏdȂ\邩`FbN.
    for( i = 0 ; i < BUF_SIZE ; i ++ ) {
        if( mh->bufs[ i ].usePos != -1 ) {
            // MappingƊJn|CgdȂꍇ.
            if( pos >= mh->bufs[ i ].usePos && pos < mh->bufs[ i ].usePos + mh->bufs[ i ].useLen ) {
                // Mapping͍sȂ.
                return FALSE ;
            }
            // Mapping|CgƁAΏۂMapping̒dȂꍇ.
            else if( pos < mh->bufs[ i ].usePos && pos + len >= mh->bufs[ i ].usePos ) {
                return FALSE ;
            }
        }
    }
    // Mapping̈擾.
    res = _FileRead( mh,mh->bufs[ mappingPos ].buf,pos,( int )len ) ;
    // Mappings.
    if( res == -1 ) {
        // Mappings.
        mh->bufs[ mappingPos ].usePos = -1 ;
        mh->bufs[ mappingPos ].useLen = -1 ;
        mh->bufs[ mappingPos ].useWriteFlag = NOT_WRITE ;
        mh->bufs[ mappingPos ].expire = 0 ;
        _ClearWritePos( mh,mappingPos ) ;
        return FALSE ;
    }
    // Mapping.
    mh->bufs[ mappingPos ].usePos = pos ;
    mh->bufs[ mappingPos ].useLen = len ;
    mh->bufs[ mappingPos ].useWriteFlag = NOT_WRITE ;
    mh->bufs[ mappingPos ].expire = 0 ;
    _ClearWritePos( mh,mappingPos ) ;
    return TRUE ;
}

// Mapping܂Read.
int _ReadMapping( char* out,LPMHDL mh,LONG64 pos ) {
    int ret ;
    int mappingPos ;
    char* c ;
    ret = -1 ;
    _Lock( mh ) ;// lock.
    // ANZXϒl߂.
    if( mh->average <= 0 ) {
        mh->average = pos ;
    }
    else {
        mh->average = ( mh->average + pos ) / 2 ;
    }
    // Mappingꍇ.
    if( ( mappingPos = _SearchMapping( mh,READ_EXPIRE,pos ) ) >= 0 ) {
        int p = ( int )( pos - mh->bufs[ mappingPos ].usePos ) ;
        memcpy( out,( char* )&(mh->bufs[ mappingPos ].buf[p]),mh->sector ) ;
        ret = mh->sector ;
        //mh->maxNotRangeCount = 0 ;
        goto L_SUCCESS ;
    }
    // Mapping̈悪Ȃꍇ́A󂫗̈A݂ꍇ́A
    // ɑ΂čMapping̈WJ.
    if( ( mappingPos = _UseSpaceBuffer( mh ) ) >= 0 ) {
        // Mapping̂ŁAɍ̗̈ɑ΂Mappings.
        if( _CreateMapping( mh,mappingPos,pos ) ) {
            // Mapping.
            int p = ( int )( pos - mh->bufs[ mappingPos ].usePos ) ;
            memcpy( out,( char* )&(mh->bufs[ mappingPos ].buf[p]),mh->sector ) ;
            ret = mh->sector ;
            //mh->maxNotRangeCount = 0 ;
            goto L_SUCCESS ;
        }
    }
    // ͈͊Ołꍇ.
    //mh->maxNotRangeCount ++ ;
    //if( mh->maxNotRangeCount >= MAX_NOT_RANGE ) {
    //    mh->maxNotRangeCount = 0 ;
    //    mh->average = 0 ;
    //}
    // MappingΏۂ݂AMappingłȂꍇ́Aڃt@C擾.
    c = ( char* )valloc( mh->sector ) ;
    memset( c,0,mh->sector ) ;
    ret = _FileRead( mh,c,pos,mh->sector ) ;
    memcpy( out,c,mh->sector ) ;
    free( c ) ;
    c = NULL ;
    
// Mapping̏ꍇ.
L_SUCCESS :
    _Unlock( mh ) ;// unlock.
    return ret ;
}

// Mapping܂Write.
int _WriteMapping( const char* in,LPMHDL mh,LONG64 pos ) {
    int ret ;
    int mappingPos ;
    char* c ;
    ret = -1 ;
    _Lock( mh ) ;// lock.
    // ANZXϒl߂.
    if( mh->average <= 0 ) {
        mh->average = pos ;
    }
    else {
        mh->average = ( mh->average + pos ) / 2 ;
    }
    // Mappingꍇ.
    if( ( mappingPos = _SearchMapping( mh,WRITE_EXPIRE,pos ) ) >= 0 ) {
        int p = ( int )( pos - mh->bufs[ mappingPos ].usePos ) ;
        memcpy( ( char* )&(mh->bufs[ mappingPos ].buf[p]),in,mh->sector ) ;
        mh->bufs[ mappingPos ].useWriteFlag = USE_WRITE ;
        mh->bufs[ mappingPos ].sectorWriteFlag[ p / mh->sector ] = USE_WRITE ;
        ret = mh->sector ;
        //mh->maxNotRangeCount = 0 ;
        goto L_SUCCESS ;
    }
    // Mapping̈悪Ȃꍇ́A󂫗̈A݂ꍇ́A
    // ɑ΂čMapping̈WJ.
    if( ( mappingPos = _UseSpaceBuffer( mh ) ) >= 0 ) {
        // Mapping̂ŁAɍ̗̈ɑ΂Mappings.
        if( _CreateMapping( mh,mappingPos,pos ) ) {
            // Mapping.
            int p = ( int )( pos - mh->bufs[ mappingPos ].usePos ) ;
            memcpy( ( char* )&(mh->bufs[ mappingPos ].buf[p]),in,mh->sector ) ;
            mh->bufs[ mappingPos ].useWriteFlag = USE_WRITE ;
            mh->bufs[ mappingPos ].sectorWriteFlag[ p / mh->sector ] = USE_WRITE ;
            ret = mh->sector ;
            //mh->maxNotRangeCount = 0 ;
            goto L_SUCCESS ;
        }
    }
    // ͈͊Ołꍇ.
    //mh->maxNotRangeCount ++ ;
    //if( mh->maxNotRangeCount >= MAX_NOT_RANGE ) {
    //    mh->maxNotRangeCount = 0 ;
    //    mh->average = 0 ;
    //}
    // MappingΏۂ݂AMappingłȂꍇ́Aڃt@Cɏ.
    c = ( char* )valloc( mh->sector ) ;
    memcpy( c,in,mh->sector ) ;
    ret = _FileWrite( mh,c,pos,mh->sector ) ;
    free( c ) ;
    c = NULL ;
    
// Mapping̏ꍇ.
L_SUCCESS :
    _Unlock( mh ) ;// unlock.
    return ret ;
}

///////////////////////////////////////////////////////////////////////////////
// RawI/O.
///////////////////////////////////////////////////////////////////////////////

// rawioN[Y.
void CloseRawIO( LPMHDL mh ) {
    if( mh->handle != NULL ) {
        _DestroyBuffer( mh ) ;
        pthread_mutex_destroy(&mh->section);
        close( mh->handle ) ;
        memset( mh,0,sizeof( MHDL ) ) ;
        free( mh ) ;
    }
}

// rawioI[v.
LPMHDL OpenRawIO( int* result,const char* path,const char* drv ) {
    LPMHDL ret ;
    int sectorSize ;
    int handle ;
    handle = open64( path,
        ( O_RDWR | O_DIRECT | O_NOATIME | O_CREAT | O_LARGEFILE | O_SYNC ),
        //( O_RDWR | O_NOATIME | O_CREAT | O_LARGEFILE | O_SYNC ),
        PERMISSION ) ;
    if( handle <= -1 ) {
        *result = 0 ;
        return NULL ;
    }
    // _ANZXōœK.
    posix_fadvise64( handle, 0, 0, POSIX_FADV_RANDOM ) ;
    // MHDL.
    sectorSize = _GetSector( drv ) ;
    *result = 1 ;
    ret = ( LPMHDL )malloc( sizeof( MHDL ) ) ;
    // t@C擾.
    if( _CreateBuffer( ret,handle,sectorSize ) == FALSE ) {
        // t@C̎擾Ɏsꍇ́Aej.
        CloseRawIO( ret ) ;
        *result = 0 ;
        ret = NULL ;
    }
    return ret ;
}

// wʒũZN^.
int WriteRawIO( LPMHDL mh,const char* data,int pos ) {
    return _WriteMapping( data,mh,_GetPosition( mh->sector,pos ) ) ;
}

// wʒũZN^ǂݍ.
int ReadRawIO( LPMHDL mh,char* data,int pos ) {
    return _ReadMapping( data,mh,_GetPosition( mh->sector,pos ) ) ;
}

// ݂̃t@CTCY擾.
BOOL GetLengthRawIO( LONG64* out,LPMHDL mh ) {
    _Lock( mh ) ;// lock.
    *out = mh->fileLen ;
    _Unlock( mh ) ;// unlock.
    return TRUE ;
}

// t@CTCYZbg.
BOOL SetLengthRawIO( LPMHDL mh,LONG64 len ) {
    return _SetFileLenght( mh,len ) ;
}

// ZN^擾.
int GetSector( LPMHDL mh ) {
    int ret ;
    _Lock( mh ) ;// lock.
    ret = mh->sector ;
    _Unlock( mh ) ;// unlock.
    return ret ;
}

// ZN^擾.
int GetSectorByPath( const char* path ) {
    return _GetSector( path ) ;
}
