#include "../../include/org_maachang_rawio_NativeRawIO.h"
#include "rawio.h"

#pragma comment(lib,"jvm.lib")

///////////////////////////////////////////////////////////////////////////////
// JNI.
///////////////////////////////////////////////////////////////////////////////

// ZN^TCY擾.
JNIEXPORT jint JNICALL Java_org_maachang_rawio_NativeRawIO_getSector
  (JNIEnv* env, jclass c, jbyteArray a1) {
    jint ret ;
    jbyte* path ;
    path = (*env)->GetPrimitiveArrayCritical(env, a1, NULL);
    ret = GetSectorByPath( ( char* )path ) ;
    (*env)->ReleasePrimitiveArrayCritical(env, a1, path, JNI_ABORT);
    return ret ;
}

// nhZN^擾.
JNIEXPORT jint JNICALL Java_org_maachang_rawio_NativeRawIO_getSectorByHandle
  (JNIEnv* env, jclass c, jlong a1) {
    return GetSector( ( LPMHDL )a1 ) ;
}

// Rawt@CI[v.
JNIEXPORT jlong JNICALL Java_org_maachang_rawio_NativeRawIO_rawOpen
  (JNIEnv* env, jclass c, jbyteArray a1, jbyteArray a2) {
    int result ;
    jbyte* path ;
    jbyte* drv ;
    LPMHDL ret ;
    path = (*env)->GetPrimitiveArrayCritical(env, a1, NULL);
    drv = (*env)->GetPrimitiveArrayCritical(env, a2, NULL);
    ret = OpenRawIO( &result,( const char* )path,( const char* )drv ) ;
    (*env)->ReleasePrimitiveArrayCritical(env, a1, path, JNI_ABORT);
    (*env)->ReleasePrimitiveArrayCritical(env, a2, drv, JNI_ABORT);
    if( result == 0 ) {
        return ( jlong )-1 ;
    }
    return ( jlong )ret ;
}

// Rawt@CN[Y.
JNIEXPORT void JNICALL Java_org_maachang_rawio_NativeRawIO_rawClose
  (JNIEnv* env, jclass c, jlong a1) {
    CloseRawIO( ( LPMHDL )a1 ) ;
}

// Rawt@C.
JNIEXPORT jint JNICALL Java_org_maachang_rawio_NativeRawIO_rawWrite
  (JNIEnv* env, jclass c, jlong a1, jint a2, jbyteArray a3) {
    jbyte* data ;
    jint ret ;
    data = (*env)->GetPrimitiveArrayCritical(env, a3, NULL);
    ret = WriteRawIO( ( LPMHDL )a1,( const char* )data,a2 ) ;
    (*env)->ReleasePrimitiveArrayCritical(env, a3, data, JNI_ABORT);
    return ret ;
}

// Rawt@Cǂݍ.
JNIEXPORT jint JNICALL Java_org_maachang_rawio_NativeRawIO_rawRead
  (JNIEnv* env, jclass c, jlong a1, jint a2, jbyteArray a3) {
    jbyte* data ;
    jint ret ;
    data = (*env)->GetPrimitiveArrayCritical(env, a3, NULL);
    ret = ReadRawIO( ( LPMHDL )a1,( char* )data,a2 ) ;
    (*env)->ReleasePrimitiveArrayCritical(env, a3, data, 0);
    return ret ;
}

// Rawt@C擾.
JNIEXPORT jlong JNICALL Java_org_maachang_rawio_NativeRawIO_getRawLength
  (JNIEnv* env, jclass c, jlong a1) {
    jlong ret ;
    if( GetLengthRawIO( &ret,( LPMHDL )a1 ) == FALSE ) {
        return ( jlong )-1 ;
    }
    return ret ;
}

// Rawt@CZbg.
JNIEXPORT jint JNICALL Java_org_maachang_rawio_NativeRawIO_setRawLength
  (JNIEnv* env, jclass c, jlong a1, jlong a2) {
    if( SetLengthRawIO( ( LPMHDL )a1,a2 ) == FALSE ) {
        return -1 ;
    }
    return 0 ;
}


