package org.maachang.rawio.mapping ;

/**
 * １つのMapping操作.
 *  
 * @version 2008/06/15
 * @author  masahito suzuki
 * @since   Rawio 1.00
 */
public interface MappingOp {
    
    /**
     * セクタ長を取得.
     * @return sector セクタ長が返されます.
     */
    public int getSector() ;
    
    /**
     * Mapping開始ポジションを取得.
     * @return int Mapping開始ポジションが返されます.
     */
    public int getStartPos() ;
    
    /**
     * Mapping長を取得.
     * @return int Mapping長が返されます.
     */
    public int getLength() ;
    
    /**
     * Mappingバイナリ長を取得.
     * @return int Mappingバイナリ長が返されます.
     */
    public int getBinaryLength() ;
    
    /**
     * 指定位置内容を取得します.
     * @param pos 対象のポジションを設定します.
     * @return boolean 対象の要素が返されます.
     */
    public boolean readBoolean( int pos ) ;
    
    /**
     * 指定位置内容を設定します.
     * @param value 対象の要素を設定します.
     * @param pos 対象のポジションを設定します.
     */
    public void writeBoolean( boolean value,int pos ) ;
    
    /**
     * 指定位置内容を取得します.
     * @param pos 対象のポジションを設定します.
     * @return byte 対象の要素が返されます.
     */
    public byte readByte( int pos ) ;
    
    /**
     * 指定位置内容を設定します.
     * @param value 対象の要素を設定します.
     * @param pos 対象のポジションを設定します.
     */
    public void writeByte( byte value,int pos ) ;
    
    /**
     * 指定位置内容を取得します.
     * @param pos 対象のポジションを設定します.
     * @return char 対象の要素が返されます.
     */
    public char readChar( int pos ) ;
    
    /**
     * 指定位置内容を設定します.
     * @param value 対象の要素を設定します.
     * @param pos 対象のポジションを設定します.
     */
    public void writeChar( char value,int pos ) ;
    
    /**
     * 指定位置内容を取得します.
     * @param pos 対象のポジションを設定します.
     * @return short 対象の要素が返されます.
     */
    public short readShort( int pos ) ;
    
    /**
     * 指定位置内容を設定します.
     * @param value 対象の要素を設定します.
     * @param pos 対象のポジションを設定します.
     */
    public void writeShort( short value,int pos ) ;
    
    /**
     * 指定位置内容を取得します.
     * @param pos 対象のポジションを設定します.
     * @return int 対象の要素が返されます.
     */
    public int readInt( int pos ) ;
    
    /**
     * 指定位置内容を設定します.
     * @param value 対象の要素を設定します.
     * @param pos 対象のポジションを設定します.
     */
    public void writeInt( int value,int pos ) ;
    
    /**
     * 指定位置内容を取得します.
     * @param pos 対象のポジションを設定します.
     * @return long 対象の要素が返されます.
     */
    public long readLong( int pos ) ;
    
    /**
     * 指定位置内容を設定します.
     * @param value 対象の要素を設定します.
     * @param pos 対象のポジションを設定します.
     */
    public void writeLong( long value,int pos ) ;
    
    /**
     * 指定位置内容を取得します.
     * @param pos 対象のポジションを設定します.
     * @param length 対象の長さを設定します.
     * @return byte[] 対象の要素が返されます.
     */
    public byte[] readBytes( int pos,int length ) ;
    
    /**
     * 指定位置内容を取得します.
     * @param out データ格納対象のバイナリを設定します.
     * @param pos 対象のポジションを設定します.
     * @param off 対象のオフセットを設定します.
     * @param length 対象の長さを設定します.
     * @return int 取得された要素長が返されます.
     */
    public int readBytes( byte[] out,int pos,int off,int length ) ;
    
    /**
     * 指定位置内容を設定します.
     * @param value 対象の要素を設定します.
     * @param pos 対象のポジションを設定します.
     * @param off 対象のオフセットを設定します.
     * @param length 対象の長さを設定します.
     * @return int 書き込まれたバイナリ長を設定します.
     */
    public int writeBytes( byte[] value,int pos,int off,int length ) ;
    
}
