// ** Microsoft-HTA専用JavaScript. ** //
// hta.js

// 基本ユーティリティ.
$util = {
    // nullチェック.
    isNull : function( value ) {
        return ( value == null || typeof( value ) == "undefined" ) ;
    },
    // trim.
    trim : function(arg_value){
        if( this.isNull( arg_value ) == true ||
            arg_value.length <= 0 ) {
            return '' ;
        }
        else if( typeof( arg_value ) != "string" ) {
            return arg_value ;
        }
        for( i = 0; i < arg_value.length ; i ++ ) {
            var old = arg_value ;
            arg_value = arg_value.replace( "&nbsp;"," " ) ;
            if( old.length == arg_value.length ) {
                break ;
            }
        }
        
        var st = 0 ;
        var ed = arg_value.length ;
        var len = arg_value.length ;
        for( i = 0 ; i < len ; i ++ ) {
            var c = arg_value.charAt( i ) ;
            var x = arg_value.charCodeAt( i ) ;
            if( c == ' ' || c == '　' || c == '\t' || c == '\r' || c == '\n' || x == 160 ) {//x==160はsafari対応.
                st = i+1 ;
            }
            else {
                break ;
            }
        }
        len = arg_value.length-1 ;
        for( i = len ; i >= 0 ; i -- ) {
            var c = arg_value.charAt( i ) ;
            var x = arg_value.charCodeAt( i ) ;
            if( c == ' ' || c == '　' || c == '\t' || c == '\r' || c == '\n' || x == 160 ) {//x==160はsafari対応.
                ed = i ;
            }
            else {
                break ;
            }
        }
        if( st >= ed ) {
            return '' ;
        }
        ret = arg_value.substring( 0,ed ) ;
        if( st > 0 ) {
            ret = ret.substring( st ) ;
        }
        return ret ;
    },
    // 文字列を置き換える.
    changeString : function( base,src,dest ) {
        if( this.isNull( base ) ) {
            return "" ;
        }
        if( this.isNull( src ) || src.length <= 0 ||
            this.isNull( dest ) ) {
            return base ;
        }
        var pnt;
        var end;
        var buf = "";
        var srcLen = src.length ;
        pnt = base.indexOf(src);
        if (pnt == -1) {
            return base;
        } else if (pnt == 0) {
            buf += dest ;
            end = srcLen;
        } else {
            buf += base.substring(0, pnt);
            buf += dest;
            end = pnt + srcLen;
        }
        for (pnt += srcLen;;) {
            if ((pnt = base.indexOf(src, pnt)) == -1) {
                buf += base.substring(end);
                break;
            }
            if (pnt == end) {
                buf += dest;
            } else {
                buf += base.substring(end, pnt);
                buf += dest;
            }
            end = pnt + srcLen;
            pnt += srcLen;
        }
        return buf ;
    },
    // startWith.
    startsWith : function(str,chk) {
        if( this.isNull( str ) || this.isNull( chk ) ) {
            return false ;
        }
        str = ""+str ;
        chk = ""+chk ;
        if( str == chk || str.indexOf( chk ) == 0 ) {
            return true ;
        }
        return false ;
    },
    // endsWith.
    endsWith : function(str,chk) {
        if( this.isNull( str ) || this.isNull( chk ) ) {
            return false ;
        }
        str = ""+str ;
        chk = ""+chk ;
        if( str == chk ) {
            return true ;
        }
        var last = str.lastIndexOf( chk ) ;
        if( last != -1 && last == str.length-chk.length ) {
            return true ;
        }
        return false ;
    },
    // 文字存在チェック.
    useString : function(str){
        if( this.isNull( str ) == true || this.trim(str).length <= 0 ) {
            return false ;
        }
        return true ;
    },
    // 数値チェック.
    isNumeric : function(num){
        if( !this.useString( num ) ) {
            return false ;
        }
        if( this.startsWith( num,"-" ) ) {
            num = num.substring( 1 ) ;
        }
        num = ""+num ;
        if ( this.isNull(num.match) || num.match(/[^0-9.0-9]/g)) {
            return false;
        }
        return true;
    },
    // 指定内容タイプを取得.
    valueof : function( val ) {
        if( this.isNull( val ) ) {
            return "null" ;
        }
        var t = typeof( val ) ;
        if( t == "string" ) {
            return "string" ;
        }
        if( t == "boolean" ) {
            return "boolean" ;
        }
        else if( t == "number" ) {
            return "number" ;
        }
        else if( t == "function" ) {
            return "function" ;
        }
        else if( t == "date" ) {
            return "date" ;
        }
        else if( t == "object" ) {
            if( val instanceof Date ) {
                return "date" ;
            }
            else if( val instanceof Array ) {
                if( val.length == 0 ) {
                    return "array" ;
                }
                if( typeof( val.length ) == "number" ) {
                    return "array" ;
                }
                for( var k in val ) {
                    return "map" ;
                }
                return "object" ;
            }
        }
        if( typeof( val.length ) == "number" ) {
            return "array" ;
        }
        for( var k in val ) {
            return "map" ;
        }
        return "object" ;
    }
} ;

// ローカルファイルI/Oオブジェクト.
LocalIO = {
    READ:1,
    WRITE:2,
    APPEND:8,
    _ENV : new ActiveXObject("WScript.Shell"),
    _IO : new ActiveXObject("Scripting.FileSystemObject"),
    // 環境変数を取得.
    env : function( env ) {
        var f = LocalIO._ENV ;
        var ret = f.Environment(env);
        return ret ;
    },
    // フルパスを取得.
    getFullPath : function( name ) {
        var f = LocalIO._IO ;
        name = f.GetBaseName( name ) ;
        return name ;
    },
    // 新しい空のファイルを生成.
    createFile : function( name ) {
        var ret = new OutputStream() ;
        if( ret.open( LocalIO.WRITE,name ) ) {
            ret.close() ;
        }
        return null ;
    },
    // 新しいフォルダを生成.
    createFolder : function( name ) {
        var ret = false ;
        var f = LocalIO._IO ;
        if( !f.FolderExists( name ) ) {
            f.CreateFolder( name ) ;
            ret = true ;
        }
        f = null ;
        return ret ;
    },
    // 削除ファイル処理.
    removeFile : function( name ) {
        if( !LocalIO.isFile( name ) ) {
            return false ;
        }
        var f = LocalIO._IO ;
        f.DeleteFile( name ) ;
        f = null ;
        return true ;
    },
    // 削除フォルダ処理.
    removeFolder : function( name ) {
        if( !LocalIO.isFolder( name ) ) {
            return false ;
        }
        var f = LocalIO._IO ;
        f.DeleteFolder( name ) ;
        f = null ;
        return true ;
    },
    // ファイル移動.
    moveFile : function( src,dest ) {
        if( !LocalIO.isFile( src ) || LocalIO.isFile( dest ) ) {
            return false ;
        }
        var f = LocalIO._IO ;
        var fs = f.GetFile(src) ;
        fs.Name = dest ;
        f = null ;
        fs = null ;
        return true ;
    },
    // 読み込み専用オープン.
    inputStream : function( name ) {
        var ret = new InputStream() ;
        if( ret.open( LocalIO.READ,name ) ) {
            return ret ;
        }
        return null ;
    },
    // 読み込み／書き込み専用オープン.
    outputStream : function( name ) {
        var ret = new OutputStream() ;
        if( ret.open( LocalIO.WRITE,name ) ) {
            return ret ;
        }
        return null ;
    },
    // 追加読み込み／書き込み専用オープン.
    outputAppendStream : function( name ) {
        var ret = new OutputStream() ;
        if( ret.open( LocalIO.APPEND,name ) ) {
            return ret ;
        }
        return null ;
    },
    // ファイル存在チェック.
    isFile : function( name ) {
        var f = LocalIO._IO ;
        var ret = f.FileExists( name ) ;
        f = null ;
        return ret ;
    },
    // フォルダ存在チェック.
    isFolder : function( name ) {
        var f = LocalIO._IO ;
        var ret = f.FolderExists( name ) ;
        f = null ;
        return ret ;
    }
} ;

// ファイル読み込み.
InputStream = function( name ){
    if( $util.useString( name ) ) {
        this.open( name ) ;
    }
}
InputStream.prototype = {
    fp : null,
    fileName : null,
    // 条件設定ファイルオープン.
    open : function( name ) {
        if( !LocalIO.isFile( name ) ) {
            return false ;
        }
        var f = LocalIO._IO ;
        this.fp = f.OpenTextFile(name,LocalIO.READ,true ) ;
        this.fileName = tName ;
        f = null ;
        var tName = name ;
        return true ;
    },
    // ファイルクローズ.
    close : function() {
        if( this.fp != null ) {
            this.fp.close() ;
        }
        this.fp = null ;
        this.fileName = null ;
    },
    // 行読み込み処理.
    read : function() {
        if( this.fp == null ) {
            return null ;
        }
        var ret = null ;
        if( this.fp.AtEndOfStream ) {
            try {
                ret = this.fp.readLine() ;
            } catch( e ) {
                ret = null ;
            }
        }
        else {
            ret = this.fp.readLine() ;
        }
        return ret ;
    },
    // ファイル名を取得.
    name : function() {
        if( this.fp == null ) {
            return null ;
        }
        return this.fileName ;
    }
} ;

// ファイル書き込み.
OutputStream = function( name ){
    if( $util.useString( name ) ) {
        this.open( name ) ;
    }
}
OutputStream.prototype = {
    fp : null,
    fileName : null,
    // 条件設定ファイルオープン.
    open : function( name,mode ) {
        var f = LocalIO._IO ;
        if( $util.isNull( mode ) ) {
            mode = LocalIO.APPEND ;
        }
        if( mode == LocalIO.APPEND && !f.FileExists( name ) ) {
            mode = LocalIO.WRITE ;
        }
        this.fp = f.OpenTextFile(name,mode,true ) ;
        this.fileName = tName ;
        f = null ;
        var tName = name ;
        return true ;
    },
    // ファイルクローズ.
    close : function() {
        if( this.fp != null ) {
            this.fp.close() ;
        }
        this.fp = null ;
        this.fileName = null ;
    },
    // 行書き込み処理.
    write : function( value ) {
        if( this.fp == null ) {
            return false ;
        }
        this.fp.writeLine( value ) ;
        return true ;
    },
    // ファイル名を取得.
    name : function() {
        if( this.fp == null ) {
            return null ;
        }
        return this.fileName ;
    }
} ;

// iniファイルを取得.
Ini = function( name ){
    if( $util.useString( name ) ) {
        this.create( name ) ;
    }
}
Ini.prototype = {
    _map : null,
    create : function( name ) {
        var buf = new InputStream() ;
        if( !buf.open( name ) ) {
            return false ;
        }
        var list = [] ;
        // 全内容を改行単位でリストに取得.
        var s ;
        while( true ) {
            s = buf.read()
            if( $util.isNull( s ) ) {
                break ;
            }
            list[list.length] =  s ;
        }
        buf.close() ;
        buf = null ;
        // コメントをはずす.
        var c ;
        var len = list.length ;
        var lenJ ;
        var cote = -1 ;
        var bef = -1 ;
        for( var i = 0 ; i < len ; i ++ ) {
            s = list[ i ] ;
            lenJ = s.length ;
            for( var j = 0 ; j < lenJ ; j ++ ) {
                c = s.charAt( j ) ;
                if( cote == -1 ) {
                    if( c == '#' ) {
                        list[ i ] = s.substring( 0,j ) ;
                        break ;
                    }
                    else if( bef != '\\' && ( c == '\'' || c == '\"' ) ) {
                        cote = c ;
                    }
                }
                else if( bef != '\\' && c == cote ) {
                    cote = -1 ;
                }
                bef = c ;
            }
        }
        // データ解析.
        var s = null ;
        var len = list.length ;
        var lenJ = 0 ;
        var cote = -1 ;
        var par = -1 ;
        var parCount = 0 ;
        var bef = -1 ;
        var type = 0 ;
        var b = null ;
        var section = null ;
        var key = null ;
        var value = null ;
        var c ;
        var map = {} ;
        for( var i = 0 ; i < len ; i ++ ) {
            s = list[ i ] ;
            lenJ = s.length ;
            bef = -1 ;
            for( var j = 0 ; j < lenJ ; j ++ ) {
                c = s.charAt( j ) ;
                switch( type ) {
                case 0 :// セクション/キー取得条件.
                {
                    if( b != null ) {
                        b += c ;
                    }
                    // セクション系情報を取得.
                    if( c == '[' ) {
                        section = null ;
                        b = "" ;
                    }
                    else if( c == ']' ) {
                        section = b ;
                        section = $util.trim( section.substring( 0,section.length-1 ) ) ;
                        b = null ;
                    }
                    else if( section == null ) {
                        // 情報読み込み中か、空白は無視.
                        if( b != null || c == ' '  || c == '　' || c == '\t' ) {
                            bef = c ;
                            continue ;
                        }
                        // セクション情報が取得されていない場合に、
                        // 何らかの文字列が出現した場合は、エラー.
                        throw "Section information is not defined." ;
                    }
                    // キー条件を取得.
                    else {
                        if( c == '=' ) {
                            if( b == null ) {
                                throw "An illegal character string exists." ;
                            }
                            else {
                                key = b ;
                                key = $util.trim( key.substring( 0,key.length-1 ) ) ;
                                b = "" ;
                                type = 1 ;// 要素取得処理へ.
                            }
                        }
                        // キー開始の場合.
                        else if( b == null && 
                                (
                                ( c >= 'a' && c <= 'z' ) ||
                                ( c >= 'A' && c <= 'Z' ) ||
                                ( c >= '0' && c <= '9' ) ||
                                c == '$' || c == '@' || c == '_' 
                                ) ) {
                            b = c ;
                        }
                    }
                }
                break ;
                case 1 :// 要素取得条件.
                {
                    b += c ;
                    // コーテーション終端を検地.
                    if( cote != -1 ) {
                        if( bef != '\\' && cote == c ) {
                            cote = -1 ;
                            c = 0 ;
                        }
                    }
                    // 括弧の終端を検地.
                    else if( par != -1 ) {
                        if( ( par == '{' && c == '}' ) ||
                            ( par == '[' && c == ']' ) ||
                            ( par == '(' && c == ')' ) ||
                            ( par == '<' && c == '>' ) ) {
                            parCount -- ;
                            if( parCount <= 0 ) {
                                parCount = 0 ;
                                par = -1 ;
                            }
                        }
                    }
                    // コーテーション検出.
                    if( cote == -1 && ( c == '\'' || c == '\"' ) ) {
                        cote = c ;
                    }
                    // 括弧検出.
                    else if( cote == -1 && ( c == '{' || c == '[' || c == '(' || c == '<' ) ) {
                        if( par == -1 ) {
                            par = c ;
                        }
                        if( c == par ) {
                            parCount ++ ;
                        }
                    }
                    // 終端条件の場合.
                    else if( lenJ <= j + 1 || ( cote == -1 && par == -1 && c == ';' ) ) {
                        // value定義が存在していて、コーテーションおよび、
                        // 括弧条件が存在しない場合.
                        if( cote == -1 && par == -1 ) {
                            value = $util.trim( b ) ;
                            // ；での終端設定の場合.
                            if( c == ';' ) {
                                value = $util.trim( value.substring( 0,value.length - 1 ) ) ;
                            }
                        }
                        // value終端条件でない場合.
                        else {
                            bef = c ;
                            continue ;
                        }
                        if( $util.isNull( map[section] ) ) {
                            map[section] = {} ;
                        }
                        map[ section ][key] = value ;
                        key = null ;
                        value = null ;
                        b = null ;
                        type = 0 ;// 最初に戻る.
                    }
                }
                break ;
                }
                bef = c ;
            }
            // valueが定義されていない場合は、value=""として格納する.
            if( type == 1 && section != null && key != null && value == null ) {
                if( $util.isNull( map[section] ) ) {
                    map[section] = {} ;
                }
                map[ section ][key] = "" ;
                key = null ;
                value = null ;
                b = null ;
                type = 0 ;// 最初に戻る.
            }
        }
        this._map = map ;
        return true ;
    },
    // クリア処理.
    clear : function() {
        this._map = null ;
    },
    // 取得.
    get : function( section,key ) {
        if( $util.isNull( this._map ) || $util.isNull( this._map[ section ] ) ||
            $util.isNull( this._map[ section ][key] ) ) {
            return null ;
        }
        var ret = this._map[ section ][key] ;
        if( $util.startsWith( ret,"\"" ) || $util.endsWith( ret,"\'" ) ) {
            ret = $util.trim( ret.substring( 1,ret.length-1 ) ) ;
        }
        return  ret ;
    },
    // セクションが存在するかチェック.
    isSection : function( section ) {
        return ( $util.isNull( this._map ) || $util.isNull( this._map[ section ] ) ) ;
    },
    // セクション内のキーが存在するかチェック.
    isKey : function( section,key ) {
        return ( $util.isNull( this._map ) ||
            $util.isNull( this._map[ section ] ) ||
            $util.isNull( this._map[ section ][key] ) ) ;
    },
    // 生成されているかチェック.
    isCreate : function() {
        return $util.isNull( this._map ) ;
    },
    // 文字列出力.
    toString : function() {
        if( $util.isNull( this._map ) ) {
            return "" ;
        }
        var map = this._map ;
        var ret = "" ;
        for( var sk in map ) {
            ret += " " + sk + "{" ;
            var cnt = 0 ;
            for( var k in map[sk] ) {
                if( cnt != 0 ) {
                    ret += ", " ;
                }
                ret += k + ":" + map[sk][k] ;
                cnt ++ ;
            }
            ret += "} " ;
        }
        return ret ;
    }
}

