// ** Microsoft-HTA専用JavaScript. ** //
// MS-Access(JET:DAO.DBEngine)に対するI/O処理.
//

// データ型.
DBType = {
    VARCHAR : function( len ) {
        if( !$util.isNumeric( len ) || len <= 0 ) {
            return "VARCHAR" ;
        }
        return "VARCHAR(" + len + ")" ;
    },
    CHAR :      "VARCHAR",
    TEXT :      "MEMO",
    SMALL :     "SMALLINT",
    INTEGER :   "INTEGER",
    LONG :      "FLOAT",
    FLOAT :     "REAL",
    DOUBLE :    "FLOAT",
    BOOLEAN :   "YESNO",
    TIMESTAMP : "DATETIME",
    AUTO :      "AUTOINCREMENT"
}

// MSAccessオブジェクト.
MsAccess = function( name ) {
    if( $util.useString( name ) ) {
        this.open( name ) ;
    }
}
// Accessテーブル最適化.
MsAccess.smart = function( name ) {
    if( !$util.useString( name ) ) {
        return false ;
    }
    name = $util.trim( name ) ;
    if( !$util.endsWith( name,".mdb" ) ) {
        name = name + ".mdb" ;
    }
    if( !LocalIO.isFile(name) ) {
        return false ;
    }
    var obj = new ActiveXObject("JRO.JetEngine") ;
    if( $util.isNull( obj ) ) {
        return false ;
    }
    name = name.substring( 0,name.length-4 ) ;
    var strOld = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + name + ".old.mdb" ;
    var strNew = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + name + ".mdb" ;
    if( LocalIO.isFile(name + ".old.mdb") ) {
        LocalIO.removeFile( name + ".old.mdb" ) ;
    }
    LocalIO.moveFile( name + ".mdb",name + ".old.mdb" ) ;
    obj.CompactDatabase( strOld,strNew ) ;
    return true ;
}
// プロトタイプ定義.
MsAccess.prototype = {
    _ws : null,
    _db : null,
    _name : null,
    _trans : false,
    // テーブルオブジェクトを取得.
    _$tableObject : function( table ) {
        if( $util.isNull( this._db ) ) {
            return null ;
        }
        table = $util.trim( table ).toLowerCase() ;
        var t = this._db.TableDefs ;
        var cnt = 0 ;
        while( true ) {
            try {
                if( table == t(cnt).Name.toLowerCase() ) {
                    return t(cnt) ;
                }
            } catch( e ) {
                break ;
            }
            cnt ++ ;
        }
        return null ;
    },
    // テーブルインデックスを取得.
    _$tableIndex : function( table ) {
        var tobj = this._$tableObject( table ) ;
        if( $util.isNull( tobj ) ) {
            return null ;
        }
        var ret = [] ;
        var name = null ;
        var indexs = tobj.Indexes ;
        tobj = null ;
        var cnt = 0 ;
        while( true ) {
            try {
                name = indexs(cnt).Name ;
                ret[ ret.length ] = name ;
            } catch( e ) {
                break ;
            }
            cnt ++ ;
        }
        return ret ;
    },
    // DBオープン.
    open : function( name ) {
        this.close() ;
        var obj = null ;
        try {
            obj = new ActiveXObject( "DAO.DBEngine.35" ) ;
        } catch( e ) {
            obj = null ;
        }
        if( $util.isNull( obj ) ) {
            try {
                obj = new ActiveXObject( "DAO.DBEngine.36" ) ;
            } catch( e ) {
                obj = null ;
            }
        }
        if( $util.isNull( obj ) ) {
            try {
                obj = new ActiveXObject( "DAO.DBEngine.120" ) ;
            } catch( e ) {
                obj = null ;
            }
        }
        if( $util.isNull( obj ) ) {
            return false ;
        }
        name = $util.trim( name ) ;
        if( !$util.endsWith( name,".mdb" ) ) {
            name = name + ".mdb" ;
        }
        var db = null ;
        var ws = obj.Workspaces(0) ;
        if( !LocalIO.isFile(name) ) {
            db = ws.CreateDataBase( name,";LANGID=0x0411;CP=932;COUNTRY=0" ) ;
        }
        else {
            db = ws.OpenDataBase( name ) ;
        }
        this._ws = ws ;
        this._db = db ;
        this._name = name ;
        this._trans = false ;
        ws = null ;
        obj = null ;
        return true ;
    },
    // DBクローズ.
    close : function() {
        if( !$util.isNull( this._db ) ) {
            if( this._trans ) {
                try {
                    this._ws.CommitTrans() ;
                } catch( e ) {
                }
            }
            try {
                this._db.Cloes() ;
            } catch( e ) {
            }
            this._db = null ;
        }
        if( !$util.isNull( this._ws ) ) {
            try {
                this._ws.Close() ;
            } catch( e ) {
            }
            this._ws = null ;
        }
        this._name = null ;
        this._trans = false ;
    },
    // トランザクション開始.
    transaction : function() {
        if( !$util.isNull( this._ws ) && !this._trans ) {
            this._ws.beginTrans() ;
            this._trans = true ;
        }
    },
    // コミット処理.
    commit : function() {
        if( !$util.isNull( this._ws ) && this._trans ) {
            this._ws.CommitTrans() ;
            this._trans = false ;
        }
    },
    // ロールバック処理.
    rollback : function() {
        if( !$util.isNull( this._ws ) && this._trans ) {
            this._ws.Rollback() ;
            this._trans = false ;
        }
    },
    // テーブル作成.
    createTable : function( table,columns,keys,checkTableFlag ) {
        if( $util.isNull( this._db ) || !$util.useString( table ) ||
            $util.isNull( columns ) || $util.valueof( columns ) != "map" ) {
            return false ;
        }
        if( $util.isNull( checkTableFlag ) || checkTableFlag == false ) {
            if( this.isTable( table ) ) {
                return false ;
            }
        }
        var sql = "CREATE TABLE " + table + " (" ;
        var cnt = 0 ;
        if( !$util.isNull( keys ) && $util.valueof( keys ) == "array" ) {
            var ks = [] ;
            for( var k in columns ) {
                if( cnt != 0 ) {
                    sql += "," ;
                }
                sql += " " + k + " " + columns[ k ] ;
                cnt ++ ;
            }
            var len = keys.length ;
            sql += " ,CONSTRAINT " + table.toLowerCase() + "_keys PRIMARY KEY (" ;
            for( var i = 0 ; i < len ; i ++ ) {
                if( i != 0 ) {
                    sql += "," ;
                }
                sql += " " + keys[ i ] ;
            }
            sql += ")" ;
        }
        else {
            for( var k in columns ) {
                if( cnt != 0 ) {
                    sql += "," ;
                }
                sql += " " + k + " " + columns[ k ] ;
                cnt ++ ;
            }
        }
        sql += " );" ;
        this.transaction() ;
        try {
            this._db.Execute( sql ) ;
            if( $util.valueof( keys ) == "array" ) {
                sql = "CREATE INDEX " + table.toLowerCase() + "_index ON " + table + " (" ;
                var len = keys.length ;
                for( var i = 0 ; i < len ; i ++ ) {
                    if( i != 0 ) {
                        sql += "," ;
                    }
                    sql += " " + keys[ i ] ;
                }
                sql += ") WITH DISALLOW NULL ;" ;
                this._db.Execute( sql ) ;
            }
            return true ;
        } catch( e ) {
            this.rollback() ;
            throw e ;
        }
    },
    // テーブル削除.
    dropTable : function( table,checkTableFlag ) {
        if( $util.isNull( this._db ) || !$util.useString( table ) ) {
            return false ;
        }
        if( $util.isNull( checkTableFlag ) || checkTableFlag == false ) {
            if( this.isTable( table ) ) {
                return false ;
            }
        }
        table = table.toLowerCase() ;
        this.transaction() ;
        try {
            this._db.Execute( "DROP INDEX " + table + "_index ON " + table + " ;" ) ;
        } catch( e ) {
        }
        try {
            this._db.Execute( "DROP INDEX " + table + "_keys ON " + table + " ;" ) ;
        } catch( e ) {
        }
        try {
            this._db.Execute( "DROP TABLE " + table + " ;" ) ;
        } catch( e ) {
            this.rollback() ;
            return false ;
        }
        return true ;
    },
    // テーブルが存在する場合は、DropしてCreateするテーブル作成.
    createDropTable : function( table,columns,keys ) {
        this.dropTable( table,true ) ;
        return this.createTable( table,columns,keys,true ) ;
    },
    // 行追加.
    insert : function( table,values ) {
        if( $util.isNull( this._db ) || !$util.useString( table ) ||
            $util.isNull( values ) || $util.valueof( values ) != "map" ) {
            return false ;
        }
        var sql = "INSERT INTO " + table + " ( " ;
        var cnt = 0 ;
        var vals = [] ;
        for( var k in values ) {
            if( cnt != 0 ) {
                sql += "," ;
            }
            vals[ vals.length ] = values[ k ] ;
            sql += " " + k ;
            cnt ++ ;
        }
        sql += " ) VALUES ( " ;
        var len = vals.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            if( i != 0 ) {
                sql += "," ;
            }
            sql += "p_col_" + i + " " ;
        }
        sql += " ) ;" ;
        this.transaction() ;
        try {
            var qdf = this._db.CreateQueryDef( "",sql ) ;
            var len = vals.length ;
            for( var i = 0 ; i < len ; i ++ ) {
                qdf.Parameters( "p_col_" + i + "" ).Value = vals[i] ;
            }
            var rs = null ;
            try {
                rs = qdf.Execute() ;
            } finally {
                if( !$util.isNull( rs ) ) {
                    try {
                        rs.close() ;
                    } catch( e ) {
                    }
                }
                if( !$util.isNull( qdf ) ) {
                    try {
                        qdf.Close() ;
                    } catch( e ) {
                    }
                }
            }
            return true ;
        } catch( e ) {
            this.rollback() ;
            throw e ;
        }
    },
    // 行アップデート.
    update : function( table,values,where,params ) {
        if( $util.isNull( this._db ) || !$util.useString( table ) ||
            $util.isNull( values ) || $util.valueof( values ) != "map" ) {
            return false ;
        }
        var sql = "UPDATE " + table + " SET " ;
        var cnt = 0 ;
        var vals = [] ;
        for( var k in values ) {
            if( cnt != 0 ) {
                sql += "," ;
            }
            sql += k + "=p_col_" + cnt ;
            vals[ vals.length ] = values[ k ] ;
            cnt ++ ;
        }
        var wList = [] ;
        if( $util.valueof( where ) == "string" &&
            !$util.isNull( params ) && $util.valueof( params ) == "array" ) {
            var len = params.length ;
            var p ;
            for( var i = 0 ; i < len ; i ++ ) {
                if( ( p = where.indexOf( "?" ) ) == -1 ) {
                    break ;
                }
                where = where.substring( 0,p ) + ( "where_col_"+i ) + where.substring( p+1 ) ;
                wList[ i ] = params[ i ] ;
            }
            where = $util.trim( where ) ;
            if( $util.startsWith( where.toLowerCase(),"where " ) ) {
                where = where.substring( 6 ) ;
            }
            sql += " WHERE " + where ;
        }
        else {
            if( !$util.isNull( where ) && $util.valueof( where ) == "map" ) {
                sql += " WHERE " ;
                var cnt = 0 ;
                for( var k in where ) {
                    if( cnt != 0 ) {
                        sql += " AND " ;
                    }
                    sql += k + "=where_col_" + cnt ;
                    wList[wList.length] = where[k] ;
                    cnt ++ ;
                }
            }
        }
        sql += ";" ;
        this.transaction() ;
        try {
            var qdf = this._db.CreateQueryDef( "",sql ) ;
            var len = vals.length ;
            for( var i = 0 ; i < len ; i ++ ) {
                qdf.Parameters( "p_col_" + i ).Value = vals[i] ;
            }
            var len = wList.length ;
            for( var i = 0 ; i < len ; i ++ ) {
                qdf.Parameters( "where_col_" + i ).Value = wList[i] ;
            }
            var rs = null ;
            try {
                rs = qdf.Execute() ;
            } finally {
                if( !$util.isNull( rs ) ) {
                    try {
                        rs.close() ;
                    } catch( e ) {
                    }
                }
                if( !$util.isNull( qdf ) ) {
                    try {
                        qdf.Close() ;
                    } catch( e ) {
                    }
                }
            }
            return true ;
        } catch( e ) {
            this.rollback() ;
            throw e ;
        }
    },
    // 行追加or既に存在する場合は行更新を行う処理.
    insertUpdate : function( table,values,where ) {
        if( $util.isNull( this._db ) || !$util.useString( table ) ||
            $util.isNull( values ) || $util.valueof( values ) != "map" ) {
            return false ;
        }
        if( $util.isNull( where ) ) {
            var indexs = this._$tableIndex( table ) ;
            if( $util.isNull( indexs ) || indexs.length <= 0 ) {
                return false ;
            }
            where = indexs ;
        }
        if( !$util.isNull( values ) ) {
            if( $util.valueof( values ) == "array" ) {
                var t = {} ;
                var len = values.length ;
                for( var i = 0 ; i < len ; i ++ ) {
                    t[where[ i ]] = values[ where[ i ] ] ;
                }
                where = t ;
            }
            else if( $util.valueof( values ) != "map" ) {
                return false ;
            }
        }
        else {
            return false ;
        }
        if( this.count( table,where ) ) {
            return this.update( table,values,where )
        }
        return this.insert( table,values ) ;
    },
    // 行削除.
    remove : function( table,where,params ) {
        if( $util.isNull( this._db ) || !$util.useString( table ) ) {
            return false ;
        }
        var sql = "DELETE FROM " + table ;
        var wList = [] ;
        if( $util.valueof( where ) == "string" &&
            !$util.isNull( params ) && $util.valueof( params ) == "array" ) {
            var len = params.length ;
            var p ;
            for( var i = 0 ; i < len ; i ++ ) {
                if( ( p = where.indexOf( "?" ) ) == -1 ) {
                    break ;
                }
                where = where.substring( 0,p ) + ( "where_col_"+i ) + where.substring( p+1 ) ;
                wList[ i ] = params[ i ] ;
            }
            where = $util.trim( where ) ;
            if( $util.startsWith( where.toLowerCase(),"where " ) ) {
                where = where.substring( 6 ) ;
            }
            sql += " WHERE " + where ;
        }
        else {
            if( !$util.isNull( where ) && $util.valueof( where ) == "map" ) {
                sql += " WHERE " ;
                var cnt = 0 ;
                for( var k in where ) {
                    if( cnt != 0 ) {
                        sql += " AND " ;
                    }
                    sql += k + "=where_col_" + cnt ;
                    wList[wList.length] = where[k] ;
                    cnt ++ ;
                }
            }
        }
        sql += ";" ;
        this.transaction() ;
        try {
            var qdf = this._db.CreateQueryDef( "",sql ) ;
            var len = wList.length ;
            for( var i = 0 ; i < len ; i ++ ) {
                qdf.Parameters( "where_col_" + i ).Value = wList[i] ;
            }
            var rs = null ;
            try {
                rs = qdf.Execute() ;
            } finally {
                if( !$util.isNull( rs ) ) {
                    try {
                        rs.close() ;
                    } catch( e ) {
                    }
                }
                if( !$util.isNull( qdf ) ) {
                    try {
                        qdf.Close() ;
                    } catch( e ) {
                    }
                }
            }
            return true ;
        } catch( e ) {
            this.rollback() ;
            throw e ;
        }
    },
    // 行取得.
    select : function( table,sort,where,params,offset,length ) {
        if( $util.isNull( this._db ) || !$util.useString( table ) ) {
            return null ;
        }
        var sql = "SELECT * FROM " + table ;
        var wList = [] ;
        if( $util.valueof( where ) == "string" &&
            !$util.isNull( params ) && $util.valueof( params ) == "array" ) {
            var len = params.length ;
            var p ;
            for( var i = 0 ; i < len ; i ++ ) {
                if( ( p = where.indexOf( "?" ) ) == -1 ) {
                    break ;
                }
                where = where.substring( 0,p ) + ( "where_col_"+i ) + where.substring( p+1 ) ;
                wList[ i ] = params[ i ] ;
            }
            where = $util.trim( where ) ;
            if( $util.startsWith( where.toLowerCase(),"where " ) ) {
                where = where.substring( 6 ) ;
            }
            sql += " WHERE " + where ;
        }
        else {
            if( !$util.isNull( where ) && $util.valueof( where ) == "map" ) {
                sql += " WHERE " ;
                var cnt = 0 ;
                for( var k in where ) {
                    if( cnt != 0 ) {
                        sql += " AND " ;
                    }
                    sql += k + "=where_col_" + cnt ;
                    wList[wList.length] = where[k] ;
                    cnt ++ ;
                }
            }
        }
        if( $util.useString( sort ) ) {
            sql += " ORDER BY " + sort ;
        }
        sql += " ;" ;
        var qdf = this._db.CreateQueryDef( "",sql ) ;
        var len = wList.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            qdf.Parameters( "where_col_" + i ).Value = wList[i] ;
        }
        var rs = qdf.OpenRecordSet() ;
        if( !rs.EOF ) {
            try {
                rs.MoveLast() ;
                rs.MoveFirst() ;
                var ret = [] ;
                var map ;
                var flen = rs.Fields.Count ;
                var len = rs.RecordCount ;
                if( $util.isNumeric( offset ) && $util.isNumeric( length ) ) {
                    rs.Move( offset ) ;
                    len = length ;
                }
                for( var i = 0 ; i < len ; i ++ ) {
                    if( rs.EOF ) {
                        break ;
                    }
                    map = {} ;
                    for( var j = 0 ; j < flen ; j ++ ) {
                        map[ rs.Fields(j).Name ] = rs.Fields(j).Value ;
                    }
                    ret[ ret.length ] = map ;
                    rs.MoveNext() ;
                }
                rs.close() ;
                rs = null ;
                return ret ;
            } finally {
                if( !$util.isNull( rs ) ) {
                    try {
                        rs.close() ;
                    } catch( e ) {
                    }
                }
                if( !$util.isNull( qdf ) ) {
                    try {
                        qdf.Close() ;
                    } catch( e ) {
                    }
                }
            }
        }
        return [] ;
    },
    // 行数取得.
    count : function( table,where,params ) {
        if( $util.isNull( this._db ) || !$util.useString( table ) ) {
            return -1 ;
        }
        var sql = "SELECT COUNT(*) FROM " + table ;
        var wList = [] ;
        if( $util.valueof( where ) == "string" &&
            !$util.isNull( params ) && $util.valueof( params ) == "array" ) {
            var len = params.length ;
            var p ;
            for( var i = 0 ; i < len ; i ++ ) {
                if( ( p = where.indexOf( "?" ) ) == -1 ) {
                    break ;
                }
                where = where.substring( 0,p ) + ( "where_col_"+i ) + where.substring( p+1 ) ;
                wList[ i ] = params[ i ] ;
            }
            where = $util.trim( where ) ;
            if( $util.startsWith( where.toLowerCase(),"where " ) ) {
                where = where.substring( 6 ) ;
            }
            sql += " WHERE " + where ;
        }
        else {
            if( !$util.isNull( where ) && $util.valueof( where ) == "map" ) {
                sql += " WHERE " ;
                var cnt = 0 ;
                for( var k in where ) {
                    if( cnt != 0 ) {
                        sql += " AND " ;
                    }
                    sql += k + "=where_col_" + cnt ;
                    wList[wList.length] = where[k] ;
                    cnt ++ ;
                }
            }
        }
        sql += ";" ;
        var qdf = this._db.CreateQueryDef( "",sql ) ;
        var len = wList.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            qdf.Parameters( "where_col_" + i ).Value = wList[i] ;
        }
        var rs = qdf.OpenRecordSet() ;
        if( !rs.EOF ) {
            try {
                rs.MoveLast() ;
                rs.MoveFirst() ;
                var ret = rs.Fields(0).Value ;
                rs.close() ;
                rs = null ;
                return ret ;
            } finally {
                if( !$util.isNull( rs ) ) {
                    try {
                        rs.close() ;
                    } catch( e ) {
                    }
                }
                if( !$util.isNull( qdf ) ) {
                    try {
                        qdf.Close() ;
                    } catch( e ) {
                    }
                }
            }
        }
        return -1 ;
    },
    // クエリ更新実行.
    execUpdate : function( sql,params ) {
        if( $util.isNull( this._db ) ||
            $util.valueof( sql ) != "string" ||
            !$util.useString( sql ) ) {
            return false ;
        }
        var wList = [] ;
        if( !$util.isNull( params ) && $util.valueof( params ) == "array" ) {
            var len = params.length ;
            var p ;
            for( var i = 0 ; i < len ; i ++ ) {
                if( ( p = sql.indexOf( "?" ) ) == -1 ) {
                    break ;
                }
                sql = sql.substring( 0,p ) + ( "params_col_"+i ) + sql.substring( p+1 ) ;
                wList[ i ] = params[ i ] ;
            }
        }
        this.transaction() ;
        var qdf = this._db.CreateQueryDef( "",sql ) ;
        var len = wList.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            qdf.Parameters( "params_col_" + i ).Value = wList[i] ;
        }
        var rs = null ;
        try {
            rs = qdf.Execute() ;
        } finally {
            if( !$util.isNull( rs ) ) {
                try {
                    rs.close() ;
                } catch( e ) {
                }
            }
            if( !$util.isNull( qdf ) ) {
                try {
                    qdf.Close() ;
                } catch( e ) {
                }
            }
        }
        return true ;
    },
    // クエリ実行.
    execution : function( sql,params,offset,length ) {
        if( $util.isNull( this._db ) ||
            $util.valueof( sql ) != "string" ||
            !$util.useString( sql ) ) {
            return null ;
        }
        var wList = [] ;
        if( !$util.isNull( params ) && $util.valueof( params ) == "array" ) {
            var len = params.length ;
            var p ;
            for( var i = 0 ; i < len ; i ++ ) {
                if( ( p = sql.indexOf( "?" ) ) == -1 ) {
                    break ;
                }
                sql = sql.substring( 0,p ) + ( "params_col_"+i ) + sql.substring( p+1 ) ;
                wList[ i ] = params[ i ] ;
            }
        }
        var qdf = this._db.CreateQueryDef( "",sql ) ;
        var len = wList.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            qdf.Parameters( "params_col_"+i ).Value = wList[i] ;
        }
        var rs = qdf.OpenRecordSet() ;
        if( !rs.EOF ) {
            try {
                rs.MoveLast() ;
                rs.MoveFirst() ;
                var ret = [] ;
                var map ;
                var flen = rs.Fields.Count ;
                var len = rs.RecordCount ;
                if( $util.isNumeric( offset ) && $util.isNumeric( length ) ) {
                    rs.Move( offset ) ;
                    len = length ;
                }
                for( var i = 0 ; i < len ; i ++ ) {
                    if( rs.EOF ) {
                        break ;
                    }
                    map = {} ;
                    for( var j = 0 ; j < flen ; j ++ ) {
                        map[ rs.Fields(j).Name ] = rs.Fields(j).Value ;
                    }
                    ret[ ret.length ] = map ;
                    rs.MoveNext() ;
                }
                rs.close() ;
                rs = null ;
                return ret ;
            } finally {
                if( !$util.isNull( rs ) ) {
                    try {
                        rs.close() ;
                    } catch( e ) {
                    }
                }
                if( !$util.isNull( qdf ) ) {
                    try {
                        qdf.Close() ;
                    } catch( e ) {
                    }
                }
            }
        }
        return null ;
    },
    // 指定テーブルが存在するかチェック.
    isTable : function( table ) {
        return this._$tableObject( table ) != null ;
    },
    // テーブル名一覧を取得.
    getTableNames : function() {
        if( $util.isNull( this._db ) ) {
            return null ;
        }
        var ret = [] ;
        var t = this._db.TableDefs ;
        var cnt = 0 ;
        while( true ) {
            try {
                var n = t(cnt).Name.toLowerCase() ;
                ret[ret.length] = n ;
            } catch( e ) {
                break ;
            }
            cnt ++ ;
        }
        return ret ;
    },
    // ファイル名を取得.
    fileName : function() {
        return this._name ;
    },
    // オープン中かチェック.
    isOpen : function() {
        return !$util.isNull( this._db ) ;
    }
}

