/*
 * Decompiled with CFR 0.152.
 */
package org.yanroncha.jscope.core.filter.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.yanroncha.jscope.core.filter.xml.Node;

public class Paragraph
extends Node {
    private static final String PARAGRAPOH_TYPE_KEY = "type";
    private static Node.NodeFormInfo nfInfo = null;
    private String name;
    private String type;
    private HashMap<String, ArrayList<Paragraph>> subNodes;

    public static void init() {
        nfInfo = new Node.NodeFormInfo("paragraph");
        nfInfo.regKeyword("block");
        nfInfo.regKeyword("block_list");
    }

    public Paragraph(Attributes attributes) {
        super(attributes);
        this.setup(null, attributes.getValue(PARAGRAPOH_TYPE_KEY));
    }

    public Paragraph(String string, Attributes attributes) {
        super(attributes);
        this.setup(string, attributes.getValue(PARAGRAPOH_TYPE_KEY));
    }

    private void setup(String string, String string2) {
        if (nfInfo == null) {
            Paragraph.init();
        }
        this.name = string;
        this.type = string2;
        this.subNodes = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void stripName() {
        this.name = null;
    }

    @Override
    public Node setSubNode(String string, Attributes attributes) throws Exception {
        if (nfInfo.isKeyword(attributes.getValue(PARAGRAPOH_TYPE_KEY))) {
            Paragraph paragraph = new Paragraph(string, attributes);
            ArrayList<Paragraph> arrayList = this.subNodes.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.subNodes.put(string, arrayList);
            }
            arrayList.add(paragraph);
            return paragraph;
        }
        return null;
    }

    @Override
    public void writeData(PrintWriter printWriter, int n) throws Exception {
        String string = xmlFilter.pushIndent();
        if (this.name != null) {
            printWriter.printf("%s%s: {\n", string, this.name);
        } else {
            printWriter.printf("%s{\n", string);
        }
        string = xmlFilter.pushIndent();
        this.writeValues(printWriter, this.subNodes.size());
        int n2 = this.subNodes.size();
        for (String string2 : this.subNodes.keySet()) {
            --n2;
            ArrayList<Paragraph> arrayList = this.subNodes.get(string2);
            Paragraph paragraph = arrayList.get(0);
            if ("block_list".equals(paragraph.getType())) {
                printWriter.printf("%s%s: [\n", string, string2);
                int n3 = arrayList.size();
                for (int i = 0; i < n3; ++i) {
                    paragraph = arrayList.get(i);
                    paragraph.stripName();
                    paragraph.writeData(printWriter, n3 - i - 1);
                }
                if (n2 > 0) {
                    printWriter.printf("%s],\n", string);
                    continue;
                }
                printWriter.printf("%s]\n", string);
                continue;
            }
            xmlFilter.popIndent();
            paragraph.writeData(printWriter, n2);
            xmlFilter.pushIndent();
        }
        string = xmlFilter.popIndent();
        printWriter.printf("%s}", string);
        if (n > 0) {
            printWriter.print(",\n");
        } else {
            printWriter.print("\n");
        }
        xmlFilter.popIndent();
    }
}

