/*
 * Decompiled with CFR 0.152.
 */
package andyr.compressor;

import andyr.compressor.CssCompressor;
import jargs.gnu.CmdLineParser;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class Compressor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option typeOpt = parser.addStringOption("type");
        CmdLineParser.Option verboseOpt = parser.addBooleanOption('v', "verbose");
        CmdLineParser.Option linebreakOpt = parser.addStringOption("line-break");
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option charsetOpt = parser.addStringOption("charset");
        CmdLineParser.Option outputFilenameOpt = parser.addStringOption('o', "output");
        Reader in = null;
        Writer out = null;
        try {
            parser.parse(args);
            Boolean help = (Boolean)parser.getOptionValue(helpOpt);
            if (help != null && help.booleanValue()) {
                Compressor.usage();
                System.exit(0);
            }
            boolean verbose = parser.getOptionValue(verboseOpt) != null;
            String charset = (String)parser.getOptionValue(charsetOpt);
            if (charset == null || !Charset.isSupported(charset)) {
                charset = System.getProperty("file.encoding");
                if (charset == null) {
                    charset = "UTF-8";
                }
                if (verbose) {
                    System.err.println("\n[INFO] Using charset " + charset);
                }
            }
            String[] fileArgs = parser.getRemainingArgs();
            String type = (String)parser.getOptionValue(typeOpt);
            if (fileArgs.length == 0) {
                if (type == null || !type.equalsIgnoreCase("js") && !type.equalsIgnoreCase("css")) {
                    Compressor.usage();
                    System.exit(1);
                }
                in = new InputStreamReader(System.in, charset);
            } else {
                int idx;
                if (type != null && !type.equalsIgnoreCase("js") && !type.equalsIgnoreCase("css")) {
                    Compressor.usage();
                    System.exit(1);
                }
                String inputFilename = fileArgs[0];
                if (type == null && (idx = inputFilename.lastIndexOf(46)) >= 0 && idx < inputFilename.length() - 1) {
                    type = inputFilename.substring(idx + 1);
                }
                if (type == null || !type.equalsIgnoreCase("js") && !type.equalsIgnoreCase("css")) {
                    Compressor.usage();
                    System.exit(1);
                }
                in = new InputStreamReader((InputStream)new FileInputStream(inputFilename), charset);
            }
            int linebreakpos = -1;
            String linebreakstr = (String)parser.getOptionValue(linebreakOpt);
            if (linebreakstr != null) {
                try {
                    linebreakpos = Integer.parseInt(linebreakstr, 10);
                }
                catch (NumberFormatException e) {
                    Compressor.usage();
                    System.exit(1);
                }
            }
            String outputFilename = (String)parser.getOptionValue(outputFilenameOpt);
            if (type.equalsIgnoreCase("css")) {
                CssCompressor compressor = new CssCompressor(in);
                in.close();
                in = null;
                out = outputFilename == null ? new OutputStreamWriter((OutputStream)System.out, charset) : new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilename), charset);
                compressor.compress(out, linebreakpos);
            }
        }
        catch (CmdLineParser.OptionException e) {
            Compressor.usage();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void usage() {
        System.out.println("\nUsage: java -jar CssCompressor.jar [options] [input file]\n\nGlobal Options\n  -h, --help                Displays this information\n  --charset <charset>       Read the input file using <charset>\n  --line-break <column>     Insert a line break after the specified column number\n  -v, --verbose             Display informational messages and warnings\n  -o <file>                 Place the output into <file>. Defaults to stdout.\n\nIf no input file is specified, it defaults to stdin.");
    }
}

