<?php
/*******************************************************************************
 *	JAPRO Template Engine
 *     Ver. 0.9
 *
 *	ex.
 *
 *	$template = new jte() ;
 *	$template->set_value( 'date', date( 'Y/m/d' ) ) ;
 *	$template->exexute( 'template/sample.html' ) ;
 *
 *	set_condition( str $name, bool $flag )
 *	set_value( str $name, str $value )
 *	set_record( str $name, array $record )
 *
 *		$record = array(
 *			array( 'condition' => $condition, 'value' => $value ),
 *			array( 'condition' => $condition, 'value' => $value )
 *		) ;
 *
 *	html
 *	<li jte="record: news">
 *		<a href="" jte="@href: href; text: title">新着情報</a>
 *	</li>
 *
 *******************************************************************************/

if ( preg_match( '/^4\./', phpversion() ) ) {
	require( dirname( __FILE__ ) . '/jte_dom.php' ) ;
} else {
	if ( class_exists( 'DOMDocument' ) ) {
		class jte_DOMDocument extends DOMDocument {}
	} else {
		require( dirname( __FILE__ ) . '/jte_dom.php' ) ;
	}
}


class jte {
	var $templateAttribute = 'jte' ;
	
	var $commands = array(
		'fake',
		'record',
		'condition',
		'text'
	) ;
	
	
	var $encoding = 'UTF-8' ;
	var $doctype = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">' ;
	var $xhtml ;
	var $dom ;
	
	var $set ;
	
	var $emptyTag = array(
		'meta',
		'base',
		'link',
		'basefont',
		'spacer',
		'br',
		'wbr',
		'hr',
		'img',
		'area',
		'param',
		'bgsound',
		'input'
	) ;
	
	var $blankAttribute = array(
		'checked',
		'compact',
		'declare',
		'defer',
		'disabled',
		'ismap',
		'multiple',
		'nohref',
		'noresize',
		'noshade',
		'nowrap',
		'selected'
	) ;
	
	var $urlAttribute = array(
		'href',
		'src',
		'background',
		'cite',
		'action'
	) ;
	
	var $fakeCommands = array(
		'fake',
		'remove',
		'dummy'
	) ;
	
	
	//==================================================================
	// constructor
	
	function jte() {
		$this->__construct() ;
	}
	
	
	function __construct() {
		$this->set = array(
			'condition' => array(),
			'value' => array(),
			'record' => array()
		) ;
	}
	
	
	//==================================================================
	// set all
	
	function set( $hash ) {
		if ( isset( $hash[ 'function' ] ) ) {
			$this->set_functions( $hash[ 'function' ] ) ;
		}
		
		if ( isset( $hash[ 'condition' ] ) ) {
			$this->set_conditions( $hash[ 'condition' ] ) ;
		}
		
		if ( isset( $hash[ 'value' ] ) ) {
			$this->set_values( $hash[ 'value' ] ) ;
		}
		
		if ( isset( $hash[ 'record' ] ) ) {
			$this->set_records( $hash[ 'record' ] ) ;
		}
	}
	
	
	//==================================================================
	// set with hash
	
	function set_functions( $hash ) {
		foreach ( $hash as $name => $function ) {
			$this->set_function( $name, $function ) ;
		}
	}
	
	
	function set_conditions( $hash ) {
		foreach ( $hash as $name => $flag ) {
			$this->set_condition( $name, $flag ) ;
		}
	}
	
	
	function set_values( $hash ) {
		foreach ( $hash as $name => $value ) {
			$this->set_value( $name, $value ) ;
		}
	}
	
	
	function set_records( $hash ) {
		foreach ( $hash as $name => $record ) {
			$this->set_record( $name, $record ) ;
		}
	}
	
	
	//==================================================================
	// set
	
	function set_function( $name, $function ) {
		$this->set[ 'function' ][ $name ] = $function ;
	}
	
	
	function set_condition( $name, $flag ) {
		$this->set[ 'condition' ][ $name ] = ( $flag ) ? true : false ;
	}
	
	
	function set_value( $name, $value ) {
		$this->set[ 'value' ][ $name ] = $value ;
	}
	
	
	function set_record( $name, $record ) {
		$this->set[ 'record' ][ $name ] = $record ;
	}
	
	
	//==================================================================
	// load template
	
	function load( $path ) {
		$html = @file_get_contents( $path ) ;
		
		if ( $html === false ) return false ;
		
		$html = $this->_delete_bom( $html ) ;
		
		$this->dom = new jte_DOMDocument( '1.0' ) ;
		$this->dom->encoding = $this->encoding ;
		$this->dom->validate = true ;
		
		$html = trim( $html ) ;
		
		if ( preg_match( '/^(<\?xml\s(.|\n)*?\?>)\r?\n((.|\n)*)$/', $html, $part ) ) {
			$html = $part[ 2 ] ;
		}
		
		if ( preg_match( '/^(<\!DOCTYPE\s(.|\n)*?>)\r?\n((.|\n)*)$/i', $html, $part ) ) {
			$this->doctype = $part[ 1 ] ;
			$html = $part[ 3 ] ;
		}
		
		if ( ! preg_match( '/^<html( (.|\n)*?)?>/', $html ) ) {
			echo "No html !! " . htmlspecialchars( mb_substr( $html, 0, 20 ) ) . "...<br />\n" ;
			return false ;
		}
		
		$this->_parse( $this->dom, $html ) ;
		
		return true ;
	}
	
	
	//==================================================================
	// replace template by set
	
	function replace() {
		$this->set[ 'root' ] = &$this->set ;
		
		$this->set[ 'parent' ] = array(
			'function' => array(),
			'condition' => array(),
			'value' => array(),
			'record' => array()
		) ;
		
		$this->_replace( $this->set, $this->dom->documentElement ) ;
	}
	
	
	//==================================================================
	// output html
	
	function save() {
		$this->xhtml = preg_match( '/\sXHTML\s/', $this->doctype ) ;
		
		$html = "{$this->doctype}\n" ;
		
		$this->_tree( $html, $this->dom->documentElement ) ;
		
		return $html ;
	}
	
	
	//==================================================================
	// output html from template and set
	
	function execute( $path, $set ) {
		if ( $this->load( $path ) === false ) return false ;
		$this->set( $set ) ;
		$this->replace() ;
		echo $this->save() ;
	}
	
	
	//==================================================================
	// part of html
	
	function part_load( $html ) {
		$html = $this->_delete_bom( $html ) ;
		
		$this->dom = new jte_DOMDocument( '1.0' ) ;
		$this->dom->encoding = $this->encoding ;
		
		$part = "<part>" . trim( $html ) . "</part>" ;
		
		$this->_parse( $this->dom, $part ) ;
		
		return true ;
	}
	
	
	function part_save( $xhtml = true ) {
		//return '' ;
		$this->xhtml = $xhtml ;
		
		$html = "" ;
		
		for ( $n = 0 ; $n < $this->dom->documentElement->childNodes->length ; $n++ ) {
			$this->_tree( $html, $this->dom->documentElement->childNodes->item( $n ) ) ;
		}
		
		return $html ;
	}
	
	
	//==================================================================
	// commands -- _replace_element
	
	
	// fake/remove/dummy
	
	function command_fake( &$element, &$set, $command, $name ) {
		if ( ! is_null( $element->previousSibling ) ) {
			if ( $element->previousSibling->nodeType == XML_TEXT_NODE ) {
				if ( trim( $element->previousSibling->nodeValue ) == '' ) {
					$element->parentNode->removeChild( $element->previousSibling ) ;
				}
			}
		}
		
		$element->parentNode->removeChild( $element ) ;
		
		return true ;
	}
	
	
	// function: {functionName}
	
	function command_function( &$element, &$set, $command, $name ) {
		list( $local, $name ) = $this->_replace_get_local( $set, $name ) ;
		if ( ! isset( $local[ 'function' ][ $name ] ) ) return false ;
		if ( ! is_callable( $local[ 'function' ][ $name ] ) ) return false ;
		
		return call_user_func_array( $local[ 'function' ][ $name ], array( &$this, &$element, &$set, $command, $name ) ) ;
	}
	
	
	// condition: {conditionName}
	
	function command_condition( &$element, &$set, $command, $name ) {
		list( $local, $name ) = $this->_replace_get_local( $set, $name ) ;
		
		if ( $this->command_condition_check( $local, $name ) ) return false ;
		
		$this->_replace_remove( $element ) ;
		
		return true ;
	}
	
	function command_condition_check( &$local, $name ) {
		if ( isset( $local[ 'condition' ][ $name ] ) ) {
			return ( $local[ 'condition' ][ $name ] == true )  ;
		}
		
		if ( isset( $local[ 'record' ][ $name ] ) ) {
			if ( is_array( $local[ 'record' ][ $name ] ) ) {
				return ( count( $local[ 'record' ][ $name ] ) > 0 )  ;
			}
		}
		
		if ( isset( $local[ 'value' ][ $name ] ) ) {
			return ( "{$local[ 'value' ][ $name ]}" != '' )  ;
		}
		
		return true ;
	}
	
	
	// inner/outer: {valueName}/url({urlString})
	
	function command_html( &$element, &$set, $command, $name ) {
		if ( preg_match( '/^url\(([^)]*)\)$/', $name, $match ) ) {
			$parts = array() ;
			$urls = preg_split( '/[ ,]\s*/', $match[ 1 ] ) ;
			
			for ( $n = 0 ; $n < count( $urls ) ; $n++ ) {
				$url = trim( $urls[ $n ] ) ;
				
				if ( $url == '' ) continue ;
				
				$part = @file_get_contents( trim( $match[ 1 ] ) ) ;
				if ( $part === false ) return false ;
				
				$parts[] = rtrim( $this->_delete_bom( $part ) ) ;
			}
			
			$html = implode( "\n", $parts ) ;
		} else {
			list( $local, $name ) = $this->_replace_get_local( $set, $name ) ;
			if ( ! isset( $local[ 'value' ][ $name ] ) ) return false ;
			$html = $local[ 'value' ][ $name ] ;
		}
		
		if ( $command == 'outer' ) {
			$this->outerHTML( $element, $html ) ;
			return true ;
		}
		
		$this->innerHTML( $element, $html ) ;
		
		return false ;
	}
	
	
	// text: {valueName}
		
	function command_text( &$element, &$set, $command, $name ) {
		list( $local, $name ) = $this->_replace_get_local( $set, $name ) ;
		if ( ! isset( $local[ 'value' ][ $name ] ) ) return ;
		
		while ( $element->childNodes->length > 0 ) {
			$element->removeChild( $element->childNodes->item( 0 ) ) ;
		}
		
		$element->appendChild( $this->dom->createTextNode( htmlspecialchars( $local[ 'value' ][ $name ] ) ) ) ;
	}
	
	
	// {attributeName}: {valueName}
	
	function command_attribute( &$element, &$set, $command, $name ) {
		list( $local, $name ) = $this->_replace_get_local( $set, $name ) ;
		if ( ! isset( $local[ 'value' ][ $name ] ) ) return ;
		
		if ( $local[ 'value' ][ $name ] == '' ) {
			if ( in_array( $command, $this->blankAttribute ) ) {
				if ( $element->hasAttribute( $command ) ) {
					$element->removeAttribute( $command ) ;
				}
				
				return ;
			}
		}
		
		$element->setAttribute( $command, $local[ 'value' ][ $name ] ) ;
	}
	
	
	//==================================================================
	// common method
	
	
	function innerHTML( &$element, $html ) {
		if ( $element->nodeType != XML_ELEMENT_NODE ) return false ;
		
		$html = rtrim( $this->_delete_bom( $html ) ) ;
		
		// 改行または次のエレメントまでを保持
		
		$first = '' ;
		
		while ( $element->childNodes->length > 0 ) {
			if ( $element->firstChild->nodeType == XML_TEXT_NODE ) {
				if ( preg_match( '/^(\s*\n)((.|\n)*)$/', $element->firstChild->nodeValue, $match ) ) {
					$first = "{$first}{$match[ 1 ]}" ;
					$element->firstChild->nodeValue = "\r\n{$match[ 2 ]}" ;
				}
				
				break ;
			}
			
			if ( $element->firstChild->nodeType != XML_COMMENT_NODE ) break ;
			
			$first = "{$first}<!--{$element->firstChild->nodeValue}-->" ;
			
			$element->removeChild( $element->firstChild ) ;
		}
		
		// インデントを保持
		
		$last = '' ;
		
		while ( $element->childNodes->length > 0 ) {
			if ( $element->lastChild->nodeType == XML_TEXT_NODE ) {
				if ( preg_match( '/^((.|\n)*)(\r?\n\s*)$/', $element->lastChild->nodeValue, $match ) ) {
					$last = "{$match[ 3 ]}{$last}" ;
					$element->lastChild->nodeValue = $match[ 1 ] ;
				}
				
				break ;
			}
			
			if ( $element->lastChild->nodeType != XML_COMMENT_NODE ) break ;
			
			$last = "<!--{$element->lastChild->nodeValue}-->{$last}" ;
			
			$element->removeChild( $element->lastChild ) ;
		}
		
		// 空にする
		
		$childNodes =& $element->childNodes ;
		
		while ( $childNodes->length > 0 ) {
			$element->removeChild( $element->firstChild ) ;
		}
		
		$html = "{$first}{$html}{$last}" ;
		
		$this->_parse( $element, $html ) ;
		$this->_replace_childs( $this->set, $element ) ;
		
		return true ;
	}
	
	
	function outerHTML( &$element, $html ) {
		$html = rtrim( $this->_delete_bom( $html ) ) ;
		
		$div = $this->dom->createElement( 'div' ) ;
		
		$this->_parse( $div, $html ) ;
		$this->_replace_childs( $this->set, $div ) ;
		
		while ( $div->childNodes->length > 0 ) {
			$element->parentNode->insertBefore( $div->removeChild( $div->firstChild ), $element ) ;
		}
		
		$element->parentNode->removeChild( $element ) ;	
		
		return true ;
	}
	
	
	//==================================================================
	// Internal method
	
	function _delete_bom( $text ) {
		return preg_replace( '/^\xef\xbb\xbf/', '', $text ) ;
	}
	
	
	//==================================================================
	// _parse
	
	function _parse( &$parent, &$html, $open = '' ) {
		while ( $html != '' ) {
			if ( preg_match( '/^<((.|\n)*)$/', $html, $match ) ) {
				$html = $match[ 1 ] ;
				
				if ( $html == '' ) {
					$parent->appendChild( $this->dom->createTextNode( '<' ) ) ;
					continue ;
				}
				
				if ( preg_match( '/^\!--((.|\n)*?)(-->((.|\n)*))$/', $html, $match ) ) {
					$html = $match[ 4 ] ;
					$parent->appendChild( $this->dom->createComment( $match[ 1 ] ) ) ;
					continue ;
				}
				
				if ( preg_match( '/^\!\[CDATA\[((.|\n)*?)(\]\]>((.|\n)*))$/', $html, $match ) ) {
					$html = $match[ 4 ] ;
					$parent->appendChild( $this->dom->createCDATASection( $match[ 1 ] ) ) ;
					continue ;
				}
				
				if ( preg_match( '/^\/(.*?)\s*(>((.|\n)*))$/', $html, $match ) ) {
					$tagName = $match[ 1 ] ;
					
					if ( ( $open == '' ) or ( $open != $tagName ) ){
						echo "Not opened or invalid &lt;{$open}&gt; - &lt;/{$tagName}&gt;<br />\n" ;
						break ;
					}
					
					$html = $match[ 3 ] ;
					break ;
				}
					
				$this->_parse_element( $parent, $html ) ;
			} else {
				preg_match( '/^([^<]+)((.|\n)*?)$/', $html, $match ) ;
				$html = $match[ 2 ] ;
				$parent->appendChild( $this->dom->createTextNode( $match[ 1 ] ) ) ;
			}
		}
	}
	
	
	function _parse_element( &$parent, &$html ) {
		preg_match( '/^("[^"]*"|\'[^\']*\'|(.|\n)*?)(>((.|\n)*))$/', $html, $match ) ;
		$html = $match[ 4 ] ;
		$tag = $match[ 1 ] ;
		
		preg_match( '/^(\S+)((.|\n)*?)( ?\/)?$/', $tag, $match ) ;
		$tagName = strtolower( $match[ 1 ] ) ;
		$attributes = trim( $match[ 2 ] ) ;
		$closed = isset( $match[ 4 ] ) ? $match[ 4 ] : '' ;
		
		$node = $this->dom->createElement( $tagName ) ;
		$this->_parse_attributes( $node, $attributes ) ;
		
		if ( $closed == '' ) {
			if ( ! in_array( $tagName, $this->emptyTag ) ) {
				if ( $tagName == 'script' ) {
					if ( preg_match( '/^((.|\n)*?)<\/script\s*>((.|\n)*)$/i', $html, $match ) ) {
						if ( $match[ 1 ] != '' ) {
							$node->appendChild( $this->dom->createTextNode( $match[ 1 ] ) ) ;
						}
						
						$html = $match[ 3 ] ;
					} else {
						if ( $html != '' ) {
							$node->appendChild( $this->dom->createTextNode( $html ) ) ;
						}
						
						$html = '' ;
					}
				} else {
					$this->_parse( $node, $html, $tagName ) ;
				}
			}
		}
		
		$parent->appendChild( $node ) ;
		
		return true ;
	}
	
	
	function _parse_attributes( &$node, &$attributes ) {
		while ( $attributes != '' ) {
			if ( preg_match( '/^(\S+?)\s*=\s*("[^"]*"|\'[^\']*\'|\S)([^$]*)$/', $attributes, $part ) ) {
				$attributes = trim( $part[ 3 ] ) ;
				
				$name = strtolower( $part[ 1 ] ) ;
				
				if ( preg_match( '/^"([^"]*)"$/', $part[ 2 ], $value ) ) {
					$node->setAttribute( $name, $value[ 1 ] ) ;
					continue ;
				}
				
				if ( preg_match( '/^\'([^\']*)\'$/', $part[ 2 ], $value ) ) {
					if ( in_array( $name, $this->urlAttribute ) ) {
						$node->setAttribute( $name, mb_ereg_replace( '"', '%22', $value[ 1 ] ) ) ;
					} else {
						$node->setAttribute( $name, mb_ereg_replace( '"', '&quot;', $value[ 1 ] ) ) ;
					}
					
					continue ;
				}
				
				$node->setAttribute( $part[ 1 ], $part[ 2 ] ) ;
				continue ;
			}
			
			preg_match( '/^(\S*)([^$]*)$/', $attributes, $part ) ;
			$attributes = trim( $part[ 2 ] ) ;
			
			if ( $part[ 1 ] != '' ) {
				$name = strtolower( $part[ 1 ] ) ;
				$node->setAttribute( $name, $name ) ;
			}
		}
	}
	
	
	//==================================================================
	// _replace
	
	function _replace( &$set, &$element ) {
		if ( $element->hasAttribute( $this->templateAttribute ) ) {
			$commands = $this->_replace_get_commands( $element->getAttribute( $this->templateAttribute ) ) ;
			$element->removeAttribute( $this->templateAttribute ) ;
			$this->_replace_element( $set, $element, $commands ) ;
		}
		
		$this->_replace_childs( $set, $element ) ;
	}
	
	
	function _replace_childs( &$set, &$element ) {
		$records = array() ;
		
		$childs = array() ;
		
		$childNodes =& $element->childNodes ;
		
		for ( $n = 0 ; $n < $childNodes->length ; $n++ ) {
			$child = $childNodes->item( $n ) ;
			if ( $child->nodeType == XML_ELEMENT_NODE ) {
				$childs[] =& $childNodes->item( $n ) ;
			}
		}
		
		for ( $n = 0 ; $n < count( $childs ) ; $n++ ) {
			if ( ! $childs[ $n ]->hasAttribute( $this->templateAttribute ) ) {
				$this->_replace_childs( $set, $childs[ $n ] ) ;
				continue ;
			}
			
			$commands = $this->_replace_get_commands( $childs[ $n ]->getAttribute( $this->templateAttribute ) ) ;
			
			for ( $c = 0 ; $c < count( $commands ) ; $c++ ) {
				$command = $commands[ $c ][ 'command' ] ;
				$name = $commands[ $c ][ 'name' ] ;
				
				// fake/remove/dummy
				
				if ( in_array( $command, $this->fakeCommands ) ) {
					$this->command_fake( $childs[ $n ], $set, $command, $name ) ;
					continue 2 ;
				}
				
				// record
				
				if ( $command == 'record' ) {
					if ( ! isset( $records[ $name ] ) ) $records[ $name ] = array() ;
					$records[ $name ][] =& $childs[ $n ] ;
					continue 2 ;
				}
			}
			
			$childs[ $n ]->removeAttribute( $this->templateAttribute ) ;
			$this->_replace_element( $set, $childs[ $n ], $commands ) ;
			$this->_replace_childs( $set, $childs[ $n ] ) ;
		}
		
		foreach ( $records as $name => $record ) {
			if ( ! isset( $set[ 'record' ][ $name ] ) ) {
				for ( $n = 0 ; $n < count( $record ) ; $n++ ) {
					$this->_replace_remove( $record[ $n ] ) ;
				}
				
				continue ;
			}
			
			// 不必要な行を削除
			
			for ( $n = count( $set[ 'record' ][ $name ] ) ; $n < count( $record ) ; $n++ ) {
				$this->_replace_remove( $record[ $n ] ) ;
			}
			
			// 必要な行を用意
			
			if ( count( $set[ 'record' ][ $name ] ) > count( $record ) ) {
				
				$last =& $records[ $name ][ count( $records[ $name ] ) - 1 ] ;
				
				$source = array() ;
				
				if ( ! is_null( $last->previousSibling ) ) {
					if ( $last->previousSibling->nodeType == XML_TEXT_NODE ) {
						if ( trim( $last->previousSibling->nodeValue ) == '' ) {
							$source[] = $last->previousSibling->cloneNode() ;
						}
					}
				}
				
				$source[] = $last->cloneNode( true ) ;
				
				$anchor = $this->dom->createElement( $last->tagName ) ;
				
				if ( is_null( $last->nextSibling ) ) {
					$last->parentNode->appendChild( $anchor ) ;
				} else {
					$last->parentNode->insertBefore( $anchor, $last->nextSibling ) ;
				}
				
				unset( $anchor ) ;
				$anchor =& $last->nextSibling ;
				
				for ( $n = count( $record ) ; $n < count( $set[ 'record' ][ $name ] ) ; $n++ ) {
					for ( $s = 0 ; $s < count( $source ) ; $s++ ) {
						$node = $source[ $s ]->cloneNode( true ) ;
						
						$last->parentNode->insertBefore( $node, $anchor ) ;
						
						$node = $anchor->previousSibling ;
						
						if ( $node->nodeType == XML_ELEMENT_NODE ) {
							$record[] =& $node ;
						}
						
						unset( $node ) ;
					}
				}
				
				$last->parentNode->removeChild( $anchor ) ;
			}
			
			for ( $n = 0 ; $n < count( $set[ 'record' ][ $name ] ) ; $n++ ) {
				$set[ 'record' ][ $name ][ $n ][ 'root' ] =& $this->set ;
				$set[ 'record' ][ $name ][ $n ][ 'parent' ] =& $set ;
				
				$child =& $record[ $n ] ;
				
				$this->_replace( $set[ 'record' ][ $name ][ $n ], $child ) ;
				
				unset( $child ) ;
			}
		}
	}
	
	
	function _replace_element( &$set, &$element, &$commands ) {
		for ( $c = 0 ; $c < count( $commands ) ; $c++ ) {
			$command = $commands[ $c ][ 'command' ] ;
			$name = $commands[ $c ][ 'name' ] ;
			
			$break = false ;
			
			switch ( $command ) {
				case 'record' :
					break ;
				
				case 'function' :
					$break = $this->command_function( $element, $set, $command, $name ) ;
					break ;
				
				case 'condition' :
					$break = $this->command_condition( $element, $set, $command, $name ) ;
					break ;
				
				case 'inner' :
					$this->command_html( $element, $set, $command, $name ) ;
					break ;
				
				case 'outer' :
					$break = $this->command_html( $element, $set, $command, $name ) ;
					break ;
					
				case 'text' :
					$this->command_text( $element, $set, $command, $name ) ;		// like inner
					break ;
				
				default :	// attribute
					if ( preg_match( '/^@(.+)$/', $command, $match ) ) {
						$this->command_attribute( $element, $set, $match[ 1 ], $name ) ;
					} else {
						$method = "command_{$command}" ;
						
						if ( method_exists( $this, $method ) ) {
							$break = call_user_func_array( array( $this, $method ), array( &$element, &$set, $command, $name ) ) ;
						}
					}
			}
			
			if ( $break ) break ;
		}
	}
	
	
	function _replace_get_commands( $attribute ) {
		$attribute = trim( $attribute ) ;
		
		$commands = array() ;
		
		while ( $attribute != '' ) {
			preg_match( '/^([^;]+)\s*(;\s*|$)([^$]*)$/', $attribute, $matches ) ;
			$attribute = trim( $matches[ 3 ] ) ;
			
			if ( preg_match( '/^([^:]*)\s*:\s*([^$]*)$/', $matches[ 1 ], $part ) ) {
				$command = trim( $part[ 1 ] ) ;
				$name = trim( $part[ 2 ] ) ;
			} else {
				$command = $matches[ 1 ] ;
				$name = '' ;
			}
			
			$commands[] = array(
				'command' => $command,
				'name' => $name
			) ;
		}
		
		return $commands ;
	}
	
	
	function _replace_get_local( &$set, $name ) {
		if ( preg_match( '/^([^^\.]+?)\.([^$]+)$/', $name, $match ) ) {
			switch ( strtolower( trim( $match[ 1 ] ) ) ) {
				case 'root' :
					return array( &$set[ 'root' ], trim( $match[ 2 ] ) ) ;
					break ;
				
				case 'parent' :
					return array( &$set[ 'parent' ], trim( $match[ 2 ] ) ) ;
					break ;
			}
		}
		
		return array( &$set, $name ) ;
	}
	
	
	function _replace_remove( &$element ) {
		while ( $element->previousSibling ) {
			if ( $element->previousSibling->nodeType != XML_COMMENT_NODE ) {
				if ( $element->previousSibling->nodeType != XML_TEXT_NODE ) break ;
				if ( trim( $element->previousSibling->nodeValue ) != '' ) break ;
			}
			
			$element->parentNode->removeChild( $element->previousSibling ) ;
		}
		
		$element->parentNode->removeChild( $element ) ;
	}
	
	
	function _get_attr( &$element ) {
		$attr = array() ;
		
		$attributes = $element->attributes ;
		
		for ( $n = 0 ; $n < $attributes->length ; $n++ ) {
			$attribute =& $attributes->item( $n ) ;
			$attr[] = "{$attribute->name}=\"{$attribute->value}\"" ;
		}
		
		return implode( " ", $attr ) ;
	}
	
	
	//==================================================================
	// _tree
	
	function _tree( &$html, &$node ) {
		$xhtml = preg_match( '/\sXHTML\s/', $this->doctype ) ;
		$emptyTagEnd = ( $xhtml ) ? ' />' : '>' ;
		
		if ( $node->nodeType == XML_ELEMENT_NODE ) {
			$tag = array( $node->tagName )   ;
			
			$attributes =& $node->attributes ;
			
			for ( $n = 0 ; $n < $attributes->length ; $n++ ) {
				$attribute =& $attributes->item( $n ) ;
				
				$name = $attribute->name ;
				$value = $attribute->value ;
				
				if ( $value == '' ) {
					if ( in_array( $name, $this->blankAttribute ) ) continue ;
				}
				
				if ( $this->xhtml ) {
					$tag[] = htmlspecialchars( $name ) . '="' . $value . '"' ;
				} else {
					if ( in_array( $name, $this->blankAttribute ) ) {
						$tag[] = htmlspecialchars( $name ) ;
					} else {
						$tag[] = htmlspecialchars( $name ) . '="' . $value . '"' ;
					}
				}
			}
			
			if ( in_array( $node->tagName, $this->emptyTag ) ) {
				$html .= "<" . implode( ' ', $tag ) . ( ( $this->xhtml ) ? ' />' : '>' ) ;
			} else {
				$html .= "<" . implode( ' ', $tag ) . ">" ;
				$this->_tree_childs( $html, $node ) ;
				$html .= "</" . $node->tagName . ">" ;
			}
			
			return ;
		}
		
		if ( $node->nodeType == XML_COMMENT_NODE ) {
			$html .= "<!--" . $node->nodeValue . "-->" ;
			return ;
		}
		
		if ( $node->nodeType == XML_CDATA_SECTION_NODE ) {
			$html .= "<![CDATA[" . $node->nodeValue . "]]>" ;
			return ;
		}
		
		$html .= $node->nodeValue ;
	}
	
	
	function _tree_childs( &$html, &$node ) {
		for ( $n = 0 ; $n < $node->childNodes->length ; $n++ ) {
			$this->_tree( $html, $node->childNodes->item( $n ) ) ;
		}
	}
}
?>