<?php
mb_language( 'uni' ) ;
mb_internal_encoding( 'UTF-8' ) ;
mb_regex_encoding( 'UTF-8' ) ;

require( 'lib/jte.php' ) ;


class page_sample {
	function page_sample() {
		$this->__construct() ;
	}
	
	
	function __construct() {
		session_start() ;
		
		// jte へのデータを準備
		
		$set = array(
			'function' => array(),
			'condition' => array(),
			'value' => array(),
			'record' => array()
		) ;
		
		// 実際はデータベースなどから設定します。
		
		$set[ 'function' ][ 'head' ] = array( $this, 'page_head' ) ;
		
		$set[ 'condition' ][ 'case_1' ] = true ;
		$set[ 'condition' ][ 'case_2' ] = false ;
		
		$set[ 'condition' ][ 'column_1' ] = true ;
		$set[ 'condition' ][ 'column_2' ] = false ;
		
		$set[ 'value' ][ 'text_inner' ] = 'innerで内容を書き換えました。<br />複数のエレメントを記述できます。' ;
		$set[ 'value' ][ 'text_outer' ] = 'outerでタグを書き換えました。<br />複数のエレメントを記述できます。<br />' ;

		$set[ 'value' ][ 'copyright_url' ] = 'http://www.japro.net' ;
		$set[ 'value' ][ 'copyright_name' ] = 'JAPRO(C)' ;

		$set[ 'record' ][ 'list' ] = array() ;
		
		$set[ 'record' ][ 'list' ][] = array(
			'value' => array(
				'url' => 'http://www.google.co.jp/',
				'name' => 'Google'
			)
		) ;
		
		$set[ 'record' ][ 'list' ][] = array(
			'value' => array(
				'url' => 'http://www.yahoo.co.jp/',
				'name' => 'Yahoo! Japan'
			)
		) ;
		
		// テンプレートにデータを適用して表示
		
		$jte = new jte() ;
		$jte->execute( 'sample.html', $set ) ;
	}
	
	
	// function の使用例
	
	function page_head( &$jte, &$element ) {
		$html = '' ;
		
		$html .= '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />' . "\n" ;
		$html .= '<title>' . htmlspecialchars( '>> JTE サンプル <<' ) . '</title>' . "\n" ;
		
		$jte->innerHTML( $element, $html ) ;
	}
}


$page = new page_sample() ;
?>