/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* define.h --- define some internal options (please do not modify) */

/* $Id: define.h,v 1.5 2002/09/11 22:02:33 ri Exp $ */

/************************************************************/
/********** DO NOT MODIFY MANUALLY DEFINES BELOW ************/
/************************************************************/

/* switch N-gram mode (julius) <-> grammar mode (julian) */
#ifdef USE_DFA
#undef  USE_NGRAM
#else
#define USE_NGRAM
#endif

/* delete incoherent option */
#ifdef USE_DFA
#ifdef UNIGRAM_FACTORING
#undef UNIGRAM_FACTORING
#endif
#else  /* USE_NGRAM */
#ifdef CATEGORY_TREE
#undef CATEGORY_TREE
#endif
#endif /* USE_DFA */

/* abbreviations */
#define VERMES if (verbose_flag) j_printerr

/* report memory usage on exit (Linux only) */
#undef REPORT_MEMORY_USAGE

#ifdef USE_NGRAM
/*** tree construction ***/
/* With 1-best approximation, Constructing a single tree from all words
   causes much error by factoring.  Listing each word flatly with no
   tree-organization will not cause this error, but the network becomes
   much larger and, especially, the inter-word LM handling becomes much more
   complex (O(n^2)).  The cost may be eased by LM caching, but it needs much
   memory. */
/* This is a trade-off of accuracy and cost */
#define SHORT_WORD_LEN 2
#ifdef LOWMEM
/* don't separate, construct a single tree from all words */
/* root nodes are about 50 in monophone, cache size will be 5MB on max */
#define NO_SEPARATE_SHORT_WORD
#else
#ifdef LOWMEM2
/* experimental: separate words frequently appears in corpus (1-gram) */
/* root nodes will be "-sepnum num" + 50, cache size will be 10MB or so */
#define NO_SEPARATE_SHORT_WORD
#define SEPARATE_BY_UNIGRAM
#define DEFAULT_SEPARATE_WNUM 150
#else
/* separate all short words (<= 2 phonemes) */
/* root nodes are about 1100 in 20k (proportional to vocabulary),
   cache size will be about 100MB on max */
#endif /* LOWMEM2 */
#endif /* LOWMEM */

/*#define HASH_CACHE_IW*/
/* "./configure --enable-lowmem" defines NO_SEPARATE_SHORT_WORD instead */

#endif /* USE_NGRAM */

#ifdef USE_NGRAM
/* default language model weight and insertion penalty for pass1 and pass2 */
/* these values come from the best parameters in IPA evaluation result */
#define DEFAULT_LM_WEIGHT_MONO_PASS1   5.0
#define DEFAULT_LM_PENALTY_MONO_PASS1 -1.0
#define DEFAULT_LM_WEIGHT_MONO_PASS2   6.0
#define DEFAULT_LM_PENALTY_MONO_PASS2  0.0
#ifdef PASS1_IWCD
#define DEFAULT_LM_WEIGHT_TRI_PASS1   8.0
#define DEFAULT_LM_PENALTY_TRI_PASS1 -2.0
#define DEFAULT_LM_WEIGHT_TRI_PASS2   8.0
#define DEFAULT_LM_PENALTY_TRI_PASS2 -2.0
#else
#define DEFAULT_LM_WEIGHT_TRI_PASS1   9.0
#define DEFAULT_LM_PENALTY_TRI_PASS1  8.0
#define DEFAULT_LM_WEIGHT_TRI_PASS2  11.0
#define DEFAULT_LM_PENALTY_TRI_PASS2 -2.0
#endif /* PASS1_IWCD */
#endif /* USE_NGRAM */

/* TEMPORARY definition for development */
#undef FIX_PENALTY

/* short-pause segmentation */
#ifdef SP_BREAK_CURRENT_FRAME
#undef SP_BREAK_EVAL		/* output messages for evaluation */
#undef SP_BREAK_DEBUG		/* output messages for debug */
#define SP_BREAK_RESUME_WORD_BEGIN /* resume word = maxword at beginning of sp area */
#define is_sil(A)  (strmatch(A,"sp") || strmatch(A,"silE") || strmatch(A,"silB"))
#endif

/* assign prob by class N-gram for words unknown in LM (experimental) */
#undef CLASS_NGRAM
#undef CLASS_UNKNOWN_ONLY
#undef CLASS_UNKNOWN_ONLY_SCALED

/* default value for transparent word insertion penalty */
#define TRANS_PENALTY_DEFAULT 0.0

/* '01/10/18 by ri: fix for trellis lookup order */
#define PREFER_CENTER_ON_TRELLIS_LOOKUP
