/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* vocabulary.h --- defines for vocabulary */

/* $Id: vocabulary.h,v 1.5 2002/09/11 22:01:50 ri Exp $ */

#ifndef __SENT_VOCA_H__
#define __SENT_VOCA_H__

#include <sent/stddefs.h>
#include <sent/htk_hmm.h>

/* original from ~speech/src/sent/hmm.h */
#define	MAXWSTEP 4000		/* step size of vocabulary */

/* Vocabulary information */
typedef struct word_info {
  WORD_ID	maxnum;		/* maximum allocated word num */
  WORD_ID	num;		/* total number of words */
  unsigned char	*wlen;		/* number of phones in the word [wid] */
  char		**wname;	/* word name string [wid] */
				/* DFA: category ID  N-gram: N-gram entry name */
  char		**woutput;	/* word output string [wid] */
  HMM_Logical   ***wseq;	/* phone sequence of each word [wid][0..wlen[wid]-1] */
  WORD_ID	*wton;		/* convert word ID to N-gram word ID [wid] */
  WORD_ID	head_silwid;	/* word ID of sentence head silence */
  WORD_ID	tail_silwid;	/* word ID of sentence tail silence */
  short		maxwn;		/* maximum number of HMM states per word */
  short         maxwlen;	/* maximum number of phones in a word */
  boolean	*is_transparent; /* TRUE if transparent word [wid] */
} WORD_INFO;


WORD_INFO *word_info_new();
void word_info_free(WORD_INFO *winfo);
void winfo_init(WORD_INFO *winfo);
void winfo_expand(WORD_INFO *winfo);
boolean init_voca(WORD_INFO *winfo, char *filename, HTK_HMM_INFO *hmminfo, boolean, boolean);
boolean voca_load_htkdict(FILE *, WORD_INFO *, HTK_HMM_INFO *, boolean);
boolean	voca_load_htkdict_fd(int, WORD_INFO *, HTK_HMM_INFO *, boolean);
void voca_append(WORD_INFO *dstinfo, WORD_INFO *srcinfo, int coffset, int woffset);

boolean voca_load_htkdict_line(char *buf, int vnum, WORD_INFO *winfo, HTK_HMM_INFO *hmminfo, boolean ignore_tri_conv, boolean do_conv, boolean *ok_flag);
boolean voca_mono2tri(WORD_INFO *winfo, HTK_HMM_INFO *hmminfo);
WORD_ID voca_lookup_wid(char *, WORD_INFO *);
WORD_ID *new_str2wordseq(WORD_INFO *, char *, int *);
char *cycle_triphone(char *p);
char *cycle_triphone_flush();
void print_voca_info(WORD_INFO *);

/* CCD ralated */
HTK_HMM_Data **new_make_triphone_seq(WORD_ID wseq[4], int *phlen, WORD_INFO *winfo, HTK_HMM_INFO *hmminfo);
HTK_HMM_Data *get_right_biphone(HTK_HMM_Data *p_base, HTK_HMM_Data *p_modifier, HTK_HMM_INFO *hmminfo);

void put_voca(WORD_INFO *winfo, WORD_ID wid);
void put_voca_err(WORD_INFO *winfo, WORD_ID wid);

/* HMMList check */
void make_base_phone(HTK_HMM_INFO *hmminfo, WORD_INFO *winfo);
void print_phone_info(HTK_HMM_INFO *hmminfo);
void print_all_basephone_detail(HMM_basephone *base);
void print_all_basephone_name(HMM_basephone *base);
void print_all_basephone(HMM_basephone *base);
void test_interword_triphone(HTK_HMM_INFO *hmminfo, WORD_INFO *winfo);

#endif /* __SENT_VOCA_H__ */
