// $Id$

//=============================================================================
/**
 *  @file    HSAlarmManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSALARMMANAGER_H
#define HSALARMMANAGER_H

#include "jyugem/gem/JGAlarmManager.h"

class BS2Message;
class BS2Item;

/*
 * Alarm manager class
 */
class BEE_Export HSAlarmManager: public JGAlarmManager
{
public:
    HSAlarmManager();
    ~HSAlarmManager();

    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);

    int setup(int tid, BYTE aled, JGid& alid);
    int setupAll(int tid, BYTE aled);
    BS2Message * enabled(BYTE aled, JGid& alid);
    BS2Message * allEnabled(BYTE aled);

    static HSAlarmManager * instance();

protected:
    BS2Message * alarmReport(BS2Message * msg);
    void         alarmAck(BS2Message * msg);
//
private:

};

#endif
