// $Id$

//=============================================================================
/**
 *  @file    HSControlManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSCONTROLMANAGER_H
#define HSCONTROLMANAGER_H

#include "jyugem/gem/JGControlManager.h"
#include "jyugem/gem/rcmd.h"
using namespace jyugem::cell;

class BS2Message;
class BS2Item;
class HeartbeatTimerHandler;

/*
 * Control manager class
 */
class BEE_Export HSControlManager: public JGControlManager
{
public:
    HSControlManager();
    ~HSControlManager();

    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);

    int loopback(int tid, const std::vector<any_item>& params);
    int heartbeat(int tid, const std::vector<any_item>& params);
    int  timer_id()         { return m_timerid.value(); }
    void timer_id(int tmid) { m_timerid = tmid; }

    static HSControlManager * instance();

//
protected:
    BS2Message * areYouThere(BS2Message * msg);
    BS2Message * onLineData(BS2Message * msg);
    int recvLoopback(BS2Message * msg);

    MUTEX_Int m_timerid;
    int m_expire;
    HeartbeatTimerHandler * m_heartbeat;
};

#endif
