// $Id$

//=============================================================================
/**
 *  @file    HSDevice.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSDEVICE_H
#define HSDEVICE_H

#include "jyugem/gem/JGTask.h"
#include "ace/OS.h"
#include "ace/INET_Addr.h"
#include "ace/SOCK_Stream.h"
#include "ace/SOCK_Acceptor.h"
#include "ace/SOCK_Connector.h"
#include "ace/Synch.h"

// Forward declaration
class  HSManager;

//-----------------------------------------------------------------------------
//
// Host Simulator Device
//
//-----------------------------------------------------------------------------
class BEE_Export HSDevice : public JGTask
{
    enum { ACTIVE = 0, PASSIVE };
public:
    HSDevice(HSManager * mngr = NULL)
        : JGTask(_TX("HSDevice")), m_manager(mngr), m_mode(ACTIVE), m_port(0),
          m_hostname(_TX("localhost")), m_hexdump(false), m_reqStop(0) {}
    HSDevice(HSManager * mngr, const BCHAR * hostname, short port,
               int mode = ACTIVE)
        : JGTask(_TX("HSDevice")), m_manager(mngr), m_mode(mode),
          m_hostname(), m_port(port), m_hexdump(false), m_reqStop(0) {}
    virtual ~HSDevice() {}

    virtual int init(void * argv = 0);
    virtual int svc(void);

    int send(const char * data, size_t dataSize, bool lengthSending = false);
    
    void hexdump(bool tf) { m_hexdump = tf; }
    bool hexdump()        { return m_hexdump; }
    void stop()           { m_reqStop = 1; }
//
protected:
    HSManager * m_manager;

    ACE_SOCK_Acceptor  m_peer_acceptor;
    ACE_SOCK_Connector m_con;
    ACE_SOCK_Stream    m_stream;
    ACE_INET_Addr      m_addr;
    int    m_mode;
    short  m_port;
    string m_hostname;

    bool   m_hexdump;
    int    m_reqStop;
    ACE_Thread_Mutex m_lock;
};

#endif
