// $Id$

//=============================================================================
/**
 *  @file    HSManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSMANAGER_H
#define HSMANAGER_H

#include "JGManager.h"

// Forward declaration

//-----------------------------------------------------------------------------
//
// GEM Management class
//
//-----------------------------------------------------------------------------
class BEE_Export HSManager
{
    friend class JGMessageRequest;
    friend class JGDeviceRequest;
    friend class JGOperatorRequest;
    friend class JGNotifyRequest;
    friend class JGRemoteRequest;

public:
    HSManager() {}
    ~HSManager() {}

    int sendAck(int secstid, int errcode);  // Send Ack to host

protected:
    virtual void comm_error(JGMessageTrigger * trigger);

protected:
    Transaction m_trans;
};


#endif
