// $Id$

//=============================================================================
/**
 *  @file    HSTerminalManager.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "HSTerminalManager.h"
#include "HSServer.h"
#include "HSInfoManager.h"
#include "HSSECSDevice.h"
#include "jyugem/gem/JGTaskTrigger.h"
#include "BS2ACKMessage.h"
#include "BS2ErrorMessage.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"

static HSTerminalManager * _manager = NULL;

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
HSTerminalManager::HSTerminalManager() : JGTerminalManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "HSTerminalManager::HSTerminalManager");
}

//-----------------------------------------------------------------------------
HSTerminalManager::~HSTerminalManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "HSTerminalManager::~HSTerminalManager");

}

//-----------------------------------------------------------------------------
// Return own.
//-----------------------------------------------------------------------------
HSTerminalManager * HSTerminalManager::instance()
{
    TRACE_FUNCTION(TRL_LOW, "HSTerminalManager::instance");
    if (_manager == NULL)
    {
        _manager = new HSTerminalManager;
    }
    return _manager;
}

//-----------------------------------------------------------------------------
// Initialize
//-----------------------------------------------------------------------------
int HSTerminalManager::init(void * param)
{
    TRACE_FUNCTION(TRL_LOW, "HSTerminalManager::init");
    ACE_UNUSED_ARG(param);

    return 0;
}

//-----------------------------------------------------------------------------
// Terminal Display, Single message (S10F3)
//-----------------------------------------------------------------------------
int HSTerminalManager::display(int tid, int termid, const string& text)
{
    TRACE_FUNCTION(TRL_LOW, "HSTerminalManager::display");

    BS2Message * msg = this->makeBlock(termid, text);
    int result = this->send(msg, tid);
    return result;
}

//-----------------------------------------------------------------------------
// Terminal Display, Single message (S10F5)
//-----------------------------------------------------------------------------
int HSTerminalManager::display(int tid, int termid, vector<string>& texts)
{
    TRACE_FUNCTION(TRL_LOW, "HSTerminalManager::display");

    BS2Message * msg = this->makeBlock(termid, texts);
    int result = this->send(msg, tid);
    return result;
}

//-----------------------------------------------------------------------------
// Make Single message (S10F3)
//-----------------------------------------------------------------------------
BS2Message * HSTerminalManager::makeBlock(int tid , const string& text)
{
    TRACE_FUNCTION(TRL_LOW, "HSTerminalManager::dispBlock");

    BS2Message * msg = BS2Message::factory(SFCODE(10,3));
    BS2ListItem * rootlist = new BS2ListItem;

    BS2Atom * atom = new BS2Binary((BYTE)(tid & 0xFF));
    BS2Item * item = BS2Item::factory(_TX("TID"), atom);
    rootlist->add(item);

    item = BS2Item::factory(_TX("TEXT"), new BS2Ascii(text));
    rootlist->add(item);

    msg->add(rootlist);
    return msg;
}

//-----------------------------------------------------------------------------
// Make Single message (S10F5)
//-----------------------------------------------------------------------------
BS2Message * HSTerminalManager::makeBlock(int tid , vector<string>& texts)
{
    TRACE_FUNCTION(TRL_LOW, "HSTerminalManager::dispBlock");

    BS2Message * msg = BS2Message::factory(SFCODE(10,3));
    BS2ListItem * rootlist = new BS2ListItem;

    BS2Atom * atom = new BS2Binary((BYTE)(tid & 0xFF));
    BS2Item * item = BS2Item::factory(_TX("TID"), atom);
    rootlist->add(item);

    BS2ListItem * txlist = new BS2ListItem;
    for (size_t i = 0; i < texts.size(); i++)
    {
        item = BS2Item::factory(_TX("TEXT"), new BS2Ascii(texts[i]));
        txlist->add(item);
    }
    rootlist->add(txlist);

    msg->add(rootlist);
    return msg;
}


//-----------------------------------------------------------------------------
// Thread of received trigger event.
//-----------------------------------------------------------------------------
BS2Message * HSTerminalManager::msg_svc(JGMessageTrigger * trigger,
                                        BS2Message * msg)
{
    ACE_UNUSED_ARG(trigger);
    BS2Message * replymsg = NULL;

    if (msg->sf() == SFCODE(10,4))
    {
    }
    else if (msg->sf() == SFCODE(10,6))
    {
    }
    else
    {   // Unexpected message
        replymsg = this->unrecognized(msg);
    }
    return replymsg;
}



