// $Id$

//=============================================================================
/**
 *  @file    VFEIEventTraverser.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef VFEIEVENTTRAVERSER_H
#define VFEIEVENTTRAVERSER_H

#include "jyugem/gem/JGObject.h"
#include "jyugem/gem/JGErrorList.h"
#include "BS2Traverser.h"
#include "BS2Atom.h"

class JGManager;
class JGClass;
class JGSpecification;
class JGEvent;
class JGReport;
class JGVariable;
class BS2List;

//
// Parser of SECS Message
//
class VFEIEventTraverser : public BS2Traverser
{
    friend class JGEventManager;
public:

    enum { VLIST_DEPTH = 5 };

    VFEIEventTraverser(JGEventManager * mngr, int sf);
    virtual ~VFEIEventTraverser() {}

    // Implementation for object parameters
    virtual int parseItem(BS2Item * item);

    int addItemValue(JGvalue& val, const string& itemName, int reqFormat,
                     string& vfeibuf);
    int addEnumValue(JGvalue& val, const string& itemName,
                     b_enumerator * enumptr, string& vfeibuf);
    int addValue(JGvalue& val, int itemFormat, string& vfeibuf);

    int parseListAtom(JGVariable * var, BS2List * listatom, string& vfeibuf);
    int parseClassAtom(JGClass * clazz, BS2Atoms& atoms, string& vfeibuf);
    int parseAttrAtom(JGAttribute * attr, BS2Atom * atom, string& vfeibuf);
    int parseRemains();

    //
    // Print list head/tail.
    //
    inline void addListHeader(const string& itemName, int itemFormat,
                              int size, string& vfeibuf)
    {
        char buf[64];
        sprintf(buf, "%d", size);

        if (itemName.size() > 0)
        {
            vfeibuf += itemName;
            vfeibuf += "/";
        }
        //if (itemFormat == ATOM_LIST)
        //    vfeibuf += "L";
        //else
        //    vfeibuf += b_value::smlStr(itemFormat);
        vfeibuf += b_value::smlStr(itemFormat);
        vfeibuf += "[";
        vfeibuf += buf;
        vfeibuf += "]=[";
    }

    inline void addListTail(string& vfeibuf)
    {
        vfeibuf += "]";
    }

    //
    // Print head/tail message that is vector (=array) item
    //
    inline void addVectHeader(const string& itemName, int itemFormat,
                              int size, string& vfeibuf)
    {
        char buf[64];
        sprintf(buf, "%d", size);

        if (itemName.size() > 0)
        {
            vfeibuf += itemName;
            vfeibuf += "/";
        }
        //if (itemFormat == ATOM_LIST)
        //    vfeibuf += "L";
        //else
        //    vfeibuf += b_value::smlStr(itemFormat);
        vfeibuf += b_value::smlStr(itemFormat);
        vfeibuf += "[";
        vfeibuf += buf;
        vfeibuf += "]=[";
    }

    inline void addVectTail(string& vfeibuf)
    {
        vfeibuf += "]";
    }

    // Deside the position of ID/DATA
    virtual int beginList(BS2ListItem * listitem);
    virtual int endList(BS2ListItem * listitem);
    virtual int beginValueList(BS2Item * item);

protected:
    JGEventManager *  m_manager;
    JGSpecification * m_spec;
    int    m_sf;
    string m_vfei;
    string m_vfeimsg;

    JGvalue    m_dataid;
    JGEvent *  m_event;
    JGReport * m_report;
    JGVariable * m_variable;
    int    m_rptnum;
    int    m_varnum;

    //string m_itemName;        // current item name (require)
    //int    m_itemFormat;      // current item format (require)

    bool          m_first;
    JGClass *     m_objtype;
    JGAttribute * m_attribute;
    int           m_attrnum;
};

#endif
