// $Id$

//=============================================================================
/**
 *  @file    for_expression.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================
#ifndef JYUGEM_BEE_FOR_EXPRESSION_H
#define JYUGEM_BEE_FOR_EXPRESSION_H

#include "sequencer.h"

namespace jyugem { namespace bee
{

temptate<class EXP, class T>
struct BEE_Export for_expression : public expression<EXP, T>
{
    typedef sequencer<T>       seq_type;
    typedef expression<EXP, T> expression_base;

    for_expression(step * node) : expression_base()
    {
        m_act.push_back(node);
    }
    for_expression(seq_type * sqcr, const string& cond,
                   std::vector<step *>& nodes) : expression_base(sqcr, cond)
    {
        m_act.push_back(node);
    }
    virtual ~for_expression() {}

    virtual int evalute(T * context)
    {
        while (m_test.evaluate())
        {
            BEEAssert(m_act[0] != null);
            return m_act[0]->evaluate(context);
        }
        return 0;
    }
};


} } // *namespace*

#endif
