// $Id$

//=============================================================================
/**
 *  @file    sequencer.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JYUGEM_BEE_SEQUENCER_H
#define JYUGEM_BEE_SEQUENCER_H

namespace jyugem { namespace bee
{

//-----------------------------------------------------------------------------
//
// Sequencer
//
//-----------------------------------------------------------------------------
template<class T>
struct BEE_Export sequencer
{
    struct step
    {
        step(sequencer * sqcr = NULL) : m_sequencer(sqcr) {}
        virtual ~step() {}

        virtual bool terminate() { return false; }
        virtual int  evaluate(T *) = 0;

        sequencer * m_sequencer;
    };

    struct terminate_step : public step
    {
        terminate_step(sequencer * sqcr = NULL) : step(sqcr) {}
        virtual ~terminate_step() {}

        virtual bool terminate()   { return true; }
        virtual int  evaluate(T *) { return -1; }
    };

    // Constructor/Destructor
    sequencer()  : m_context(NULL), m_reqstop(false), m_num(0),
                   m_current(NULL) {}
    sequencer(T * context) : m_context(context), m_reqstop(false), m_num(0),
                             m_current(NULL) {}
    virtual ~sequencer() {}

    void context(T * ctx) { m_context = ctx; }
    int  add(step * step)
    {
        m_steps.push_back(step);
        return 0;
    }
    // int insert(int pos, step * step);
    // int remove(int pos);

    virtual int run()
    {
        int result = this->start();
        while (result >= 0)
        {
            result = this->next();
        }
        return result;
    }
    virtual int stop() { m_reqstop = true; return 0; }

    int start()
    {
        m_num = 0;
        m_current = m_steps[m_num];
        return m_current->evaluate(m_context);
    }
    int next()
    {
        m_num++;
        if (m_num >= m_steps.size() || m_reqstop)
        {
            return -1;
        }
        m_current = m_steps[m_num];
        return m_current->evaluate(m_context);
    }
    int go(int stepid)
    {
        if ((size_t)stepid >= m_steps.size() || m_reqstop)
        {
            return -1;
        }
        m_num = (size_t)stepid;
        return 0;
    }

protected:
    T * m_context;
    bool   m_reqstop;
    size_t m_num;
    step * m_current;
    std::vector<step *> m_steps;
};

} } // *namespace*

#endif
