// $Id$

//=============================================================================
/**
 *  @file    host_message.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JYUGEM_CELL_HOST_MESSAGE_HPP
#define JYUGEM_CELL_HOST_MESSAGE_HPP

#include "jyugem/cell/vfei.h"
#include "jyugem/gem/rcmd.h"

class HSMainManager;
class BS2Message;

namespace jyugem { namespace cell
{


typedef HSMainManager main_manager;
typedef BS2Message    secs_message;

//
struct host_message : public rcmd
{
    host_message(main_manager * mngr) : rcmd(), m_manager(mngr),
                                        m_indent(_TX("")) {}
    virtual ~host_message() {}

    virtual int toVfei(std::string& outstr);
    virtual int toXml(std::string& outstr);

    static host_message * factory(main_manager *, std::string&);
    static host_message * factory(main_manager *, int);

protected:
    bool toBoolean(const any_item& itemptr);

    main_manager * m_manager;
    std::string m_indent;
};

//-----------------------------------------------------------------------------
//
// VFEI Massages
//
//-----------------------------------------------------------------------------
struct abort_message : public host_message
{
    abort_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);

    int m_level;
};

//-----------------------------------------------------------------------------
// implement in alarm_report_message
struct report_message : public host_message
{
    report_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);

    int         m_errcode;
    std::string m_errtext;
    std::string m_file;
};

//-----------------------------------------------------------------------------
struct alarm_report_message : public report_message
{
    alarm_report_message(main_manager * mngr) : report_message(mngr) {}
    alarm_report_message(main_manager * mngr, const std::string& mid,
                         int alid, bool alstate, const std::string& altx,
                         BYTE alcd, int errcode, const std::string& errtext)
        : report_message(mngr), m_alid(alid), m_alstate(alstate), m_altx(altx),
          m_alcd(alcd)
    {
        m_devid = mid;
        m_errcode = errcode;
        m_errtext = errtext;
    }
    virtual void append(const any_item& mbr);
    virtual int  toVfei(std::string& outstr);
    virtual int  toXml(std::string& outstr);

    int  m_alid;
    bool m_alstate;
    std::string m_altx;
    BYTE m_alcd;
};

//-----------------------------------------------------------------------------
struct alarm_setup_message : public host_message
{
    alarm_setup_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);

    bool m_enable;
    std::vector<std::string> m_alids;
};

//-----------------------------------------------------------------------------
struct cmd_ack_message : public host_message
{
    cmd_ack_message(main_manager * mngr) : host_message(mngr) {}
    cmd_ack_message(main_manager * mngr, const std::string& mid,
                    int tid, int errcode, const std::string& errtext)
        : host_message(mngr)
    {
        m_devid = mid;
        m_tid = tid;
        m_errcode = errcode;
        m_errtext = errtext;
    }

    virtual void append(const any_item& mbr);
    virtual int  toVfei(std::string& outstr);
    virtual int  toXml(std::string& outstr);

    int         m_errcode;
    std::string m_errtext;
};

//-----------------------------------------------------------------------------
struct display_message : public host_message
{
    display_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);

    int         m_terminal;
    std::string m_text;
};

//-----------------------------------------------------------------------------
struct event_report_message : public report_message
{
    event_report_message(main_manager * mngr) : report_message(mngr) {}
    event_report_message(main_manager * mngr, const std::string& mid,
                         const std::string& ceid, const std::string& rpt,
                         const std::string& fname,
                         int errcode, const std::string& errtext)
        : report_message(mngr), m_ceid(ceid), m_reports(rpt), m_filename(fname)
    {
        m_devid = mid;
        m_errcode = errcode;
        m_errtext = errtext;
    }

    virtual void append(const any_item& mbr);
    virtual int  toVfei(std::string& outstr);
    virtual int  toXml(std::string& outstr);

    std::string m_ceid;
    std::string m_filename;
    std::string m_reports;
};

//-----------------------------------------------------------------------------
struct event_setup_message : public host_message
{
    event_setup_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);

    bool m_enable;
    std::vector<std::string> m_ceids;
    std::vector<std::string> m_vars;
    std::string m_dir;
    std::string m_mbcid;
    std::string m_mbcsize;
    std::string m_ppid;
};

//-----------------------------------------------------------------------------
struct initialize_message : public host_message
{
    initialize_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);
};

//-----------------------------------------------------------------------------
struct mach_cmd_message : public host_message
{
    mach_cmd_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);

    std::string m_command_type;
};

//-----------------------------------------------------------------------------
struct move_message : public host_message
{
    move_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);

    std::string m_tg_type;
    std::string m_tg_id;
    std::string m_src_location;
    std::string m_dest_location;
    std::string m_src_port;
    std::string m_dest_port;
};

//-----------------------------------------------------------------------------
struct pause_message : public host_message
{
    pause_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);
};

//-----------------------------------------------------------------------------
// implement in res_act_message.cpp
struct resource_message : public host_message
{
    resource_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);

    std::string m_type;
    std::vector<std::string> m_resid;
};

//-----------------------------------------------------------------------------
struct res_activate_message : public resource_message
{
    res_activate_message(main_manager * mngr) : resource_message(mngr) {}

    virtual void append(const any_item& mbr);
};

//-----------------------------------------------------------------------------
struct res_deactivate_message : public resource_message
{
    res_deactivate_message(main_manager * mngr) : resource_message(mngr) {}

    virtual void append(const any_item& mbr);
};

//-----------------------------------------------------------------------------
struct res_delete_message : public resource_message
{
    res_delete_message(main_manager * mngr) : resource_message(mngr) {}

    virtual void append(const any_item& mbr);
};

//-----------------------------------------------------------------------------
struct res_list_message : public report_message
{
    res_list_message(main_manager * mngr) : report_message(mngr) {}
    res_list_message(main_manager * mngr, const std::string& mid, int tid,
                     const std::string& type,
                     const std::vector<std::string>& resids,
                     const std::string& fname,
                     int errcode, const std::string& errtext)
        : report_message(mngr), m_type(type), m_resid(resids)
    {
        m_devid = mid;
        m_tid = tid;
        m_file = fname;
        m_errcode = errcode;
        m_errtext = errtext;
    }

    virtual int  toVfei(std::string& outstr);
    virtual int  toXml(std::string& outstr);

    std::string m_type;
    std::vector<std::string> m_resid;
};

//-----------------------------------------------------------------------------
struct res_query_message : public resource_message
{
    res_query_message(main_manager * mngr) : resource_message(mngr) {}

    virtual void append(const any_item& mbr);

    std::string m_file;
};

//-----------------------------------------------------------------------------
struct res_request_message : public resource_message
{
    res_request_message(main_manager * mngr) : resource_message(mngr) {}

    virtual void append(const any_item& mbr);

    std::string m_file;
};

//-----------------------------------------------------------------------------
struct res_transfer_message : public host_message
{
    res_transfer_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);

    std::string m_type;
    std::string m_resid;
    size_t      m_length;
    const char * m_body;
    std::string m_file;
    std::string m_src;
    std::string m_dest;
};

//-----------------------------------------------------------------------------
struct restart_message : public report_message
{
    restart_message(main_manager * mngr) : report_message(mngr) {}
    restart_message(main_manager * mngr, const std::string& mid, int errcode,
                    const std::string& errtext) : report_message(mngr)
    {
        m_devid = mid;
        m_errcode = errcode;
        m_errtext = errtext;
    }

    virtual int  toVfei(std::string& outstr);
    virtual int  toXml(std::string& outstr);
};

//-----------------------------------------------------------------------------
struct resume_message : public host_message
{
    resume_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);
};

//-----------------------------------------------------------------------------
struct set_param_message : public host_message
{
    set_param_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);

    std::string m_type;
};

//-----------------------------------------------------------------------------
struct start_message : public host_message
{
    start_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);
};

//-----------------------------------------------------------------------------
struct status_list_message : public report_message
{
    status_list_message(main_manager * mngr) : report_message(mngr) {}
    status_list_message(main_manager * mngr, const std::string& mid, int tid,
                        const std::string& status, const std::string& fname,
                        int errcode,
                        const std::string& errtext)
        : report_message(mngr), m_status(status)
    {
        m_devid = mid;
        m_tid = tid;
        m_file = fname;
        m_errcode = errcode;
        m_errtext = errtext;
    }

    virtual int  toVfei(std::string& outstr);
    virtual int  toXml(std::string& outstr);

    std::string m_status;
};

//-----------------------------------------------------------------------------
struct status_query_message : public host_message
{
    status_query_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);

    std::vector<std::string> m_vids;
    std::string m_file;
};

//-----------------------------------------------------------------------------
struct trace_report_message : public report_message
{
    trace_report_message(main_manager * mngr) : report_message(mngr) {}
    trace_report_message(main_manager * mngr, const std::string& mid,
                         int trace_id, int trace_size, const std::string& rpt,
                         const std::string& fname,
                         int errcode, const std::string& errtext)
        : report_message(mngr), m_traceid(trace_id), m_rptsize(trace_size),
          m_reports(rpt)
    {
        m_devid = mid;
        m_file = fname;
        m_errcode = errcode;
        m_errtext = errtext;
    }

    virtual void append(const any_item& mbr);
    virtual int  toVfei(std::string& outstr);
    virtual int  toXml(std::string& outstr);

    USHORT m_traceid;
    USHORT m_rptsize;
    std::string m_reports;
};

//-----------------------------------------------------------------------------
struct trace_setup_message : public host_message
{
    trace_setup_message(main_manager * mngr) : host_message(mngr) {}

    virtual void append(const any_item& mbr);

    bool   m_enable;
    USHORT m_traceid;
    UINT   m_frequency;
    USHORT m_sample;
    USHORT m_rptsize;
    std::string m_dir;
    std::vector<std::string> m_vids;
};

} }  // *jyugem::cell*

#endif  // JYUGEM_CELL_MESSAGE_HPP
