// $Id$

//=============================================================================
/**
 *  @file    JGEquipmentManager.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================


#ifndef JGEQUIPMENTMANAGER_H
#define JGEQUIPMENTMANAGER_H

#include "jyugem/gem/JGTask.h"

class JGEquipment;

//-----------------------------------------------------------------------------
// Equipment Parameter
//-----------------------------------------------------------------------------
struct EquipmentParam
{
    string m_devname;
    string m_root;
    string m_logparam;
    void * m_config;

    EquipmentParam() : m_devname(_TX("")), m_root(_TX("")),
                       m_logparam(_TX("")), m_config(NULL) {}
    EquipmentParam(const EquipmentParam& rhs) { this->copy(rhs); }
    ~EquipmentParam() {}
    EquipmentParam& operator=(const EquipmentParam& rhs)
    {
        if (this != &rhs)
            this->copy(rhs);
        return *this;
    }

    void copy(const EquipmentParam& rhs)
    {
        m_devname = rhs.m_devname;
        m_root = rhs.m_root;
        m_logparam = rhs.m_logparam;
        m_config = rhs.m_config;
    }
};

//-----------------------------------------------------------------------------
//
// Equipment Manager
//
//-----------------------------------------------------------------------------
class BEE_Export JGEquipmentManager: public JGTask
{
public:
    JGEquipmentManager();
    JGEquipmentManager(const string& name, const BCHAR * logParam = NULL);
    virtual ~JGEquipmentManager();

    typedef map<string, JGEquipment *, std::less<string> > EquipmentMap;

    virtual int svc(void);
    virtual int init(void * argv = 0);

    JGEquipment * equipment(const string& devname = _TX(""));
    int  act_equipments(void * param = NULL);
    int  stop_equipments(u_long param = 0);
    void dump() const;
//
    static JGEquipmentManager * instance();
    static JGEquipmentManager * instance(JGEquipmentManager * app);
//
protected:
    int  start_log(void * argv = 0);

protected:
    string        m_root;
    JGEquipment * m_represent;
    EquipmentMap  m_equipments;
};

#endif
