// $Id: JGLogTime.h,v 1.1 2003/02/02 15:56:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGLogTime.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGLOGTIME_H
#define JGLOGTIME_H

#include "jyugem/gem/gembase.h"
#include "b_time.h"

//-----------------------------------------------------------------------------
// Log time class.
//-----------------------------------------------------------------------------
class BEE_Export JGLogTime : public b_time
{
public:
    JGLogTime(bool now = true);
    JGLogTime(const struct tm& tv)      : b_time(tv) {}
    JGLogTime(const ACE_Time_Value& tv) : b_time(tv) {}
    JGLogTime(const JGLogTime& rhs)       : b_time(rhs) {}
    ~JGLogTime() {}

    JGLogTime& operator=(const JGLogTime& rhs) {
            if (this == &rhs)
                return *this;
            this->b_time::copy(rhs);
            return *this;
        }

    static UINT lapse(time_t curtime);
    static int  makeDateName(time_t curtime, string& tvname);

};


#endif  // JGLOGTIME_H
